/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAdaptor;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.appserver._private.WOWorkerThread;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

public class WODefaultAdaptor
extends WOAdaptor {
    private static final int _WO_LIMITED_MAX_THREADS_ = 16;
    private static final int _WO_MIN_THREADS_ = 4;
    private static final int _WO_MAX_SOCKET_IDLE_ = 180000;
    private static final int _WO_UNSET_PORT_ = 0;
    private static final int _WO_LISTEN_QUEUE_ = 128;
    private static final int _WO_WINDOW_RATIO_ = 4;
    private static final float _WO_GROW_RATIO_ = 2.0f;
    static WOResponse _lastDitchErrorResponse;
    private ServerSocket _listenSocket = null;
    private NSMutableArray _workerThreads;
    private boolean _registered = false;
    private boolean _restricted;
    private int _port;
    private InetAddress _host;
    private int _listenQueueSize;
    private int _maxSocketIdleTime;
    private int _maxWorkerThreads;
    private Object _lock = new Object();
    private int __nmbOfWorkerThreads;
    private int __nmbOfActiveThreads;
    private int __windowSize;
    private volatile boolean _shouldGrow = false;

    protected WODefaultAdaptor(String string, NSDictionary nSDictionary, boolean bl) {
        super(string, nSDictionary);
        Number number;
        String string2;
        Number number2 = (Number)nSDictionary.objectForKey((Object)WOProperties._PortKey);
        if (number2 != null) {
            this._port = number2.intValue();
        }
        if (this._port < 0) {
            this._port = 0;
        }
        if ((string2 = (String)nSDictionary.objectForKey((Object)WOProperties._HostKey)) != null) {
            try {
                this._host = InetAddress.getByName(string2);
                WOApplication.application()._unsetHost = false;
            }
            catch (UnknownHostException unknownHostException) {
                NSLog.err.appendln((Object)(this.toString() + " Failed to get address for " + string2 + " defaulting to localhost"));
            }
        }
        if (this._host == null) {
            try {
                this._host = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                NSLog.err.appendln((Object)(this.toString() + " Failed to get localhost address"));
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)unknownHostException);
            }
        }
        this._maxSocketIdleTime = (number = (Number)nSDictionary.objectForKey((Object)WOProperties._MaxSocketIdleTimeKey)) != null ? number.intValue() : 180000;
        Number number3 = (Number)nSDictionary.objectForKey((Object)WOProperties._ListenQueueSizeKey);
        this._listenQueueSize = number3 != null ? number3.intValue() : 128;
        Number number4 = (Number)nSDictionary.objectForKey((Object)WOProperties._WorkerThreadCountMinKey);
        if (number4 == null) {
            number4 = (Number)nSDictionary.objectForKey((Object)WOProperties._WorkerThreadCountKey);
            if (number4 == null) {
                NSLog.err.appendln((Object)"WOWorkerThreadCountMin not set; defaulting to 4");
                number4 = _NSUtilities.IntegerForInt((int)4);
            } else {
                NSLog.err.appendln((Object)("WOWorkerThreadCountMin not set; defaulting to WOWorkerThreadCount value: " + number4));
            }
        }
        this._setNmbOfWorkerThreads(number4.intValue());
        Number number5 = (Number)nSDictionary.objectForKey((Object)WOProperties._WorkerThreadCountMaxKey);
        if (number5 == null) {
            number5 = number3;
            if (number5 == null) {
                NSLog.err.appendln((Object)"WOWorkerThreadCountMax not set; defaulting to infinite (-1).");
                number5 = _NSUtilities.IntegerForInt((int)-1);
            } else {
                NSLog.err.appendln((Object)("WOWorkerThreadCountMax not set; defaulting to WOListenQueueSize value: " + number5));
            }
        }
        this._maxWorkerThreads = number5.intValue();
        if (this._nmbOfWorkerThreads() <= 0) {
            this._setNmbOfWorkerThreads(4);
            NSLog.err.appendln((Object)"*** WOWorkerThreadCount = 0 is no longer supported.  WOWorkerThreadCount has been set to 4");
            NSLog.err.appendln((Object)"Note: NSTimer.fire() and Object.finalize() will be invoked from threads other than the worker thread.");
        }
        boolean bl2 = this._restricted = WOApplication.licensedRequestLimit() != 0;
        if (this._maxWorkerThreads > 0 && this._nmbOfWorkerThreads() > this._maxWorkerThreads) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + " WOWorkerThreadCountMin must be less than WOWorkerThreadCountMax unless WOWorkerThreadCountMax is set to -1 for infinite growth");
        }
        if (this._maxWorkerThreads > 0 && this._maxWorkerThreads < 16) {
            NSLog.err.appendln((Object)"The maximum number of WOWorkerThreads is very low; this could lead to dropped or refused connections");
        }
        WOApplication.application().setWorkerThreadCountMin(_NSUtilities.IntegerForInt((int)this._nmbOfWorkerThreads()));
        WOApplication.application().setWorkerThreadCountMax(_NSUtilities.IntegerForInt((int)this._maxWorkerThreads));
        this._initServerSocket(bl);
        _lastDitchErrorResponse = new WOResponse();
        _lastDitchErrorResponse.setStatus(500);
        _lastDitchErrorResponse.appendContentString("An Internal Server Error Has Occurred.");
        WOApplication.application().debugString("Created adaptor of class " + string + " on port " + this._port + " and address " + this._host + " with WOWorkerThread minimum of " + this._nmbOfWorkerThreads() + " and maximum of " + this._maxWorkerThreads);
    }

    public WODefaultAdaptor(String string, NSDictionary nSDictionary) {
        this(string, nSDictionary, false);
    }

    private char[] _getSSLPassphrase() {
        try {
            String string;
            String string2 = NSBundle.mainBundle().resourcePathForLocalizedResourceNamed("adaptorsslpassphrase", null);
            URL uRL = NSBundle.mainBundle().pathURLForResourcePath(string2);
            String string3 = string = uRL != null ? (string = uRL.getPath()) : null;
            if (string != null) {
                Process process = Runtime.getRuntime().exec(string);
                InputStream inputStream = process.getInputStream();
                process.waitFor();
                int n = inputStream.available();
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                return new String(byArray).trim().toCharArray();
            }
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)"Unable to read ssl passphrase.");
        }
        return "".toCharArray();
    }

    private void _initServerSocket(boolean bl) {
        if (this._listenSocket == null) {
            if (bl) {
                try {
                    String string = "adaptorssl.key";
                    char[] cArray = this._getSSLPassphrase();
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(WOApplication.application().createResourceManager().inputStreamForResourceNamed(string, null, null), cArray);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(keyStore, cArray);
                    SSLContext sSLContext = SSLContext.getInstance("SSLv3");
                    sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
                    SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
                    if (WOApplication.application()._unsetHost) {
                        this._listenSocket = sSLServerSocketFactory.createServerSocket(this._port, this._listenQueueSize);
                    }
                    this._listenSocket = sSLServerSocketFactory.createServerSocket(this._port, this._listenQueueSize, this._host);
                }
                catch (Exception exception) {
                    NSLog.err.appendln((Object)("Unable to establish an SSL connection to port " + this._port + " on this host.  Perhaps this port is already in use by another WebObjects application instance."));
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
                }
            } else {
                try {
                    this._listenSocket = WOApplication.application()._unsetHost ? new ServerSocket(this._port, this._listenQueueSize) : new ServerSocket(this._port, this._listenQueueSize, this._host);
                    this._port = this._listenSocket.getLocalPort();
                    WOApplication.application().setPort(new Integer(this._port));
                    WOApplication.application()._setHostAddress(this._host);
                }
                catch (IOException iOException) {
                    NSLog.err.appendln((Object)("Unable to establish a connection to port " + this._port + " on this host.  Perhaps this port is already in use by another WebObjects application instance."));
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)iOException);
                }
            }
        }
    }

    public synchronized void registerForEvents(boolean bl) {
        if (this._registered) {
            throw new IllegalStateException("<" + this.getClass().getName() + ">: already registered. Unregister first!");
        }
        this._initServerSocket(bl);
        this.__windowSize = this._nmbOfWorkerThreads() / 4;
        this._workerThreads = this._maxWorkerThreads <= 0 ? new NSMutableArray(this._nmbOfWorkerThreads()) : new NSMutableArray(this._maxWorkerThreads);
        for (int i = 0; i < this._nmbOfWorkerThreads(); ++i) {
            this._workerThreads.addObject((Object)new WOWorkerThread(this, this._listenSocket, this._maxSocketIdleTime, this._restricted, i));
        }
        this._shouldGrow = true;
        this._registered = true;
    }

    public synchronized void registerForEvents() {
        this.registerForEvents(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterForEvents() {
        int n;
        if (!this._registered) {
            throw new IllegalStateException("<" + this.getClass().getName() + ">: already unregistered. Register first!");
        }
        Object object = this._lock;
        synchronized (object) {
            this._shouldGrow = false;
        }
        for (n = 0; n < this._nmbOfWorkerThreads(); ++n) {
            ((WOWorkerThread)this._workerThreads.objectAtIndex((int)n))._runFlag = false;
        }
        do {
            n = 0;
            for (int i = 0; i < this._nmbOfWorkerThreads(); ++i) {
                if (!((WOWorkerThread)this._workerThreads.objectAtIndex((int)i))._processingRequest) continue;
                n = 1;
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                NSLog._conditionallyLogPrivateException((Throwable)interruptedException);
            }
        } while (n != 0);
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)16L)) {
            NSLog.debug.appendln((Object)("<" + this.getClass().getName() + ">: All worker threads finished processing"));
        }
        this._registered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementActiveThreads() {
        Object object = this._lock;
        synchronized (object) {
            ++this.__nmbOfActiveThreads;
            if (this._shouldGrow && this.__nmbOfWorkerThreads - this.__nmbOfActiveThreads <= this.__windowSize) {
                int n = (int)((float)this.__nmbOfWorkerThreads * 2.0f);
                int n2 = n - this.__nmbOfWorkerThreads;
                if (this._maxWorkerThreads > 0 && n >= this._maxWorkerThreads) {
                    n2 = this._maxWorkerThreads - this.__nmbOfWorkerThreads;
                    this._shouldGrow = false;
                }
                for (int i = 0; i < n2; ++i) {
                    this._workerThreads.addObject((Object)new WOWorkerThread(this, this._listenSocket, this._maxSocketIdleTime, this._restricted, this.__nmbOfWorkerThreads++));
                }
                this.__windowSize = this.__nmbOfWorkerThreads / 4;
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8196L)) {
                    NSLog.debug.appendln((Object)("<" + this.getClass().getName() + ">: Growing number of WOWorkerThreads to " + this.__nmbOfWorkerThreads));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementActiveThreads() {
        Object object = this._lock;
        synchronized (object) {
            --this.__nmbOfActiveThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _nmbOfWorkerThreads() {
        Object object = this._lock;
        synchronized (object) {
            return this.__nmbOfWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setNmbOfWorkerThreads(int n) {
        Object object = this._lock;
        synchronized (object) {
            this.__nmbOfWorkerThreads = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _nmbOfActiveThreads() {
        Object object = this._lock;
        synchronized (object) {
            return this.__nmbOfActiveThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setNmbOfActiveThreads(int n) {
        Object object = this._lock;
        synchronized (object) {
            this.__nmbOfActiveThreads = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _windowSize() {
        Object object = this._lock;
        synchronized (object) {
            return this.__windowSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setWindowSize(int n) {
        Object object = this._lock;
        synchronized (object) {
            this.__windowSize = n;
        }
    }

    public int port() {
        return this._port;
    }

    public boolean dispatchesRequestsConcurrently() {
        return true;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " _maxWorkerThreads=" + this._maxWorkerThreads + " nmbOfWorkerThreads=" + this._nmbOfWorkerThreads() + " _nmbOfActiveThreads=" + this._nmbOfActiveThreads() + " _windowSize=" + this._windowSize() + " restricted=" + this._restricted + " port=" + this._port + " dispatchesRequestsConcurrentlyFlag=true" + " listenSocket=" + this._listenSocket + ">";
    }
}

