/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class WOElementID
implements Serializable {
    static final long serialVersionUID = 5682628968228856971L;
    char[] _elementID;
    transient String _elementIDString;
    transient int _size;
    int _lastDot;
    private int DefaultSize = 256;

    public WOElementID(String string) {
        if (string != null) {
            this._elementID = string.toCharArray();
            this._size = string.length();
        } else {
            this._elementID = new char[this.DefaultSize];
            this._size = 0;
        }
        this._lastDot = this._lastDotPosition();
        this._elementIDString = null;
    }

    public String toString() {
        if (this._elementIDString == null) {
            this._elementIDString = new String(this._elementID, 0, this._size);
        }
        return this._elementIDString;
    }

    private int _lastDotPosition() {
        int n;
        for (n = this._size - 1; n >= 0 && this._elementID[n] != '.'; --n) {
        }
        return n;
    }

    private void _makeFit(int n) {
        char[] cArray = new char[n * 2];
        System.arraycopy(this._elementID, 0, cArray, 0, this._size);
        this._elementID = cArray;
    }

    private void _appendChar(char c) {
        if (this._size + 1 > this._elementID.length) {
            this._makeFit(this._size + 1);
        }
        this._elementID[this._size] = c;
        ++this._size;
    }

    private void _appendChars(char[] cArray) {
        int n = cArray.length;
        if (this._size + n > this._elementID.length) {
            this._makeFit(this._size + n);
        }
        System.arraycopy(cArray, 0, this._elementID, this._size, n);
        this._size += n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this._elementID);
        objectOutputStream.writeInt(this._lastDot);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._elementID = (char[])objectInputStream.readObject();
        this._lastDot = objectInputStream.readInt();
        this._elementIDString = new String(this._elementID);
        this._size = this._elementID.length;
    }

    public void appendElementIDComponent(String string) {
        this._elementIDString = null;
        if (this._size != 0) {
            this._appendChar('.');
            this._lastDot = this._size - 1;
        }
        this._appendChars(string.toCharArray());
    }

    public void appendZeroElementIDComponent() {
        this._elementIDString = null;
        if (this._size != 0) {
            this._appendChar('.');
            this._lastDot = this._size - 1;
        }
        this._appendChar('0');
    }

    public void incrementLastElementIDComponent() {
        int n;
        if (this._size == 0) {
            return;
        }
        this._elementIDString = null;
        int n2 = this._lastDot + 1;
        char c = '\u0000';
        for (n = this._size - 1; n >= n2 && this._elementID[n] == '9'; --n) {
            this._elementID[n] = 48;
        }
        if (n >= 0) {
            c = this._elementID[n];
        }
        if (n >= n2 && c >= '0' && c <= '8') {
            this._elementID[n] = (char)(c + '\u0001');
        } else {
            this._elementID[n + 1] = 49;
            this._appendChar('0');
        }
    }

    public void deleteLastElementIDComponent() {
        this._elementIDString = null;
        this._size = this._lastDot;
        if (this._size == -1) {
            this._size = 0;
        } else {
            this._lastDot = this._lastDotPosition();
        }
    }

    public void deleteAllElementIDComponents() {
        this._elementIDString = null;
        this._size = 0;
        this._lastDot = -1;
    }
}

