/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOBody;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOHTMLDynamicElement;
import com.webobjects.appserver._private.WOStaticURLUtilities;
import com.webobjects.appserver._private.WOURLValuedElementData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSDictionaryUtilities;

public abstract class WOHTMLURLValuedElement
extends WOHTMLDynamicElement {
    WOAssociation _src;
    WOAssociation _value;
    WOAssociation _pageName;
    WOAssociation _filename;
    WOAssociation _framework;
    WOAssociation _data;
    WOAssociation _mimeType;
    WOAssociation _key;
    WOAssociation _queryDictionary;
    WOAssociation _actionClass;
    WOAssociation _directActionName;
    NSDictionary _otherQueryAssociations;

    protected String urlAttributeName() {
        return "src";
    }

    protected String valueAttributeName() {
        return "value";
    }

    protected WOHTMLURLValuedElement(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super(string, nSDictionary, wOElement);
        String string2 = this.urlAttributeName();
        String string3 = this.valueAttributeName();
        this._src = (WOAssociation)this._associations.removeObjectForKey((Object)string2);
        this._value = (WOAssociation)this._associations.removeObjectForKey((Object)string3);
        this._pageName = (WOAssociation)this._associations.removeObjectForKey((Object)"pageName");
        this._filename = (WOAssociation)this._associations.removeObjectForKey((Object)"filename");
        this._framework = (WOAssociation)this._associations.removeObjectForKey((Object)"framework");
        this._data = (WOAssociation)this._associations.removeObjectForKey((Object)"data");
        this._mimeType = (WOAssociation)this._associations.removeObjectForKey((Object)"mimeType");
        this._key = (WOAssociation)this._associations.removeObjectForKey((Object)"key");
        this._queryDictionary = (WOAssociation)this._associations.removeObjectForKey((Object)"queryDictionary");
        this._actionClass = (WOAssociation)this._associations.removeObjectForKey((Object)"actionClass");
        this._directActionName = (WOAssociation)this._associations.removeObjectForKey((Object)"directActionName");
        this._otherQueryAssociations = _NSDictionaryUtilities.extractObjectsForKeysWithPrefix((NSMutableDictionary)this._associations, (String)"?", (boolean)true);
        if (this._filename != null) {
            if (this._src != null || this._pageName != null || this._value != null || this._data != null) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : Can't have " + "filename" + " and " + this.urlAttributeName() + ", " + "pageName" + ", " + "data" + " or " + this.valueAttributeName() + ".");
            }
        } else if (this._data != null) {
            if (this._src != null || this._pageName != null || this._value != null) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : Can't have " + "data" + " and " + this.urlAttributeName() + ", " + "pageName" + ", or " + this.valueAttributeName() + ".");
            }
            if (this._mimeType == null) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : Missing " + "mimeType" + " when " + "data" + " is specified.");
            }
        } else {
            if (this._pageName != null && this._src != null || this._pageName != null && this._value != null || this._src != null && this._value != null) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : dynamic element can not have two conflicting bindings: " + "pageName" + " and " + this.urlAttributeName() + ", or " + "pageName" + " and " + this.valueAttributeName() + ", or " + this.urlAttributeName() + " and " + this.valueAttributeName() + ".");
            }
            if (this._pageName == null && this._value == null && this._src == null && this._directActionName == null && this._actionClass == null && !(this instanceof WOBody)) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : At least one of the following bindings is required for this dynamic element: " + "directActionName" + ",  " + "actionClass" + ", " + "filename" + ", " + "pageName" + ", " + "data" + ", " + this.urlAttributeName() + " or " + this.valueAttributeName() + " .");
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<" + this.getClass().getName() + "\n");
        stringBuffer.append("(" + super.toString() + ")\n");
        if (this._src != null) {
            stringBuffer.append(" src: " + this._src.toString());
        }
        if (this._value != null) {
            stringBuffer.append(" value: " + this._value.toString());
        }
        if (this._pageName != null) {
            stringBuffer.append(" pageName: " + this._pageName.toString());
        }
        if (this._filename != null) {
            stringBuffer.append(" filename: " + this._filename.toString());
        }
        if (this._framework != null) {
            stringBuffer.append(" framework: " + this._framework.toString());
        }
        if (this._data != null) {
            stringBuffer.append(" data: " + this._data.toString());
        }
        if (this._mimeType != null) {
            stringBuffer.append(" mimeType: " + this._mimeType.toString());
        }
        if (this._key != null) {
            stringBuffer.append(" key: " + this._key.toString());
        }
        return stringBuffer.toString() + " >";
    }

    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        WOActionResults wOActionResults = null;
        String string = wOContext.elementID();
        String string2 = wOContext.senderID();
        if (string != null && string2 != null && string.equals(string2)) {
            String string3;
            Object object;
            WOComponent wOComponent = wOContext.component();
            if (this._value != null) {
                wOActionResults = (WOActionResults)this._value.valueInComponent(wOComponent);
            } else if (this._pageName != null && (object = this._pageName.valueInComponent(wOComponent)) != null && (string3 = object.toString()) != null) {
                wOActionResults = WOApplication.application().pageWithName(string3, wOContext);
            }
        } else {
            wOActionResults = super.invokeAction(wORequest, wOContext);
        }
        return wOActionResults;
    }

    protected String _imageURL(WOContext wOContext) {
        String string;
        WOComponent wOComponent = wOContext.component();
        String string2 = (String)this._filename.valueInComponent(wOComponent);
        String string3 = wOContext._urlForResourceNamed(string2, string = WOHTMLURLValuedElement._frameworkNameInComponent(this._framework, wOComponent), true);
        if (string3 == null) {
            string3 = WOApplication.application().resourceManager().errorMessageUrlForResourceNamed(string2, string);
        }
        return string3;
    }

    protected void _appendFilenameToResponse(WOResponse wOResponse, WOContext wOContext) {
        String string = this._imageURL(wOContext);
        wOResponse._appendTagAttributeAndValue(this.urlAttributeName(), string, false);
    }

    private String CGIActionURL(WOContext wOContext) {
        String string = this.computeActionStringInContext(this._actionClass, this._directActionName, wOContext);
        boolean bl = this._actionClass != null;
        NSDictionary nSDictionary = this.computeQueryDictionaryInContext(this._actionClass, this._directActionName, this._queryDictionary, bl, this._otherQueryAssociations, wOContext);
        String string2 = wOContext.directActionURLForActionNamed(string, nSDictionary);
        return string2;
    }

    public void appendAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        String string = null;
        WOComponent wOComponent = wOContext.component();
        WOResourceManager wOResourceManager = WOApplication.application().resourceManager();
        super.appendAttributesToResponse(wOResponse, wOContext);
        if (this._src != null) {
            string = (String)this._src.valueInComponent(wOComponent);
        }
        if (this._directActionName != null || this._actionClass != null) {
            wOResponse._appendTagAttributeAndValue(this.urlAttributeName(), this.CGIActionURL(wOContext), false);
        } else if (this._filename != null) {
            this._appendFilenameToResponse(wOResponse, wOContext);
        } else if (this._value != null || this._pageName != null) {
            wOResponse._appendTagAttributeAndValue(this.urlAttributeName(), wOContext.componentActionURL(), false);
        } else if (string != null) {
            if (WOStaticURLUtilities.isRelativeURL(string) && !WOStaticURLUtilities.isFragmentURL(string)) {
                String string2 = wOContext._urlForResourceNamed(string, null, true);
                if (string2 != null) {
                    wOResponse._appendTagAttributeAndValue(this.urlAttributeName(), string2, false);
                } else {
                    wOResponse.appendContentCharacter(' ');
                    wOResponse._appendContentAsciiString(this.urlAttributeName());
                    wOResponse.appendContentCharacter('=');
                    wOResponse.appendContentCharacter('\"');
                    wOResponse._appendContentAsciiString(wOComponent.baseURL());
                    wOResponse.appendContentCharacter('/');
                    wOResponse.appendContentString(string);
                    wOResponse.appendContentCharacter('\"');
                }
            } else {
                wOResponse._appendTagAttributeAndValue(this.urlAttributeName(), string, false);
            }
        } else if (this._data != null && this._mimeType != null) {
            WOURLValuedElementData._appendDataURLAttributeToResponse(wOResponse, wOContext, this._key, this._data, this._mimeType, this.urlAttributeName(), wOComponent);
        }
    }
}

