/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.eocontrol.EOEvent;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSValidation;

public class WOKeyValueAssociation
extends WOAssociation
implements Cloneable {
    protected String _keyPath;
    protected boolean _isValueSettable;

    public WOKeyValueAssociation(String string) {
        this._keyPath = string;
        this._isValueSettable = this._keyPath != null && this._keyPath.length() > 0;
    }

    public Object clone() {
        return new WOKeyValueAssociation(this._keyPath);
    }

    public String toString() {
        return "<" + this.getClass().getName() + ": keyPath=" + this._keyPath + ">";
    }

    public Object valueInComponent(WOComponent wOComponent) {
        Object object = null;
        WOAssociation.Event event = this._markStartOfEventIfNeeded("valueForKeyPath", this._keyPath, wOComponent);
        object = wOComponent.valueForKeyPath(this._keyPath);
        if (event != null) {
            EOEventCenter.markEndOfEvent((EOEvent)event);
        }
        if (this._debugEnabled) {
            this._logPullValue(object, wOComponent);
        }
        return object;
    }

    public void setValue(Object object, WOComponent wOComponent) {
        WOAssociation.Event event = null;
        NSValidation.ValidationException validationException = null;
        if (this._keyPath.length() == 0) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Cannot set value to '" + object + "' in component '" + wOComponent.name() + "' because value is not settable.");
        }
        event = this._markStartOfEventIfNeeded("takeValueForKeyPath", this._keyPath, wOComponent);
        try {
            wOComponent.validateTakeValueForKeyPath(object, this._keyPath);
        }
        catch (NSValidation.ValidationException validationException2) {
            NSLog._conditionallyLogPrivateException((Throwable)validationException2);
            validationException = validationException2;
        }
        if (event != null) {
            EOEventCenter.markEndOfEvent((EOEvent)event);
        }
        if (this._debugEnabled) {
            this._logPushValue(object, wOComponent);
        }
        if (validationException != null) {
            wOComponent.validationFailedWithException(validationException, object, this._keyPath);
        }
    }

    public void _setValueNoValidation(Object object, WOComponent wOComponent) {
        if (this.isValueSettable()) {
            wOComponent.takeValueForKeyPath(object, this._keyPath);
        }
    }

    public boolean isValueSettable() {
        return this._isValueSettable;
    }

    public boolean isValueConstant() {
        return false;
    }

    public String keyPath() {
        return this._keyPath;
    }

    public String bindingInComponent(WOComponent wOComponent) {
        return this.keyPath();
    }
}

