/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOHttpIO;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Enumeration;

public class WORecording {
    private long _recordingStep;
    private WORequest _request;
    private String _recordingPath;
    private String _wildcards;
    private static DecimalFormat TheNumberFormatter;
    private static final NSSelector appWillDispatch;
    private static final NSSelector appDidDispatch;

    public String toString() {
        return "<" + this.getClass().getName() + " recordingPath='" + this._recordingPath + "' recordingStep=" + this._recordingStep + " request=" + (this._request != null ? this._request.toString() : "null") + " wildcards=" + (this._wildcards != null ? this._wildcards.toString() : "null") + " >";
    }

    private void _setRecordingPath(String string) throws IOException {
        File file;
        String string2 = null;
        String string3 = null;
        if (null == string) {
            return;
        }
        string2 = !string.endsWith(".rec") ? ((file = new File(string)).exists() && file.isDirectory() ? string + "/" + WOApplication.application().name() : string) : NSPathUtilities.stringByDeletingPathExtension((String)string);
        string3 = string2 + ".rec";
        int n = 0;
        file = new File(string3);
        while (file.exists()) {
            string3 = string2 + "-" + ++n + ".rec";
            file = new File(string3);
        }
        this._recordingPath = string3;
        if (!file.mkdir()) {
            throw new IOException("<" + this.getClass().getName() + "> Recording failed to create directory at path '" + this._recordingPath + "'");
        }
    }

    public WORecording() throws IOException {
        NSNotificationCenter nSNotificationCenter = NSNotificationCenter.defaultCenter();
        try {
            this._recordingStep = 0L;
            String string = WOApplication.application().recordingPath();
            this._setRecordingPath(string);
            this._wildcards = "/$*$/$*$/" + WOApplication.application().name() + ".woa/$*$/";
            nSNotificationCenter.addObserver((Object)this, appWillDispatch, "ApplicationWillDispatchRequestNotification", null);
            nSNotificationCenter.addObserver((Object)this, appDidDispatch, "ApplicationDidDispatchRequestNotification", null);
        }
        catch (IOException iOException) {
            NSLog.err.appendln((Object)("<" + this.getClass().getName() + ">  Initialization failed. Recording turned off by removing from -dispatchRequest: observers."));
            nSNotificationCenter.removeObserver((Object)this);
            throw iOException;
        }
        NSLog.debug.appendln((Object)("<" + this.getClass().getName() + "> Recording at path : '" + this._recordingPath + "'"));
    }

    private String _stringForMessage(WOMessage wOMessage, String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(string);
        NSArray nSArray = wOMessage.headerKeys();
        Enumeration enumeration = null;
        String string3 = null;
        if (nSArray != null) {
            enumeration = nSArray.objectEnumerator();
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (string3.equals("x-webobjects-request-id")) continue;
            string2 = wOMessage.headersForKey(string3);
            int n = string2.count();
            for (int i = 0; i < n; ++i) {
                String string4 = (String)string2.objectAtIndex(i);
                stringBuffer.append(string3);
                stringBuffer.append(": ");
                stringBuffer.append(string4);
                stringBuffer.append("\r\n");
            }
        }
        if (wOMessage instanceof WORequest) {
            stringBuffer.append("x-webobjects-recording: on\r\n");
        }
        stringBuffer.append("\r\n");
        string2 = wOMessage.contentString();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void saveRequest(WORequest wORequest) throws IOException {
        if (wORequest != null) {
            String string;
            this._request = wORequest;
            String string2 = this._recordingPath + "/" + TheNumberFormatter.format(this._recordingStep) + "-request";
            NSLog.debug.appendln((Object)("Saving Request " + string2));
            String string3 = this._request.uri();
            if (WOApplication.application().isDirectConnectEnabled() && string3.equals("/")) {
                int n;
                string = WOApplication.application().cgiAdaptorURL();
                int n2 = string.length();
                int n3 = string.indexOf("//");
                if (n3 != -1 && n2 - n3 > 2 && (n = string.indexOf("/", n3 + 2)) != -1) {
                    string3 = string.substring(n, n2);
                }
                if (string3.charAt((n = string3.length()) - 1) != '/') {
                    string3 = string3 + "/";
                }
                string3 = string3 + WOApplication.application().name();
            }
            String string4 = this._request.method() + " " + string3 + " " + this._request.httpVersion() + "\r\n";
            string = this._stringForMessage(this._request, string4);
            File file = new File(string2);
            _NSStringUtilities.writeToFile((File)file, (String)string);
        } else {
            this._request = null;
        }
    }

    public String _stringByReplacingInString(String string, String string2, String string3) {
        String string4 = string;
        if (string2 != null && string3 != null) {
            int n = string4.indexOf(string2);
            int n2 = string2.length();
            while (n != -1) {
                string4 = string4.substring(0, n) + string3 + string4.substring(n + n2);
                n = string4.indexOf(string2);
            }
        }
        return string4;
    }

    private WOResponse _wildcardedResponse(WOResponse wOResponse) {
        int n;
        WOResponse wOResponse2 = (WOResponse)wOResponse.clone();
        String string = wOResponse.headerForKey("x-webobjects-session-id");
        String string2 = wOResponse.contentString();
        string2 = this._stringByReplacingInString(string2, string, "$*$");
        string2 = this._stringByReplacingInString(string2, this._request.applicationURLPrefix(), "/$*$/WebObjects$*$");
        String string3 = "src=\"";
        String string4 = "\"";
        String string5 = "/";
        String string6 = "%2F";
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            string6 = "%5C";
        }
        int n2 = 0;
        while ((n = string2.indexOf(string3, n2)) != -1) {
            int n3;
            String string7 = "$*$/WebObjects$*$";
            int n4 = n + string3.length();
            int n5 = string2.indexOf(string4, n4);
            if (n5 == -1) continue;
            String string8 = string2.substring(n4, n5);
            int n6 = string8.lastIndexOf(string6);
            if (n6 != -1) {
                n6 += string6.length();
            }
            if (n6 == -1 && (n3 = string8.lastIndexOf("wodata")) != -1) {
                string7 = "$*$/WebObjects$*$" + WOApplication.application().name() + ".woa/wr?wodata=$*$";
                n6 = string8.length();
            }
            if (n6 == -1 && (n6 = string8.lastIndexOf(string5)) != -1) {
                n6 += string5.length();
            }
            if (n6 == -1) continue;
            String string9 = string2.substring(n4, n4 + n6);
            if (!string9.equals("$*$/")) {
                string2 = this._stringByReplacingInString(string2, string2.substring(n4, n4 + n6), string7);
                n2 = n4 + string7.length();
                continue;
            }
            n2 = n5;
        }
        String string10 = string2;
        wOResponse2.setHeader("" + string10.length(), "content-length");
        String string11 = wOResponse.contentString();
        int n7 = 0;
        if (string11 != null) {
            n7 = string11.length();
        }
        wOResponse2.setHeader("" + n7, "x-webobjects-unwildcarded-content-length");
        wOResponse2.setContent(string10);
        return wOResponse2;
    }

    public void saveResponse(WOResponse wOResponse) throws IOException {
        WOResponse wOResponse2 = this._wildcardedResponse(wOResponse);
        String string = this._recordingPath + "/" + TheNumberFormatter.format(this._recordingStep) + "-response";
        NSLog.debug.appendln((Object)("Saving Response " + string));
        String string2 = wOResponse2.httpVersion() + " " + wOResponse2.status() + WOHttpIO.URIResponseString;
        String string3 = this._stringForMessage(wOResponse2, string2);
        File file = new File(string);
        _NSStringUtilities.writeToFile((File)file, (String)string3);
        ++this._recordingStep;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applicationWillDispatchRequest(NSNotification nSNotification) {
        WORequest wORequest = (WORequest)nSNotification.object();
        try {
            if (wORequest != null && null == wORequest.formValueForKey("wodata")) {
                WOApplication.application();
                if (!"womp".equals(wORequest.requestHandlerKey())) {
                    this.saveRequest(wORequest);
                    return;
                }
            }
            this.saveRequest(null);
            return;
        }
        catch (IOException iOException) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)iOException);
        }
    }

    public void applicationDidDispatchRequest(NSNotification nSNotification) {
        if (this._request != null) {
            try {
                this.saveResponse((WOResponse)nSNotification.object());
            }
            catch (IOException iOException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)iOException);
            }
        }
    }

    static {
        block2: {
            try {
                TheNumberFormatter = new DecimalFormat("0000");
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<WORecording> Exception during static initialization: " + exception.toString()));
                if (!NSLog.debugLoggingAllowedForLevel((int)1)) break block2;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
        appWillDispatch = new NSSelector("applicationWillDispatchRequest", _NSUtilities._NotificationClassArray);
        appDidDispatch = new NSSelector("applicationDidDispatchRequest", _NSUtilities._NotificationClassArray);
    }
}

