/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver.xml;

import com.webobjects.appserver.xml.WOXMLCoding;
import com.webobjects.appserver.xml.WOXMLException;
import com.webobjects.appserver.xml.WOXMLMappingCoder;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSMutableIntegerDictionary;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.util.Stack;
import org.apache.xerces.impl.dv.util.Base64;

public class WOXMLCoder {
    protected StringBuffer _buffer;
    protected String xmlDeclaration = "";
    protected _IdentityCodeMap _idMap = new _IdentityCodeMap();
    private NSMutableDictionary _encodedObjects = new NSMutableDictionary();
    private int refCount = 0;
    private int tabCount = 0;
    private static NSArray tabArray = new NSArray(new Object[]{"\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t", "\t\t\t\t\t\t", "\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"});
    protected Stack _encodedClasses = new Stack();

    protected void cr() {
        int n = this._encodedClasses.size();
        this._buffer.append('\n');
        for (int i = 0; i < n; ++i) {
            this._buffer.append("    ");
        }
    }

    protected boolean typeNeedsIndentation(Object object) {
        return object != null && !(object instanceof String) && !(object instanceof Number) && !(object instanceof NSTimestamp) && !(object instanceof Boolean);
    }

    protected String encodedClassName() {
        return (String)this._encodedClasses.peek();
    }

    protected String xmlTagForClassNamed(String string) {
        return string;
    }

    protected String xmlTagForPropertyKey(String string, String string2) {
        return string;
    }

    private String _tabString(int n) {
        if (n == 0) {
            return "";
        }
        if (n < 16 && n > 0) {
            return (String)tabArray.objectAtIndex(n - 1);
        }
        StringBuffer stringBuffer = new StringBuffer("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        for (int i = 16; i < n; ++i) {
            stringBuffer.append('\t');
        }
        return new String(stringBuffer);
    }

    void appendAttribute(String string, String string2) {
        this._buffer.append(' ');
        this._buffer.append(string);
        this._buffer.append("=\"");
        this._buffer.append(string2);
        this._buffer.append('\"');
    }

    void appendAttribute(String string, int n) {
        this.appendAttribute(string, Integer.toString(n));
    }

    void appendTypeAndObjectID(String string) {
        this.appendAttribute("type", string);
        this.appendAttribute("objectID", this.refCount);
        this._buffer.append('>');
    }

    void appendAndTab(String string) {
        this._buffer.append(string);
        ++this.tabCount;
    }

    void beginNode(String string) {
        if (!WOXMLCoder._isPlausibleName(string)) {
            throw new WOXMLException("'" + string + "' is not a plausible name for an XML tag");
        }
        this._buffer.append(this._tabString(this.tabCount));
        this._buffer.append('<');
        this._buffer.append(string);
    }

    void endNode(String string) {
        this._buffer.append('<');
        this._buffer.append('/');
        this._buffer.append(string);
        this._buffer.append('>');
        this._buffer.append('\n');
    }

    private static boolean _isPlausibleName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char c = cArray[0];
        if (!Character.isLetter(c) && c != '_' && c != ':') {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            c = cArray[i];
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == ':' || c == '.' || c == '-' || Character.getNumericValue(c) >= 128) continue;
            return false;
        }
        return true;
    }

    protected void encodeObjectInTag(String string, String string2, String string3) {
        if (string3 == null) {
            throw new WOXMLException("cannot encode '" + string + "' with the xml tag '" + string2 + "' because the class type is null");
        }
        this.beginNode(string2);
        this.appendTypeAndObjectID(string3);
        this._buffer.append(string);
        this.endNode(string2);
    }

    protected void encodeStringInTag(String string, String string2, String string3) {
        if (string3 == null) {
            throw new WOXMLException("cannot encode '" + string + "' with the xml tag '" + string2 + "' because the class type is null");
        }
        this.beginNode(string2);
        this.appendAttribute("type", string3);
        if (!(string3.equals("boolean") || string3.equals("int") || string3.equals("float") || string3.equals("double"))) {
            this.appendAttribute("objectID", this.refCount);
        }
        this._buffer.append('>');
        this._buffer.append(string);
        this.endNode(string2);
    }

    protected void encodeReferenceInTag(int n, String string, String string2) {
        this.beginNode(string);
        this.appendAttribute("type", string2);
        this.appendAttribute("objectIDRef", n);
        this._buffer.append('>');
        this.endNode(string);
    }

    protected void _encodeStringForKey(String string, String string2) {
        String string3 = string.getClass().getName();
        this.encodeStringInTag(this.escapeString(string), string2, string3);
    }

    protected String escapeString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return new String(stringBuffer);
    }

    protected void _encodeArrayForKey(NSArray nSArray, String string) {
        this.beginNode(string);
        String string2 = "com.webobjects.foundation.NSMutableArray";
        if (!nSArray.getClass().getName().equals(string2)) {
            string2 = nSArray.classForCoder().getName();
        }
        this.appendTypeAndObjectID(string2);
        this.appendAndTab("\n");
        int n = nSArray.count();
        for (int i = 0; i < n; ++i) {
            Object object = nSArray.objectAtIndex(i);
            this.encodeObjectForKey(object, "element");
        }
        --this.tabCount;
        this._buffer.append(this._tabString(this.tabCount));
        this.endNode(string);
    }

    protected void _encodeDictionaryForKey(NSDictionary nSDictionary, String string) {
        this.beginNode(string);
        String string2 = "com.webobjects.foundation.NSMutableDictionary";
        if (!nSDictionary.getClass().getName().equals(string2)) {
            string2 = nSDictionary.classForCoder().getName();
        }
        this.appendTypeAndObjectID(string2);
        this.appendAndTab("\n");
        NSArray nSArray = nSDictionary.allKeys();
        int n = nSArray.count();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)nSArray.objectAtIndex(i);
            Object object = nSDictionary.objectForKey((Object)string3);
            this.encodeObjectForKey(object, string3);
        }
        --this.tabCount;
        this._buffer.append(this._tabString(this.tabCount));
        this.endNode(string);
    }

    protected void _encodeDataForKey(NSData nSData, String string) {
        String string2 = "com.webobjects.foundation.NSMutableData";
        if (!nSData.getClass().getName().equals(string2)) {
            string2 = nSData.classForCoder().getName();
        }
        this.encodeObjectInTag(new String(Base64.encode((byte[])nSData.bytes(new NSRange(0, nSData.length())))), string, string2);
    }

    protected void _encodeDateForKey(NSTimestamp nSTimestamp, String string) {
        String string2 = nSTimestamp.classForCoder().getName();
        this.encodeStringInTag(nSTimestamp.toString(), string, string2);
    }

    protected void _encodeNumberForKey(Number number, String string) {
        String string2 = number.getClass().getName();
        this.encodeStringInTag(number.toString(), string, string2);
    }

    protected void _encodeBooleanForKey(Boolean bl, String string) {
        String string2 = bl.getClass().getName();
        this.encodeStringInTag(bl.toString(), string, string2);
    }

    protected void _encodeNullForKey(String string) {
        this.encodeStringInTag("null", string, "?");
    }

    protected void _encodeWOXMLCodingForKey(WOXMLCoding wOXMLCoding, String string) {
        String string2 = wOXMLCoding.classForCoder().getName();
        this.beginNode(string);
        this.appendTypeAndObjectID(string2);
        this.appendAndTab("\n");
        wOXMLCoding.encodeWithWOXMLCoder(this);
        --this.tabCount;
        this._buffer.append(this._tabString(this.tabCount));
        this.endNode(string);
    }

    protected void _encodeEOEnterpriseObjectForKey(EOEnterpriseObject eOEnterpriseObject, String string) {
        Object object;
        String string2;
        String string3 = eOEnterpriseObject.getClass().getName();
        EOClassDescription eOClassDescription = eOEnterpriseObject.classDescription();
        if (eOClassDescription == null) {
            throw new WOXMLException(eOEnterpriseObject.getClass().getName() + " must either implement the WOXMLCoding interface or contain a class description that is not null.");
        }
        String string4 = eOClassDescription.entityName();
        this.beginNode(string4);
        this.appendTypeAndObjectID(string3);
        this.appendAndTab("\n");
        NSArray nSArray = eOClassDescription.attributeKeys();
        int n = nSArray.count();
        for (int i = 0; i < n; ++i) {
            string2 = (String)nSArray.objectAtIndex(i);
            object = eOEnterpriseObject.valueForKey(string2);
            if (object == null) continue;
            this.encodeObjectForKey(object, string2);
        }
        NSArray nSArray2 = eOClassDescription.toOneRelationshipKeys();
        n = nSArray2.count();
        for (int i = 0; i < n; ++i) {
            string2 = (String)nSArray2.objectAtIndex(i);
            this.beginNode(string2);
            this.appendAndTab(" type=\"relationship\" relationshipType=\"to-one\">\n");
            object = eOEnterpriseObject.valueForKey(string2);
            if (object != null) {
                this.encodeObjectForKey(object, string2);
            }
            --this.tabCount;
            this._buffer.append(this._tabString(this.tabCount));
            this.endNode(string2);
        }
        NSArray nSArray3 = eOClassDescription.toManyRelationshipKeys();
        n = nSArray3.count();
        for (int i = 0; i < n; ++i) {
            string2 = (String)nSArray3.objectAtIndex(i);
            object = eOEnterpriseObject.valueForKey(string2);
            if (object == null) continue;
            this.encodeObjectForKey(object, string2);
        }
        --this.tabCount;
        this._buffer.append(this._tabString(this.tabCount));
        this.endNode(string4);
    }

    protected WOXMLCoder() {
    }

    public static WOXMLCoder coder() {
        return new WOXMLCoder();
    }

    public static WOXMLCoder coderWithMapping(String string) {
        return new WOXMLMappingCoder(string);
    }

    public String xmlDeclaration() {
        return this.xmlDeclaration;
    }

    public synchronized void setXmlDeclaration() {
        this.setXmlDeclaration("1.0", null, null);
    }

    public synchronized void setXmlDeclaration(String string, String string2, String string3) {
        try {
            Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("XML version has to be a number, e.g. '1.0'");
        }
        if (string3 != null && !"yes".equals(string3) && !"no".equals(string3)) {
            throw new IllegalArgumentException("\"standalone\" can be only either \"yes\" or \"no\"");
        }
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.append("<?xml version=\"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (string2 != null) {
            stringBuffer.append(" encoding=\"");
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        }
        if (string3 != null) {
            stringBuffer.append(" standalone=\"");
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        stringBuffer.append("?>\n");
        this.xmlDeclaration = _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
    }

    public synchronized String encodeRootObjectForKey(Object object, String string) {
        String string2 = null;
        if (object != null) {
            this._buffer = new StringBuffer(1024);
            this._buffer.append(this.xmlDeclaration);
            this.encodeObjectForKey(object, string);
            string2 = _NSStringUtilities.stringFromBuffer((StringBuffer)this._buffer);
            this._buffer = null;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeObjectForKey(Object object, String string) {
        int n = this._idMap.identityCode(object);
        Integer n2 = _NSUtilities.IntegerForInt((int)n);
        this.refCount = n;
        if (object != null) {
            if (this._encodedObjects.objectForKey((Object)n2) != null) {
                String string2 = object.getClass().getName();
                if (object instanceof EOEnterpriseObject) {
                    String string3 = ((EOEnterpriseObject)object).entityName();
                    this.encodeReferenceInTag(n, string3, string2);
                    return;
                } else {
                    this.encodeReferenceInTag(n, string, string2);
                }
                return;
            } else {
                this._encodedObjects.setObjectForKey(object, (Object)n2);
                if (object instanceof WOXMLCoding) {
                    this._encodeWOXMLCodingForKey((WOXMLCoding)object, string);
                    return;
                } else if (object instanceof String) {
                    this._encodeStringForKey((String)object, string);
                    return;
                } else if (object instanceof NSArray) {
                    this._encodeArrayForKey((NSArray)object, string);
                    return;
                } else if (object instanceof NSDictionary) {
                    this._encodeDictionaryForKey((NSDictionary)object, string);
                    return;
                } else if (object instanceof NSTimestamp) {
                    this._encodeDateForKey((NSTimestamp)object, string);
                    return;
                } else if (object instanceof Number) {
                    this._encodeNumberForKey((Number)object, string);
                    return;
                } else if (object instanceof EOEnterpriseObject) {
                    this._encodeEOEnterpriseObjectForKey((EOEnterpriseObject)object, string);
                    return;
                } else if (object instanceof NSData) {
                    this._encodeDataForKey((NSData)object, string);
                    return;
                } else {
                    if (!(object instanceof Boolean)) throw new WOXMLException(object.getClass().getName() + " must either implement the WOXMLCoding interface or be a class that WOXMLCoder supports (See WOXMLCoder reference).");
                    this._encodeBooleanForKey((Boolean)object, string);
                }
            }
            return;
        } else {
            this._encodeNullForKey(string);
        }
    }

    public void encodeBooleanForKey(boolean bl, String string) {
        this.encodeStringInTag(bl ? "True" : "False", string, "boolean");
    }

    public void encodeIntForKey(int n, String string) {
        this.encodeStringInTag(Integer.toString(n), string, "int");
    }

    public void encodeFloatForKey(float f, String string) {
        this.encodeStringInTag(Float.toString(f), string, "float");
    }

    public void encodeDoubleForKey(double d, String string) {
        this.encodeStringInTag(Double.toString(d), string, "double");
    }

    private class _IdentityCodeMap {
        private static final int _NULL = 0;
        private static final int _UNREGISTERED = Integer.MIN_VALUE;
        private _NSMutableIntegerDictionary _objectToIntegerMap = new _NSMutableIntegerDictionary(1024);
        private int _nextInt = 1;

        public int identityCode(Object object) {
            if (object == null) {
                return 0;
            }
            int n = this._objectToIntegerMap.integerForKey(object);
            if (n == Integer.MIN_VALUE) {
                this._objectToIntegerMap.setIntegerForKey(this._nextInt, object);
                n = this._nextInt++;
            }
            return n;
        }
    }
}

