/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import er.ajax.AjaxResponse;
import er.ajax.AjaxResponseAppender;
import er.ajax.AjaxUtils;
import er.ajax.example2.NotificationResponseAppender;
import er.ajax.example2.util.StringUtils;
import er.extensions.appserver.ERXApplication;

public class Application
extends ERXApplication {
    public static void main(String[] argv) {
        ERXApplication.main((String[])argv, Application.class);
    }

    public Application() {
        AjaxResponse.addAjaxResponseAppender((AjaxResponseAppender)new NotificationResponseAppender());
    }

    public WOResponse handleException(Exception exception, WOContext context) {
        WOResponse response;
        if (context != null && AjaxUtils.isAjaxRequest((WORequest)context.request())) {
            response = this.createResponseInContext(context);
            response.appendContentString(StringUtils.toErrorString(exception));
        } else {
            response = super.handleException(exception, context);
        }
        return response;
    }

    public WOResponse handleSessionRestorationErrorInContext(WOContext context) {
        WOResponse response;
        if (context != null && AjaxUtils.isAjaxRequest((WORequest)context.request())) {
            response = this.createResponseInContext(context);
            String sessionExpiredUrl = context.directActionURLForActionNamed("sessionExpired", null);
            response.appendContentString("<script>document.location.href='" + sessionExpiredUrl + "';</script>");
        } else {
            response = super.handleSessionRestorationErrorInContext(context);
        }
        return response;
    }
}

