/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.helper;

import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.ajax.example2.util.DateUtils;
import java.util.Calendar;
import java.util.Date;

public class NSTimestampHelper {
    public String format(NSTimestamp time) {
        return this.format(time, true);
    }

    public String format(NSTimestamp time, boolean useTimes) {
        if (time != null) {
            NSTimestampFormatter formatDateTime = useTimes ? new NSTimestampFormatter("%m/%d/%Y %I:%M %p") : new NSTimestampFormatter("%m/%d/%Y");
            return formatDateTime.format((Object)time);
        }
        return null;
    }

    public String mdy(NSTimestamp time) {
        if (time != null) {
            NSTimestampFormatter formatDateTime = new NSTimestampFormatter("%m/%d/%Y");
            return formatDateTime.format((Object)time);
        }
        return null;
    }

    public String ago(NSTimestamp time) {
        if (time != null) {
            return DateUtils.timeFromNow(time);
        }
        return "";
    }

    public String timeOnly(NSTimestamp time) {
        if (time != null) {
            NSTimestampFormatter formatDateTime = new NSTimestampFormatter("%I:%M%p");
            String results = formatDateTime.format((Object)time);
            if ((results = results.toLowerCase()).charAt(0) == '0') {
                results = ((Object)results.subSequence(1, results.length())).toString();
            }
            return results;
        }
        return null;
    }

    public String withDayName(NSTimestamp date, boolean includeTime) {
        return this.withDayName(date, includeTime, true);
    }

    public String withDayName(NSTimestamp date, boolean includeTime, boolean includeYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)date);
        StringBuffer buffer = new StringBuffer();
        buffer.append(DateUtils.DAYS_OF_WEEK[calendar.get(7) - 1]);
        buffer.append(", ");
        buffer.append(DateUtils.MONTHS[calendar.get(2)]);
        buffer.append(" ");
        buffer.append(calendar.get(5));
        if (includeYear) {
            buffer.append(" ");
            buffer.append(calendar.get(1));
            buffer.append(" ");
        }
        if (includeTime) {
            int hour = calendar.get(10);
            if (hour == 0) {
                hour = 12;
            }
            buffer.append(hour);
            buffer.append(":");
            int minute = calendar.get(12);
            buffer.append(String.format("%02d", minute));
            buffer.append("");
            if (calendar.get(9) == 1) {
                buffer.append("pm");
            } else {
                buffer.append("am");
            }
        }
        return buffer.toString();
    }

    public String shortDateWithDayName(NSTimestamp date, boolean includeYear) {
        if (includeYear) {
            return DateUtils.SHORT_MONTH_NAME_AND_DAY_OF_WEEK_AND_YEAR_FORMATTER.format((Object)date);
        }
        return DateUtils.SHORT_MONTH_NAME_AND_DAY_OF_WEEK_FORMATTER.format((Object)date);
    }

    public String withMonthName(NSTimestamp date, boolean useTimes) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)date);
        StringBuffer buffer = new StringBuffer();
        buffer.append(DateUtils.MONTHS[calendar.get(2)]);
        buffer.append(" ");
        buffer.append(calendar.get(5));
        buffer.append(", ");
        buffer.append(calendar.get(1));
        buffer.append(" ");
        if (useTimes) {
            int hour = calendar.get(10);
            if (hour == 0) {
                hour = 12;
            }
            buffer.append(hour);
            buffer.append(":");
            int minute = calendar.get(12);
            buffer.append(String.format("%02d", minute));
            buffer.append("");
            if (calendar.get(9) == 1) {
                buffer.append(" PM");
            } else {
                buffer.append(" AM");
            }
        }
        return buffer.toString();
    }
}

