/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.helper;

import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringHelper {
    public String append(String str, Object obj) {
        return str + obj;
    }

    public String highlight(String str, String search) {
        return this.highlight(str, search, "highlight");
    }

    public String highlight(String str, String search, String className) {
        String result;
        try {
            Pattern pattern = Pattern.compile("(" + search + ")", 2);
            Matcher matcher = pattern.matcher(str);
            result = matcher.replaceAll("<span class = \"" + className + "\">$1</span>");
        }
        catch (PatternSyntaxException e) {
            result = str;
        }
        return result;
    }

    public String shortClassName(String className) {
        String shortClassName = className;
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex != -1) {
            shortClassName = className.substring(lastDotIndex + 1);
        }
        return shortClassName;
    }

    public String pluralize(String str) {
        return ERXLocalizer.currentLocalizer().plurifiedString(str, 2);
    }

    public String pluralize(String str, int count) {
        return ERXLocalizer.currentLocalizer().plurifiedString(str, count);
    }

    public String truncate(String str, int length, char repeater) {
        String value = str == null || str.length() <= length ? str : str.substring(0, length) + repeater + repeater + repeater;
        return value;
    }

    public String truncate(String str, int length) {
        String value = str == null || str.length() <= length ? str : str.substring(0, length) + "...";
        return value;
    }

    public String humanize(String str, boolean lowercase) {
        String results = ERXStringUtilities.displayNameForKey((String)str);
        if (lowercase) {
            results = results.toLowerCase();
        }
        return results;
    }

    public String humanize(String str) {
        return this.humanize(str, true);
    }

    public String capitalize(String str) {
        return ERXStringUtilities.capitalize((String)str);
    }
}

