/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.model;

import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import er.ajax.example2.model.Comment;
import er.ajax.example2.model.ComplexPerson;
import er.ajax.example2.model.Item;
import er.ajax.example2.model.Product;
import er.ajax.example2.model.Word;
import er.extensions.components.ERXLoremIpsumGenerator;
import er.extensions.foundation.ERXFileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleDataFactory {
    private static NSMutableArray<Word> _exampleData;

    public static NSMutableArray<Word> randomWords(int count) {
        NSMutableArray words = new NSMutableArray();
        Random rand = new Random();
        for (int i = 0; i < count; ++i) {
            String s = "";
            int max = 6 + rand.nextInt(6);
            for (int j = 0; j < max; ++j) {
                int c = rand.nextInt(26);
                s = s + Character.toString((char)(65 + c));
            }
            Word example = new Word(s);
            words.addObject((Object)example);
        }
        return words;
    }

    public static synchronized NSArray<Word> allWords() {
        if (_exampleData == null) {
            _exampleData = new NSMutableArray();
            File f = new File("/usr/share/dict/words");
            if (f.exists()) {
                try {
                    String words = ERXFileUtilities.stringFromFile((File)f);
                    String[] splitWords = words.split("\\n");
                    for (int i = 0; i < splitWords.length; ++i) {
                        String word = splitWords[i];
                        if (word.length() <= 0 || i % 20 != 0) continue;
                        Word example = new Word(word);
                        _exampleData.addObject((Object)example);
                    }
                }
                catch (IOException e) {
                    System.out.println("ExampleUtils.exampleValues: Can't read " + f + ": " + e);
                }
            }
            if (_exampleData.count() == 0) {
                _exampleData.addObjectsFromArray(ExampleDataFactory.randomWords(1000));
            }
            EOSortOrdering.sortArrayUsingKeyOrderArray(_exampleData, (NSArray)new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"name", (NSSelector)EOSortOrdering.CompareAscending)));
        }
        return _exampleData.immutableClone();
    }

    public static NSMutableArray<Product> products(int count) {
        NSMutableArray products = new NSMutableArray();
        for (int i = 0; i < count; ++i) {
            String title = ERXLoremIpsumGenerator.words((int)1, (int)5);
            String summary = ERXLoremIpsumGenerator.paragraph();
            Product product = new Product(title, summary);
            products.addObject((Object)product);
        }
        return products;
    }

    public static NSMutableArray<ComplexPerson> family() {
        NSMutableArray people = new NSMutableArray();
        ComplexPerson mike = new ComplexPerson("Mike", 29);
        ComplexPerson kirsten = new ComplexPerson("Kirsten", 29);
        ComplexPerson andrew = new ComplexPerson("Andrew", 2);
        mike.setSpouse(kirsten);
        kirsten.setSpouse(mike);
        mike.setChildren((NSArray<ComplexPerson>)new NSArray((Object)andrew));
        kirsten.setChildren((NSArray<ComplexPerson>)new NSArray((Object)andrew));
        people.add((Object)mike);
        people.add((Object)kirsten);
        people.add((Object)andrew);
        return people;
    }

    public static NSMutableArray<Comment> comments(int count) {
        NSMutableArray comments = new NSMutableArray();
        for (int i = 1; i < count; ++i) {
            Comment comment = new Comment();
            comment.setText("This is comment #" + i);
            comments.addObject((Object)comment);
        }
        return comments;
    }

    public static NSMutableArray<String> values(String prefix, int count) {
        NSMutableArray values = new NSMutableArray();
        for (int i = 0; i < count; ++i) {
            values.addObject((Object)(prefix + i));
        }
        return values;
    }

    public static NSMutableArray<Item> items(String idSuffix, String prefix, int count) {
        NSMutableArray items = new NSMutableArray();
        for (int i = 0; i < count; ++i) {
            items.addObject((Object)new Item(String.valueOf(i) + idSuffix, prefix + i));
        }
        return items;
    }
}

