/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.util;

import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSTimestamp;
import er.ajax.example2.util.DateUtils;
import er.ajax.example2.util.Month;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class Day
implements Comparable {
    private int myDayYear;
    private int myDayMonth;
    private int myDay;
    private NSTimestamp myStartDate;
    private NSTimestamp myEndDate;

    public Day(int _year, int _month, int _day) {
        this.myDayYear = _year;
        this.myDayMonth = _month;
        this.myDay = _day;
        this.myStartDate = DateUtils.timestamp(_year, _month, _day, 0, 0, 0, 0);
        this.myEndDate = DateUtils.timestamp(_year, _month, _day, 23, 59, 59, 999);
    }

    public Day(NSTimestamp timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)timestamp);
        this.myStartDate = DateUtils.timestamp(cal.get(1), cal.get(2) + 1, cal.get(5), 0, 0, 0, 0);
        this.myEndDate = DateUtils.timestamp(cal.get(1), cal.get(2) + 1, cal.get(5), 23, 59, 59, 999);
        this.myDayYear = cal.get(1);
        this.myDayMonth = cal.get(2) + 1;
        this.myDay = cal.get(5);
    }

    public int hashCode() {
        return this.myDayYear * 10000 + this.myDayMonth * 100 + this.myDay;
    }

    public boolean equals(Object _obj) {
        boolean equals = _obj instanceof Day;
        if (equals) {
            Day otherDay = (Day)_obj;
            equals = otherDay.myDayYear == this.myDayYear && otherDay.myDayMonth == this.myDayMonth && otherDay.myDay == this.myDay;
        }
        return equals;
    }

    public int year() {
        return this.myDayYear;
    }

    public int month() {
        return this.myDayMonth;
    }

    public Month monthObject() {
        return new Month(this.myDayMonth, this.myDayYear);
    }

    public int day() {
        return this.myDay;
    }

    public Day next() {
        Calendar dayCal = this.endCalendar();
        dayCal.add(10, 12);
        return Day.day(dayCal);
    }

    public Day previous() {
        Calendar dayCal = this.startCalendar();
        dayCal.add(10, -12);
        return Day.day(dayCal);
    }

    public boolean today() {
        Calendar now = Calendar.getInstance();
        boolean today = this.myDayYear == now.get(1) && this.myDayMonth == now.get(2) + 1 && this.myDay == now.get(5);
        return today;
    }

    public boolean weekend() {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.myStartDate);
        int dayOfWeek = cal.get(7);
        boolean weekend = dayOfWeek == 1 || dayOfWeek == 7;
        return weekend;
    }

    public Calendar startCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.myStartDate);
        return cal;
    }

    public NSTimestamp startDate() {
        return this.myStartDate;
    }

    public NSTimestamp now() {
        Calendar nowCalendar = Calendar.getInstance();
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.myStartDate);
        cal.set(11, nowCalendar.get(11));
        cal.set(12, nowCalendar.get(12));
        NSTimestamp now = new NSTimestamp(cal.getTime());
        return now;
    }

    public NSTimestamp endDate() {
        return this.myEndDate;
    }

    public NSTimestamp workStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.myStartDate);
        cal.set(11, 9);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        NSTimestamp workStart = new NSTimestamp(cal.getTime());
        return workStart;
    }

    public NSTimestamp workEndDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.myEndDate);
        cal.set(11, 18);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        NSTimestamp workEnd = new NSTimestamp(cal.getTime());
        return workEnd;
    }

    public Calendar endCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.myEndDate);
        return cal;
    }

    public Day monthsAgo(int months) {
        Calendar cal = this.startCalendar();
        cal.add(2, -1 * months);
        return new Day(new NSTimestamp(cal.getTime()));
    }

    public Day monthsFromNow(int months) {
        Calendar cal = this.startCalendar();
        cal.add(2, months);
        return new Day(new NSTimestamp(cal.getTime()));
    }

    public Day yearsAgo(int years) {
        Calendar cal = this.startCalendar();
        cal.add(1, -1 * years);
        return new Day(new NSTimestamp(cal.getTime()));
    }

    public Day yearsFromNow(int years) {
        Calendar cal = this.startCalendar();
        cal.add(1, 1 * years);
        return new Day(new NSTimestamp(cal.getTime()));
    }

    public Day daysAgo(int days) {
        Calendar cal = this.startCalendar();
        cal.add(5, -1 * days);
        return new Day(new NSTimestamp(cal.getTime()));
    }

    public Day daysFromNow(int days) {
        Calendar cal = this.startCalendar();
        cal.add(5, days);
        return new Day(new NSTimestamp(cal.getTime()));
    }

    public EOQualifier qualifier(String key) {
        return DateUtils.keypathWithinDateRangeQualifier(key, this.startDate(), this.endDate());
    }

    public EOQualifier workQualifier(String key) {
        return DateUtils.keypathWithinDateRangeQualifier(key, this.workStartDate(), this.workEndDate());
    }

    public Day weeksAgo(int weeks) {
        int days = weeks * 7;
        Calendar cal = this.startCalendar();
        cal.add(5, -1 * days);
        return new Day(new NSTimestamp(cal.getTime()));
    }

    public Day weeksFromNow(int weeks) {
        int days = weeks * 7;
        Calendar cal = this.startCalendar();
        cal.add(5, days);
        return new Day(new NSTimestamp(cal.getTime()));
    }

    public boolean before(Day day) {
        return this.startDate().before((Timestamp)day.startDate());
    }

    public boolean after(Day day) {
        return this.endDate().after((Timestamp)day.endDate());
    }

    public String toString() {
        return "[Day: " + this.myDayYear + "/" + this.myDayMonth + "/" + this.myDay + "]";
    }

    public static Day todayDay() {
        return Day.day(Calendar.getInstance());
    }

    public static Day day(Date _date) {
        if (_date == null) {
            throw new IllegalArgumentException("You must provide a date.");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(_date);
        return Day.day(calendar);
    }

    public static Day day(Calendar _calendar) {
        Day today = new Day(_calendar.get(1), _calendar.get(2) + 1, _calendar.get(5));
        return today;
    }

    public int compareTo(Object o) {
        Day day = (Day)o;
        if (this.myDayYear == day.myDayYear) {
            if (this.myDayMonth == day.myDayMonth) {
                if (this.myDay == day.myDay) {
                    return 0;
                }
                if (this.myDay > day.myDay) {
                    return 1;
                }
                if (this.myDay < day.myDay) {
                    return -1;
                }
                throw new IllegalStateException("Invalid comparison state.");
            }
            if (this.myDayMonth > day.myDayMonth) {
                return 1;
            }
            if (this.myDayMonth < day.myDayMonth) {
                return -1;
            }
            throw new IllegalStateException("Invalid comparison state.");
        }
        if (this.myDayYear > day.myDayYear) {
            return 1;
        }
        if (this.myDayYear < day.myDayYear) {
            return -1;
        }
        throw new IllegalStateException("Invalid comparison state.");
    }
}

