/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.util;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;
import er.ajax.example2.util.DateRange;
import er.ajax.example2.util.DateUtils;
import er.ajax.example2.util.Day;
import er.ajax.example2.util.Week;
import er.ajax.example2.util.Year;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Month {
    private int _month;
    private int _year;
    private NSArray<NSArray<Day>> _weeks;
    private NSMutableArray<Week> _weekObjects;

    public Month(Calendar _cal) {
        this(_cal.get(2) + 1, _cal.get(1));
    }

    public Month(int month, int year) {
        this._month = month;
        this._year = year;
    }

    public int month() {
        return this._month;
    }

    public int year() {
        return this._year;
    }

    public Year yearObject() {
        return new Year(this._year);
    }

    public void setYear(int year) {
        this._year = year;
        this._weeks = null;
        this._weekObjects = null;
    }

    public String shortMonthName() {
        String monthFormat = DateUtils.SHORT_MONTH_NAME_FORMATTER.format((Object)this.monthTimestamp());
        return monthFormat;
    }

    public String monthName() {
        String monthFormat = DateUtils.MONTH_NAME_FORMATTER.format((Object)this.monthTimestamp());
        return monthFormat;
    }

    public String monthAndYearName() {
        String monthFormat = DateUtils.MONTH_NAME_AND_YEAR_FORMATTER.format((Object)this.monthTimestamp());
        return monthFormat;
    }

    public String shortMonthAndYearName() {
        String monthFormat = DateUtils.SHORT_MONTH_NAME_AND_YEAR_FORMATTER.format((Object)this.monthTimestamp());
        return monthFormat;
    }

    public Calendar monthCalendar() {
        Calendar monthCalendar = Calendar.getInstance();
        monthCalendar.set(5, 1);
        monthCalendar.set(1, this._year);
        monthCalendar.set(2, this._month - 1);
        return monthCalendar;
    }

    public NSTimestamp monthTimestamp() {
        NSTimestamp calendarTimestamp = DateUtils.timestamp(this._year, this._month, 1, 0, 0, 0, 0);
        return calendarTimestamp;
    }

    public int hashCode() {
        return this._month + this._year;
    }

    public boolean equals(Object _obj) {
        Month otherMonth = (Month)_obj;
        boolean equals = otherMonth != null && otherMonth._month == this._month && otherMonth._year == this._year;
        return equals;
    }

    public Day firstDay() {
        Calendar monthCalendar = this.monthCalendar();
        monthCalendar.set(5, 1);
        Day firstDay = Day.day(monthCalendar);
        return firstDay;
    }

    public Day lastDay() {
        Calendar monthCalendar = this.monthCalendar();
        monthCalendar.set(5, monthCalendar.getActualMaximum(5));
        Day lastDay = Day.day(monthCalendar);
        return lastDay;
    }

    public Month previousMonth() {
        Calendar previousMonthCalendar = this.monthCalendar();
        previousMonthCalendar.add(2, -1);
        Month previousMonth = new Month(previousMonthCalendar);
        return previousMonth;
    }

    public Month nextMonth() {
        Calendar nextMonthCalendar = this.monthCalendar();
        nextMonthCalendar.add(2, 1);
        Month nextMonth = new Month(nextMonthCalendar);
        return nextMonth;
    }

    public NSArray<NSArray<Day>> weeks() {
        if (this._weeks == null) {
            Calendar calendar = this.monthCalendar();
            int dayOfWeek = calendar.get(7);
            int maxDaysInMonth = calendar.getActualMaximum(5);
            calendar.add(5, -(dayOfWeek - 1));
            NSMutableArray weeks = new NSMutableArray();
            int maxDaysInWeek = calendar.getMaximum(7);
            int maxDays = dayOfWeek - 1 + maxDaysInMonth;
            int daysFromNextMonth = maxDays % maxDaysInWeek;
            if (daysFromNextMonth != 0) {
                maxDays += maxDaysInWeek - daysFromNextMonth;
            }
            int dayNum = 0;
            while (dayNum < maxDays) {
                NSMutableArray daysInWeek = new NSMutableArray();
                int dayOfWeekNum = 0;
                while (dayOfWeekNum < maxDaysInWeek) {
                    Day day = new Day(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                    daysInWeek.addObject((Object)day);
                    calendar.add(5, 1);
                    ++dayOfWeekNum;
                    ++dayNum;
                }
                weeks.addObject((Object)daysInWeek);
            }
            this._weeks = weeks;
        }
        return this._weeks;
    }

    public NSArray<Week> weekObjects() {
        NSMutableArray weekObjects = this._weekObjects;
        if (weekObjects == null) {
            weekObjects = new NSMutableArray();
            this.weeks();
            for (int i = 0; i < this._weeks.count(); ++i) {
                NSArray week = (NSArray)this._weeks.get(i);
                weekObjects.add((Object)Week.containingWeekForDay((Day)week.get(0)));
            }
            this._weekObjects = weekObjects;
        }
        return weekObjects;
    }

    public DateRange visibleDateRange() {
        NSArray<Week> weeks = this.weekObjects();
        NSTimestamp startDate = ((Week)weeks.objectAtIndex(0)).getStartTime();
        NSTimestamp endDate = ((Week)weeks.lastObject()).getEndTime();
        return new DateRange(startDate, endDate);
    }

    public String toString() {
        return "[Month: " + this._month + "/" + this._year + "]";
    }

    public static Month month(NSTimestamp date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)date);
        Month month = new Month(cal);
        return month;
    }

    public static Month firstMonthOfThisYear() {
        Calendar now = Calendar.getInstance();
        Month month = new Month(1, now.get(1));
        return month;
    }

    public static Month firstMonthOfYear(int year) {
        Calendar now = Calendar.getInstance();
        Month month = new Month(1, year);
        return month;
    }

    public static NSArray<Month> allMonths(int year) {
        return Month.months(Month.firstMonthOfYear(year), 0, 12);
    }

    public static NSArray<Month> allMonths() {
        return Month.months(Month.firstMonthOfThisYear(), 0, 12);
    }

    public static NSArray<Month> months(Month startingMonth, Month endingMonth) {
        if (endingMonth._year < startingMonth._year || endingMonth._year == startingMonth._year && endingMonth._month < startingMonth._month) {
            throw new IllegalArgumentException("Ending month was before starting month.");
        }
        NSMutableArray months = new NSMutableArray();
        Calendar monthCalendar = startingMonth.monthCalendar();
        Month month = startingMonth;
        do {
            months.addObject((Object)month);
            monthCalendar.add(2, 1);
        } while (!(month = new Month(monthCalendar)).equals(endingMonth));
        return months;
    }

    public static NSArray<Month> months(Month startingMonth, int offset, int count) {
        NSMutableArray months = new NSMutableArray();
        Calendar monthCalendar = startingMonth.monthCalendar();
        monthCalendar.add(2, offset);
        for (int i = 0; i < count; ++i) {
            months.addObject((Object)new Month(monthCalendar));
            monthCalendar.add(2, 1);
        }
        return months;
    }

    public static Month thisMonth() {
        Calendar now = Calendar.getInstance();
        Month thisMonth = new Month(now);
        return thisMonth;
    }
}

