/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.util;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import er.ajax.example2.util.ComparisonUtils;
import er.ajax.example2.util.ExceptionUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class StringUtils {
    public static String trim(String str) {
        String trimmedStr = str;
        if (trimmedStr != null) {
            trimmedStr = str.trim();
        }
        return trimmedStr;
    }

    public static String randomString(int length) {
        StringBuffer foo = new StringBuffer();
        for (int ii = 0; ii < length; ++ii) {
            foo.append((char)(new Random().nextInt(74) + 48));
        }
        return foo.toString();
    }

    public static String randomStringAlphaNumeric(int length) {
        return StringUtils.randomStringAlphaNumeric(length, null);
    }

    public static String randomStringAlphaNumeric(int length, String banCharacters) {
        StringBuffer randomBuffer = new StringBuffer();
        do {
            randomBuffer.append(UUID.randomUUID().toString());
            if (banCharacters == null) continue;
            randomBuffer = new StringBuffer(randomBuffer.toString().replaceAll("[" + banCharacters + "]", ""));
        } while (randomBuffer.length() < length);
        String randomStr = randomBuffer.toString();
        return randomStr.substring(randomStr.length() - length, randomStr.length());
    }

    public static String randomUnconfusingString(int length) {
        return StringUtils.randomStringAlphaNumeric(length, "0oO1l");
    }

    public static String strip(String str) {
        String stripped = str;
        if (stripped != null) {
            stripped = stripped.replaceAll("<[^>]*>", " ");
            stripped = stripped.replaceAll("\\s+", " ");
            stripped = stripped.replaceAll("&#8217;", "'");
            stripped = stripped.replaceAll("&#169;", "(C)");
            stripped = stripped.replaceAll("&#215;", " x ");
            stripped = stripped.replaceAll("&#8230;", "...");
            stripped = stripped.replaceAll("&#8212;", " -- ");
            stripped = stripped.replaceAll("&#8211;", " - ");
            stripped = stripped.replaceAll("&#8220;", "\"");
            stripped = stripped.replaceAll("&#8221;", "\"");
            stripped = stripped.replaceAll("&#174;", "(C)");
            stripped = stripped.replaceAll("&#174;", "(R)");
            stripped = stripped.replaceAll("&#8482;", "(TM)");
            stripped = stripped.trim();
        }
        return stripped;
    }

    public static String stringToHTMLString(String string) {
        String htmlString;
        if (string == null) {
            htmlString = null;
        } else {
            int len = string.length();
            StringBuffer sb = new StringBuffer(len);
            boolean lastWasBlankChar = false;
            for (int i = 0; i < len; ++i) {
                char c = string.charAt(i);
                if (c == ' ') {
                    if (lastWasBlankChar) {
                        lastWasBlankChar = false;
                        sb.append("&nbsp;");
                        continue;
                    }
                    lastWasBlankChar = true;
                    sb.append(' ');
                    continue;
                }
                lastWasBlankChar = false;
                if (c == '\"') {
                    sb.append("&quot;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    sb.append("&gt;");
                    continue;
                }
                if (c == '\n') {
                    sb.append("<br/>");
                    continue;
                }
                int ci = 0xFFFF & c;
                if (ci < 160) {
                    sb.append(c);
                    continue;
                }
                sb.append("&#");
                sb.append(new Integer(ci).toString());
                sb.append(';');
            }
            htmlString = sb.toString();
        }
        return htmlString;
    }

    public static String stringToJavascriptString(String string) {
        if (string != null) {
            string = string.replaceAll("\n", "\\\\n");
            string = string.replaceAll("\"", "\\\"");
            string = string.replaceAll("\r", "");
        }
        return string;
    }

    public static String stringToXMLString(String string) {
        String _xmlString = "";
        if (string == null) {
            _xmlString = null;
        } else {
            int len = string.length();
            StringBuffer sb = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    sb.append("&quot;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    sb.append("&gt;");
                    continue;
                }
                if (c == '\'') {
                    sb.append("&apos");
                    continue;
                }
                sb.append(c);
            }
            _xmlString = sb.toString();
        }
        return new String(string);
    }

    public static void appendField(StringBuffer _buffer, String _label, String _value) {
        _buffer.append(_label);
        _buffer.append(": ");
        _buffer.append(_value);
        _buffer.append("\n");
    }

    public static String md5(String _encrypt) {
        try {
            byte[] _digest = MessageDigest.getInstance("MD5").digest(_encrypt.getBytes());
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < _digest.length; ++i) {
                String hexDigitStr = Integer.toHexString(0xFF & _digest[i]);
                if (hexDigitStr.length() == 1) {
                    hexString.append("0");
                }
                hexString.append(hexDigitStr);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Every VM should have MD5.");
        }
    }

    public static String toLowerCase(String _str) {
        return _str == null ? null : _str.toLowerCase();
    }

    public static boolean quicksilverContains(String _str, String _searchString) {
        boolean equals;
        if (_str == null) {
            equals = false;
        } else {
            equals = true;
            if (_searchString != null && _searchString.length() > 0) {
                int searchStringLength = _searchString.length();
                int strLength = _str.length();
                int strPos = 0;
                for (int searchStringPos = 0; equals && searchStringPos < searchStringLength; ++searchStringPos) {
                    char searchStringCh = Character.toLowerCase(_searchString.charAt(searchStringPos));
                    boolean searchStringChFound = false;
                    while (!searchStringChFound && strPos < strLength) {
                        char strCh = _str.charAt(strPos);
                        searchStringChFound = Character.toLowerCase(strCh) == searchStringCh;
                        ++strPos;
                    }
                    if (searchStringChFound) continue;
                    equals = false;
                }
            }
        }
        return equals;
    }

    public static NSArray filteredArrayWithQuicksilverContains(NSArray _elements, String _displayKey, String _contains) {
        NSMutableArray matchingElements = new NSMutableArray();
        Enumeration elementsEnum = _elements.objectEnumerator();
        while (elementsEnum.hasMoreElements()) {
            Object element = elementsEnum.nextElement();
            String displayStr = (String)NSKeyValueCoding.Utility.valueForKey(element, (String)_displayKey);
            if (!StringUtils.quicksilverContains(displayStr, _contains)) continue;
            matchingElements.addObject(element);
        }
        return matchingElements;
    }

    public static void joinStrings(StringBuffer _buffer, List _strings, String _joinWith) {
        Iterator stringsIter = _strings.iterator();
        while (stringsIter.hasNext()) {
            String str = (String)stringsIter.next();
            _buffer.append(str);
            if (!stringsIter.hasNext()) continue;
            _buffer.append(_joinWith);
        }
    }

    public static String toErrorString(Throwable _throwable) {
        StringBuffer messageBuffer = new StringBuffer();
        boolean foundInternalError = false;
        Throwable t = _throwable;
        while (t != null) {
            Throwable oldThrowable = ExceptionUtils.getMeaningfulException(t);
            String message = t.getMessage();
            if (message == null) {
                if (!foundInternalError) {
                    message = "Your request produced an error.";
                    foundInternalError = true;
                } else {
                    message = "";
                }
            }
            message = message.replaceAll("<[^>]+>", "");
            message = message.trim();
            messageBuffer.append(message);
            if (!message.endsWith(".")) {
                messageBuffer.append(". ");
            } else {
                messageBuffer.append(" ");
            }
            if ((t = oldThrowable.getCause()) != oldThrowable) continue;
            t = null;
        }
        return messageBuffer.toString();
    }

    public static String compact(String string) {
        if (string != null) {
            return string.replace(" ", "");
        }
        return null;
    }

    public static boolean empty(String str) {
        return ComparisonUtils.empty(str);
    }

    public static boolean empty(String str, boolean trim) {
        return ComparisonUtils.empty(str, trim);
    }

    public static boolean notEmpty(String str) {
        return ComparisonUtils.notEmpty(str);
    }

    public static boolean notEmpty(String str, boolean trim) {
        return ComparisonUtils.notEmpty(str, trim);
    }

    public static String fullName(String firstName, String lastName, String defaultDisplayName) {
        StringBuffer displayNameBuffer = new StringBuffer();
        boolean hasFirstName = false;
        if (ComparisonUtils.notEmpty(firstName)) {
            displayNameBuffer.append(firstName);
            hasFirstName = true;
        }
        if (ComparisonUtils.notEmpty(lastName)) {
            if (hasFirstName) {
                displayNameBuffer.append(' ');
            }
            displayNameBuffer.append(lastName);
        }
        if (displayNameBuffer.length() == 0 && defaultDisplayName != null) {
            displayNameBuffer.append(defaultDisplayName);
        }
        return displayNameBuffer.toString();
    }
}

