/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.util;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSTimestamp;
import er.ajax.example2.util.DateUtils;
import er.ajax.example2.util.Day;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Week {
    private Day _startDay;
    private Day _endDay;

    public static Week containingWeekForDay(Day day) {
        Calendar baseCalendar = day.startCalendar();
        Calendar sundayCal = (Calendar)baseCalendar.clone();
        sundayCal.set(7, 1);
        Day sunday = Day.day(sundayCal);
        Calendar saturdayCal = (Calendar)baseCalendar.clone();
        saturdayCal.set(7, 7);
        Day saturday = Day.day(saturdayCal);
        Week week = new Week();
        week.setStartDay(sunday);
        week.setEndDay(saturday);
        return week;
    }

    public static Week thisWeek() {
        return Week.containingWeekForDay(Day.todayDay());
    }

    public void setEndDay(Day endDay) {
        this._endDay = endDay;
    }

    public Day getEndDay() {
        return this._endDay;
    }

    public NSTimestamp getEndTime() {
        return this._endDay.endDate();
    }

    public void setStartDay(Day startDay) {
        this._startDay = startDay;
    }

    public Day getStartDay() {
        return this._startDay;
    }

    public NSTimestamp getStartTime() {
        return this._startDay.startDate();
    }

    public Week nextWeek() {
        return Week.containingWeekForDay(this._endDay.daysFromNow(1));
    }

    public Week previousWeek() {
        return Week.containingWeekForDay(this._startDay.daysFromNow(-1));
    }

    public int hashCode() {
        return this._startDay.hashCode() + this._endDay.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Week && ((Week)obj)._startDay.equals(this._startDay) && ((Week)obj)._endDay.equals(this._endDay);
    }

    public NSArray<Day> getDays() {
        return DateUtils.daysBetween(this._startDay.startDate(), this._endDay.startDate());
    }

    public boolean containsDay(Day day) {
        return day.after(this._startDay) && day.before(this._endDay);
    }

    public String toString() {
        return "Week: [" + this.getStartDay() + ", " + this.getEndDay() + "]";
    }

    public static void main(String[] args) {
        Week week = Week.containingWeekForDay(Day.todayDay().daysFromNow(2));
        System.out.println("Week.main: " + week.getStartDay() + " - " + week.getEndDay());
        System.out.println("Week.main: " + week.getDays());
    }
}

