/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.rentals.common;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGenericRecord;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValidation;
import java.math.BigDecimal;
import webobjectsexamples.businesslogic.rentals.common.FeeType;
import webobjectsexamples.businesslogic.rentals.common.Rental;

public class Fee
extends EOGenericRecord {
    private static final long serialVersionUID = -6593943328561415279L;
    public static final String AmountKey = "amount";
    public static final String DatePaidKey = "datePaid";
    public static final String FeeTypeKey = "feeType";
    public static final String RentalKey = "rental";
    private static final String _CostKeyPath = "rental.unit.video.rentalTerms.cost";
    public static final int LateFeeAmountPerDay = 3;

    public Fee() {
    }

    public Fee(NSTimestamp date, EOEditingContext editingContext) {
        this();
        this.setFeeType(FeeType.lateFeeType(editingContext));
        long time = new NSTimestamp().getTime() - date.getTime();
        int elapsedDays = (int)(time / 86400000L);
        this.setAmount(new BigDecimal((elapsedDays + 1) * 3));
    }

    public void awakeFromInsertion(EOEditingContext editingContext) {
        super.awakeFromInsertion(editingContext);
        if (this.amount() == null) {
            this.setAmount((BigDecimal)this.valueForKeyPath(_CostKeyPath));
        }
        if (this.feeType() == null) {
            this.setFeeType(FeeType.defaultFeeType(editingContext));
        }
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        if (!this.isPaid()) {
            throw new NSValidation.ValidationException("You can't remove an unpaid fee!");
        }
        super.validateForDelete();
    }

    public BigDecimal amount() {
        return (BigDecimal)this.storedValueForKey(AmountKey);
    }

    public void setAmount(BigDecimal value) {
        this.takeStoredValueForKey(value, AmountKey);
    }

    public NSTimestamp datePaid() {
        return (NSTimestamp)this.storedValueForKey(DatePaidKey);
    }

    public void setDatePaid(NSTimestamp value) {
        this.takeStoredValueForKey(value, DatePaidKey);
    }

    public FeeType feeType() {
        return (FeeType)((Object)this.storedValueForKey(FeeTypeKey));
    }

    public void setFeeType(FeeType value) {
        this.takeStoredValueForKey((Object)value, FeeTypeKey);
    }

    public Rental rental() {
        return (Rental)((Object)this.storedValueForKey(RentalKey));
    }

    public void setRental(Rental value) {
        this.takeStoredValueForKey((Object)value, RentalKey);
        if (this.amount() == null) {
            this.setAmount((BigDecimal)this.valueForKeyPath(_CostKeyPath));
        }
    }

    public boolean isPaid() {
        return this.datePaid() != null;
    }

    public void pay() {
        this.setDatePaid(new NSTimestamp());
        Rental rental = this.rental();
        if (rental != null) {
            rental.feePaid();
        }
    }
}

