/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import er.bugtracker.Bug;
import er.bugtracker.Comment;
import er.bugtracker.Component;
import er.bugtracker.Framework;
import er.bugtracker.People;
import er.bugtracker.Priority;
import er.bugtracker.Release;
import er.bugtracker.Requirement;
import er.bugtracker.RequirementSubType;
import er.bugtracker.RequirementType;
import er.bugtracker.State;
import er.bugtracker.TestItem;
import er.bugtracker.TestItemState;
import er.bugtracker._Requirement;
import er.extensions.components.ERXLoremIpsumGenerator;
import er.extensions.foundation.ERXStringUtilities;
import java.util.Random;
import org.apache.log4j.Logger;

public class BTDataCreator {
    private static final Logger log = Logger.getLogger(BTDataCreator.class);
    EOEditingContext ec;
    NSMutableArray<People> users = new NSMutableArray();
    NSMutableArray<Component> components = new NSMutableArray();
    NSMutableArray<Bug> bugs = new NSMutableArray();
    NSMutableArray<Requirement> requirements = new NSMutableArray();
    NSMutableArray<TestItem> testItems = new NSMutableArray();
    NSMutableArray<Priority> priorities = new NSMutableArray();
    NSMutableArray<TestItemState> testItemStates = new NSMutableArray();
    NSMutableArray<State> states = new NSMutableArray();
    NSMutableArray<Release> releases = new NSMutableArray();
    NSMutableArray<RequirementType> requirementTypes = new NSMutableArray();
    NSMutableArray<RequirementSubType> requirementSubTypes = new NSMutableArray();

    public BTDataCreator(EOEditingContext editingContext) {
        this.ec = editingContext;
    }

    private int randomInt(int max) {
        return new Random().nextInt(max);
    }

    private Object randomObject(NSArray array) {
        return array.objectAtIndex(this.randomInt(array.count()));
    }

    private Priority randomPriority() {
        return (Priority)((Object)this.randomObject((NSArray)this.priorities));
    }

    private People randomUser() {
        return (People)((Object)this.randomObject((NSArray)this.users));
    }

    private Component randomComponent() {
        return (Component)((Object)this.randomObject((NSArray)this.components));
    }

    private Bug randomBug() {
        return (Bug)this.randomObject((NSArray)this.bugs);
    }

    private Requirement randomRequirement() {
        return (Requirement)this.randomObject((NSArray)this.requirements);
    }

    private RequirementType randomRequirementType() {
        return (RequirementType)((Object)this.randomObject((NSArray)this.requirementTypes));
    }

    private RequirementSubType randomRequirementSubType() {
        return (RequirementSubType)((Object)this.randomObject((NSArray)this.requirementSubTypes));
    }

    private State randomState() {
        return (State)((Object)this.randomObject((NSArray)this.states));
    }

    private TestItemState randomTestItemState() {
        return (TestItemState)((Object)this.randomObject((NSArray)this.testItemStates));
    }

    private Release randomRelease() {
        return (Release)((Object)this.randomObject((NSArray)this.releases));
    }

    private NSTimestamp randomTimestamp() {
        return new NSTimestamp().timestampByAddingGregorianUnits(0, 0, 0, -this.randomInt(24000), 0, 0);
    }

    private String randomWords(int size) {
        return ERXLoremIpsumGenerator.words((int)5, (int)(size / 7), (int)size);
    }

    private String randomText(int size) {
        return ERXLoremIpsumGenerator.paragraphs((int)size);
    }

    private void addComments(Bug bug) {
        int maxComments = this.randomInt(20);
        int last = 0;
        for (int i = 0; i < maxComments; ++i) {
            Comment comment = (Comment)Comment.clazz.createAndInsertObject(this.ec);
            int hours = last + this.randomInt(48);
            comment.setDateSubmitted(bug.dateSubmitted().timestampByAddingGregorianUnits(0, 0, 0, hours, 0, 0));
            comment.setOriginator(this.randomUser());
            comment.setTextDescription(this.randomText(50));
            last = hours;
            comment.setBug(bug);
            bug.addToComments(comment);
            comment.validateForSave();
        }
    }

    private NSDictionary optionsWithPrimaryKeySupportDiabled(NSDictionary options) {
        NSMutableDictionary mutableOptions = options.mutableClone();
        mutableOptions.setObjectForKey((Object)"NO", (Object)"createPrimaryKeySupport");
        return mutableOptions.immutableClone();
    }

    public void createDummyData() {
        Bug bug;
        int i;
        int i2;
        int i3;
        this.priorities = Priority.clazz.allObjects(this.ec).mutableClone();
        this.states = State.clazz.allObjects(this.ec).mutableClone();
        this.testItemStates = TestItemState.clazz.allObjects(this.ec).mutableClone();
        this.requirementTypes = RequirementType.clazz.allObjects(this.ec).mutableClone();
        this.requirementSubTypes = RequirementSubType.clazz.allObjects(this.ec).mutableClone();
        int maxUsers = 20;
        log.info((Object)("Creating users: " + maxUsers));
        for (i3 = 100; i3 < 100 + maxUsers; ++i3) {
            People user = (People)People.clazz.createAndInsertObject(this.ec);
            this.users.addObject((Object)user);
            user.setLogin("user" + i3);
            user.setName(ERXStringUtilities.capitalizeAllWords((String)this.randomWords(20)) + " " + i3);
            user.setEmail("dummy@localhost");
            user.setPassword("user");
            user.setIsActive(i3 % 10 != 0);
            user.setIsAdmin(i3 % 5 != 0);
            user.setIsCustomerService(i3 % 3 != 0);
            user.setIsEngineering(i3 % 3 != 0 && user.isAdmin() == false);
        }
        log.info((Object)"Saving...");
        this.ec.saveChanges();
        log.info((Object)"Creating releases, frameworks and components");
        for (i3 = 1; i3 < 10; ++i3) {
            Release release = (Release)Release.clazz.createAndInsertObject(this.ec);
            release.setName("Release R" + i3 / 2);
            if (i3 % 2 == 0) {
                release.setName("Release R" + i3 / 2 + ".1");
            }
            this.releases.addObject((Object)release);
        }
        NSTimestamp dateDue = new NSTimestamp().timestampByAddingGregorianUnits(0, 5, 0, 0, 0, 0);
        for (i2 = 8; i2 >= 0; --i2) {
            Release release = (Release)((Object)this.releases.objectAtIndex(i2));
            release.setDateDue(dateDue);
            dateDue = dateDue.timestampByAddingGregorianUnits(0, -(this.randomInt(2) + 1), 0, 0, 0, 0);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            Component component = (Component)Component.clazz.createAndInsertObject(this.ec);
            component.setOwner(this.randomUser());
            component.setTextDescription("Component " + i2 / 2);
            if (i2 % 2 == 1) {
                Component parent = (Component)((Object)this.components.lastObject());
                component.setParent(parent);
                component.setTextDescription("Component " + i2 / 2 + ".1");
            }
            this.components.addObject((Object)component);
        }
        String[] names = new String[]{"ERDirectToWeb", "ERCoreBusinessLogic", "BTBusinessLogic", "BugTracker"};
        for (int i4 = 0; i4 < names.length; ++i4) {
            String string = names[i4];
            Framework framework = (Framework)Framework.clazz.createAndInsertObject(this.ec);
            framework.setName(string);
            framework.setOrdering(new Integer(i4));
        }
        log.info((Object)"Saving...");
        this.ec.saveChanges();
        int maxItems = maxUsers * 10;
        log.info((Object)("Creating bugs: " + maxItems));
        for (i = 0; i < maxItems; ++i) {
            People.clazz.setCurrentUser(this.randomUser());
            bug = (Bug)Bug.clazz.createAndInsertObject(this.ec);
            this.bugs.addObject((Object)bug);
            bug.setDateSubmitted(this.randomTimestamp());
            bug.setDateModified(bug.dateSubmitted().timestampByAddingGregorianUnits(0, 0, 0, this.randomInt(24000), 0, 0));
            bug.setComponent(this.randomComponent());
            bug.setSubject(this.randomWords(50));
            bug.setTextDescription(this.randomText(3));
            bug.setOriginator(this.randomUser());
            bug.setOwner(this.randomUser());
            bug.setPreviousOwner(this.randomUser());
            bug.setPriority(this.randomPriority());
            bug.setState(this.randomState());
            bug.setIsFeatureRequest(i % 4 == 0);
            bug.setTargetRelease(this.randomRelease());
            this.addComments(bug);
        }
        log.info((Object)("Creating requirements: " + maxItems));
        for (i = 0; i < maxItems; ++i) {
            People.clazz.setCurrentUser(this.randomUser());
            bug = (Requirement)Requirement.clazz.createAndInsertObject(this.ec);
            this.requirements.addObject((Object)bug);
            bug.setDateSubmitted(this.randomTimestamp());
            bug.setDateModified(bug.dateSubmitted().timestampByAddingGregorianUnits(0, 0, 0, this.randomInt(2400), 0, 0));
            bug.setComponent(this.randomComponent());
            bug.setSubject(this.randomWords(50));
            bug.setTextDescription(this.randomText(3));
            bug.setOriginator(this.randomUser());
            bug.setOwner(this.randomUser());
            bug.setPreviousOwner(this.randomUser());
            bug.setPriority(this.randomPriority());
            bug.setState(this.randomState());
            bug.setIsFeatureRequest(i % 4 == 0);
            bug.setTargetRelease(this.randomRelease());
            ((_Requirement)bug).setRequirementType(this.randomRequirementType());
            ((_Requirement)bug).setRequirementSubType(this.randomRequirementSubType());
            this.addComments(bug);
        }
        log.info((Object)("Creating test items: " + maxItems * 2));
        for (i = 0; i < maxItems * 2; ++i) {
            People.clazz.setCurrentUser(this.randomUser());
            TestItem testItem = (TestItem)TestItem.clazz.createAndInsertObject(this.ec);
            this.testItems.addObject((Object)testItem);
            TestItemState state = this.randomTestItemState();
            Bug bug2 = null;
            Component component = this.randomComponent();
            if (state == TestItemState.REQ) {
                bug2 = this.randomRequirement();
            } else if (state == TestItemState.BUG) {
                bug2 = this.randomBug();
            }
            testItem.setDateCreated(this.randomTimestamp());
            testItem.setTitle(this.randomWords(50));
            testItem.setTextDescription(this.randomText(3));
            testItem.setControlled(this.randomWords(50));
            testItem.setOwner(this.randomUser());
            testItem.setState(state);
            if (bug2 != null) {
                bug2.addToTestItems(testItem);
                component = bug2.component();
            }
            testItem.setComponent(component);
        }
        People user = (People)People.clazz.createAndInsertObject(this.ec);
        user.setLogin("admin");
        user.setName("Administrator");
        user.setEmail("dummy@localhost");
        user.setPassword("admin");
        user.setIsActive(true);
        user.setIsAdmin(true);
        user.setIsCustomerService(false);
        user.setIsEngineering(true);
        log.info((Object)"Saving...");
        this.ec.saveChanges();
        log.info((Object)"Done");
    }
}

