/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker;

import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValidation;
import er.bugtracker.Comment;
import er.bugtracker.Component;
import er.bugtracker.Markable;
import er.bugtracker.People;
import er.bugtracker.Priority;
import er.bugtracker.Release;
import er.bugtracker.State;
import er.bugtracker._Bug;
import er.corebusinesslogic.ERCoreBusinessLogic;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.foundation.ERXArrayUtilities;
import er.taggable.ERTaggable;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bug
extends _Bug
implements Markable {
    static final Logger log = Logger.getLogger(Bug.class);
    protected boolean _componentChanged;
    protected boolean _ownerChanged;
    private String _newText;
    public static final BugClazz<Bug> clazz = new BugClazz();

    public void init(EOEditingContext ec) {
        super.init(ec);
        this.setPriority(Priority.MEDIUM);
        this.setState(State.ANALYZE);
        this.setTargetRelease(Release.clazz.defaultRelease(ec));
        this.setIsRead(true);
        this.setIsFeatureRequest(false);
        this.setOriginator(People.clazz.currentUser(this.editingContext()));
        this.setOwner(People.clazz.currentUser(this.editingContext()));
        this.setDateSubmitted(new NSTimestamp());
        this.setDateModified(new NSTimestamp());
        Comment comment = (Comment)Comment.clazz.createAndInsertObject(ec);
        comment.setOriginator(this.originator());
        comment.setBug(this);
    }

    public ERTaggable<Bug> taggable() {
        return ERTaggable.taggable((ERXGenericRecord)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsRead() {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            People people = (People)ERCoreBusinessLogic.actor((EOEditingContext)ec);
            Bug copy = (Bug)ERXEOControlUtilities.localInstanceOfObject((EOEditingContext)ec, (EOEnterpriseObject)this);
            if (copy != null && !copy.isRead().booleanValue() && copy.owner().equals((Object)people)) {
                copy.setIsRead(true);
                ec.saveChanges();
            }
        }
        finally {
            ec.unlock();
        }
    }

    public void markUnread() {
        this.setIsRead(false);
    }

    public void touch() {
        this.markUnread();
        this.setDateModified(new NSTimestamp());
    }

    public NSArray commentsByDate() {
        NSArray comments = this.comments();
        comments = (NSArray)comments.valueForKeyPath("@sortAsc.dateSubmitted");
        return comments;
    }

    private Comment firstComment() {
        return (Comment)((Object)this.commentsByDate().objectAtIndex(0));
    }

    public String textDescription() {
        return this.firstComment().textDescription();
    }

    public void setTextDescription(String value) {
        this.firstComment().setTextDescription(value);
    }

    @Override
    public void setComponent(Component value) {
        this.willChange();
        Component oldComponent = this.component();
        super.setComponent(value);
        if (value != null) {
            if (this.owner() == null) {
                this.setOwner(this.component().owner());
            } else if (oldComponent == null || !value.equals((Object)oldComponent)) {
                this._componentChanged = true;
            }
        }
    }

    @Override
    public void setOwner(People value) {
        this.willChange();
        People oldOwner = this.owner();
        super.setOwner(value);
        People currentUser = People.clazz.currentUser(this.editingContext());
        if (!(value == null || value == currentUser || oldOwner != null && value.equals((Object)oldOwner))) {
            this._ownerChanged = true;
            if (oldOwner != null) {
                this.setPreviousOwner(oldOwner);
            }
            this.touch();
        }
    }

    @Override
    public void setState(State newState) {
        People documenter;
        this.willChange();
        State oldState = this.state();
        if (newState == State.CLOSED && this.isFeatureRequest().booleanValue() && oldState == State.VERIFY) {
            newState = State.DOCUMENT;
        }
        super.setState(newState);
        if (newState == State.DOCUMENT && !this._ownerChanged && (documenter = People.clazz.defaultDocumenter(this.editingContext())) != null) {
            this.setOwner(documenter);
            this.setIsRead(false);
        }
        if (newState == State.VERIFY && !this._ownerChanged) {
            People verifier = People.clazz.defaultVerifier(this.editingContext());
            if (verifier != null) {
                this.setOwner(verifier);
            } else {
                this.setOwner(this.originator());
                this.touch();
            }
        }
    }

    public Object validateTargetReleaseForNewBugs() throws NSValidation.ValidationException {
        Release release = this.targetRelease();
        if (release != null && !release.isOpen().booleanValue()) {
            throw new NSValidation.ValidationException("Sorry, the release <b>" + release.valueForKey("name") + "</b> is closed. Bugs/Requirements can only be attached to open releases");
        }
        return null;
    }

    public void validateForInsert() {
        super.validateForInsert();
        this.validateTargetReleaseForNewBugs();
    }

    public void validateForUpdate() {
        if (this._componentChanged && this.component() != null && !this._ownerChanged) {
            this.setOwner(this.component().owner());
        }
        this._componentChanged = false;
        this._ownerChanged = false;
        super.validateForUpdate();
        if (this.changesFromCommittedSnapshot().count() != 1 || !this.changesFromCommittedSnapshot().allKeys().containsObject((Object)"isRead")) {
            this.touch();
        }
    }

    public boolean canForDelete() {
        return false;
    }

    public String newText() {
        return this._newText;
    }

    public void setNewText(String newValue) {
        this._newText = newValue;
        if (newValue != null && newValue.length() > 0) {
            Comment comment = (Comment)Comment.clazz.createAndInsertObject(this.editingContext());
            comment.setBug(this);
            comment.setTextDescription(newValue);
            this.addToComments(comment);
            this.touch();
        }
    }

    public NSArray sortedComments() {
        return ERXArrayUtilities.sortedArraySortedWithKey(this.comments(), (String)"dateSubmitted");
    }

    public void didUpdate() {
        super.didUpdate();
        this._newText = null;
    }

    public void close() {
        this.setState(State.CLOSED);
    }

    public void reopen() {
        this.setState(State.ANALYZE);
        this.setOwner(this.previousOwner());
    }

    public void rejectVerification() {
        this.setState(State.ANALYZE);
        this.setOwner(this.previousOwner());
    }

    public void moveToVerification() {
        this.setState(State.VERIFY);
    }

    public Number bugid() {
        return (Number)this.rawPrimaryKey();
    }

    public Number id() {
        return (Number)this.rawPrimaryKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BugClazz<Bug>
    extends _Bug._BugClazz {
        protected EOQualifier qualifierForRelease(Release release) {
            if (release != null) {
                return new EOKeyValueQualifier("targetRelease", EOQualifier.QualifierOperatorEqual, (Object)release);
            }
            return null;
        }

        protected EOQualifier qualifierForState(State state) {
            if (state != null) {
                return new EOKeyValueQualifier("state", EOQualifier.QualifierOperatorEqual, (Object)state);
            }
            return null;
        }

        protected EOQualifier qualifierForStates(State[] states) {
            return ERXEOControlUtilities.orQualifierForKeyPaths((NSArray)new NSArray((Object)"state"), (NSSelector)EOQualifier.QualifierOperatorEqual, (NSArray)new NSArray((Object[])states));
        }

        protected EOQualifier qualifierForOwner(People owner) {
            if (owner != null) {
                return new EOKeyValueQualifier("owner", EOQualifier.QualifierOperatorEqual, (Object)owner);
            }
            return null;
        }

        protected EOQualifier qualifierForRead(boolean flag) {
            return new EOKeyValueQualifier("isRead", EOQualifier.QualifierOperatorEqual, (Object)new Boolean(flag));
        }

        protected EOQualifier qualifierForPerson(People owner) {
            return ERXEOControlUtilities.orQualifier((EOQualifier)new EOKeyValueQualifier("owner", EOQualifier.QualifierOperatorEqual, (Object)owner), (EOQualifier)new EOKeyValueQualifier("originator", EOQualifier.QualifierOperatorEqual, (Object)owner));
        }

        protected EOQualifier negateQualifier(EOQualifier qualifier) {
            if (qualifier != null) {
                qualifier = new EONotQualifier(qualifier);
            }
            return qualifier;
        }

        protected EOQualifier andQualifier(EOQualifier q1, EOQualifier q2) {
            return ERXEOControlUtilities.andQualifier((EOQualifier)q1, (EOQualifier)q2);
        }

        protected EOQualifier ordQualifier(EOQualifier q1, EOQualifier q2) {
            return ERXEOControlUtilities.orQualifier((EOQualifier)q1, (EOQualifier)q2);
        }

        protected EOFetchSpecification newFetchSpecification(EOQualifier qualifier) {
            return new EOFetchSpecification(this.entityName(), qualifier, null);
        }

        protected EOFetchSpecification newFetchSpecification(EOQualifier qualifier, NSArray sorting) {
            return new EOFetchSpecification(this.entityName(), qualifier, sorting);
        }

        public EOFetchSpecification fetchSpecificationForOwnedBugs(People people) {
            EOFetchSpecification fs = this.newFetchSpecification(this.andQualifier(this.qualifierForOwner(people), this.negateQualifier(this.qualifierForState(State.CLOSED))));
            return fs;
        }

        public NSArray bugsOwnedWithUser(EOEditingContext context, People people) {
            return context.objectsWithFetchSpecification(this.fetchSpecificationForOwnedBugs(people));
        }

        public NSArray unreadBugsWithUser(EOEditingContext context, People people) {
            EOFetchSpecification fs = this.newFetchSpecification(this.andQualifier(this.qualifierForPerson(people), this.qualifierForRead(false)));
            return context.objectsWithFetchSpecification(fs);
        }

        public NSArray bugsInBuildWithTargetRelease(EOEditingContext context, Release targetRelease) {
            EOFetchSpecification fs = this.newFetchSpecification(this.andQualifier(this.qualifierForRelease(targetRelease), this.qualifierForState(State.BUILD)));
            return context.objectsWithFetchSpecification(fs);
        }

        public NSArray openBugsWithTargetRelease(EOEditingContext context, Release targetRelease) {
            EOFetchSpecification fs = this.newFetchSpecification(this.andQualifier(this.qualifierForRelease(targetRelease), this.negateQualifier(this.qualifierForState(State.CLOSED))));
            return context.objectsWithFetchSpecification(fs);
        }

        public NSArray findBugs(EOEditingContext ec, String string) {
            NSArray a = NSArray.componentsSeparatedByString((String)string, (String)" ");
            NSMutableArray quals = new NSMutableArray();
            Enumeration e = a.objectEnumerator();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                try {
                    Integer i = new Integer(s);
                    quals.addObject((Object)new EOKeyValueQualifier("id", EOQualifier.QualifierOperatorEqual, (Object)i));
                }
                catch (NumberFormatException ex) {}
            }
            EOOrQualifier or = new EOOrQualifier((NSArray)quals);
            EODatabaseDataSource ds = this.newDatabaseDataSource(ec);
            EOFetchSpecification fs = this.newFetchSpecification((EOQualifier)or, null);
            ds.setFetchSpecification(fs);
            NSArray bugs = ds.fetchObjects();
            return bugs;
        }

        public EOFetchSpecification fetchSpecificationForRecentBugs() {
            EOFetchSpecification fs = this.newFetchSpecification(this.andQualifier((EOQualifier)new EOKeyValueQualifier("dateModified", EOQualifier.QualifierOperatorGreaterThan, (Object)new NSTimestamp().timestampByAddingGregorianUnits(0, -1, 0, 0, 0, 0)), this.negateQualifier(this.qualifierForState(State.CLOSED))));
            fs.setSortOrderings(new NSArray((Object)new EOSortOrdering("dateModified", EOSortOrdering.CompareDescending)));
            fs.setIsDeep(false);
            return fs;
        }

        public NSArray allBugsForUser(EOEditingContext context, People people) {
            EOFetchSpecification fs = this.newFetchSpecification(this.qualifierForOwner(people));
            return context.objectsWithFetchSpecification(fs);
        }
    }
}

