/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import er.bugtracker.Bug;
import er.bugtracker.Requirement;
import er.bugtracker.TestItem;
import er.bugtracker._People;
import er.corebusinesslogic.ERCoreBusinessLogic;
import er.corebusinesslogic.ERCoreUserInterface;
import er.extensions.eof.ERXQ;
import er.extensions.qualifiers.ERXAndQualifier;
import org.apache.log4j.Logger;

public class People
extends _People
implements ERCoreUserInterface {
    static final Logger log = Logger.getLogger(People.class);
    public static final PeopleClazz clazz = new PeopleClazz();

    public void init(EOEditingContext ec) {
        super.init(ec);
        this.setIsActive(true);
        this.setIsAdmin(false);
        this.setIsCustomerService(false);
        this.setIsEngineering(false);
    }

    public void newPreference(EOEnterpriseObject pref) {
        this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)pref, "preferences");
    }

    public void setPreferences(NSArray array) {
        this.takeStoredValueForKey(array.mutableClone(), "preferences");
    }

    public NSArray preferences() {
        return (NSArray)this.storedValueForKey("preferences");
    }

    public boolean isDemoUser() {
        return false;
    }

    public NSArray openBugs() {
        return Bug.clazz.bugsOwnedWithUser(this.editingContext(), this);
    }

    public NSArray unreadBugs() {
        return Bug.clazz.unreadBugsWithUser(this.editingContext(), this);
    }

    public NSArray allBugs() {
        return Bug.clazz.allBugsForUser(this.editingContext(), this);
    }

    public NSArray allRequirements() {
        if (this.isEngineering().booleanValue()) {
            return Requirement.clazz.myTotalRequirementsEngineeringWithUser(this.editingContext(), this);
        }
        return Requirement.clazz.myTotalRequirementsWithUser(this.editingContext(), this);
    }

    public NSArray openRequirements() {
        if (this.isEngineering().booleanValue()) {
            return Requirement.clazz.requirementsInBuildEngineeringWithUser(this.editingContext(), this);
        }
        return Requirement.clazz.myRequirementsWithUser(this.editingContext(), this);
    }

    public NSArray openTestItems() {
        return TestItem.clazz.unclosedTestItemsWithUser(this.editingContext(), this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PeopleClazz
    extends _People._PeopleClazz {
        private EOGlobalID verifier;
        private EOGlobalID documenter;

        public People anyUser(EOEditingContext ec) {
            return (People)((Object)this.allObjects(ec).lastObject());
        }

        public People defaultDocumenter(EOEditingContext ec) {
            if (this.documenter != null) {
                return (People)ec.faultForGlobalID(this.documenter, ec);
            }
            return null;
        }

        public People defaultVerifier(EOEditingContext ec) {
            if (this.verifier != null) {
                return (People)ec.faultForGlobalID(this.verifier, ec);
            }
            return null;
        }

        public People userWithUsernamePassword(EOEditingContext ec, String user, String password) {
            NSArray<People> users = this.loginWithUsernamePassword(ec, user, password);
            if (users.count() == 1) {
                return (People)((Object)users.lastObject());
            }
            return null;
        }

        private NSArray<People> loginWithUsernamePassword(EOEditingContext ec, String user, String password) {
            ERXAndQualifier q = ERXQ.and((EOQualifier[])new EOQualifier[]{ERXQ.equals((String)"login", (Object)user), ERXQ.equals((String)"password", (Object)password)});
            return this.objectsMatchingQualifier(ec, (EOQualifier)q);
        }

        public People currentUser(EOEditingContext ec) {
            return (People)ERCoreBusinessLogic.actor((EOEditingContext)ec);
        }

        public void setCurrentUser(People people) {
            ERCoreBusinessLogic.setActor((EOEnterpriseObject)people);
        }

        public NSArray activeUsers(EOEditingContext ec) {
            return this.objectsMatchingKeyAndValue(ec, "isActive", Boolean.TRUE);
        }
    }

    public static interface Key
    extends _People.Key {
        public static final String PREFERENCES = "preferences";
    }
}

