/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.administration.mipc;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.core.mipc.MultiplexConnection;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.ObjectChannel;
import org.exolab.jms.administration.AdminConnection;
import org.exolab.jms.administration.JmsAdminServerIfc;

public class IpcJmsAdminConnection
implements JmsAdminServerIfc,
AdminConnection {
    private MultiplexConnectionIfc _mc = null;
    private IpcIfc _connection = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$administration$mipc$IpcJmsAdminConnection == null ? (class$org$exolab$jms$administration$mipc$IpcJmsAdminConnection = IpcJmsAdminConnection.class$("org.exolab.jms.administration.mipc.IpcJmsAdminConnection")) : class$org$exolab$jms$administration$mipc$IpcJmsAdminConnection));
    private String _host;
    private int _port;
    private String _connectionId = null;
    static /* synthetic */ Class class$org$exolab$jms$administration$mipc$IpcJmsAdminConnection;

    protected IpcJmsAdminConnection(String host, int port) {
        this._host = host;
        this._port = port;
    }

    public IpcJmsAdminConnection(String host, int port, String username, String password) throws JMSException {
        this(host, port);
        this.connect(username, password);
    }

    public boolean addDurableConsumer(String topic, String name) throws JMSException {
        Vector v = this.pack("addDurableConsumer", 2);
        v.add(topic);
        v.add(name);
        this.send(v);
        return this.checkReply("addDurableConsumer");
    }

    public boolean removeDurableConsumer(String name) throws JMSException {
        Vector v = this.pack("removeDurableConsumer", 1);
        v.add(name);
        this.send(v);
        return this.checkReply("removeDurableConsumer");
    }

    public Vector getDurableConsumers(String topic) throws JMSException {
        Vector v = this.pack("getDurableConsumers", 1);
        v.add(topic);
        this.send(v);
        return (Vector)this.getReply("getDurableConsumers");
    }

    public boolean durableConsumerExists(String name) throws JMSException {
        Vector v = this.pack("durableConsumerExists", 1);
        v.add(name);
        this.send(v);
        return this.checkReply("durableConsumerExists");
    }

    public boolean isConnected(String name) throws JMSException {
        Vector v = this.pack("isConnected", 1);
        v.add(name);
        this.send(v);
        return this.checkReply("isConnected");
    }

    public boolean unregisterConsumer(String name) throws JMSException {
        Vector v = this.pack("unregisterConsumer", 1);
        v.add(name);
        this.send(v);
        return this.checkReply("unregisterConsumer");
    }

    public boolean addDestination(String destination, Boolean queue) throws JMSException {
        Vector v = this.pack("addDestination", 2);
        v.add(destination);
        v.add(queue);
        this.send(v);
        return this.checkReply("addDestination");
    }

    public boolean removeDestination(String name) throws JMSException {
        Vector v = this.pack("removeDestination", 1);
        v.add(name);
        this.send(v);
        return this.checkReply("removeDestination");
    }

    public boolean destinationExists(String name) throws JMSException {
        Vector v = this.pack("destinationExists", 1);
        v.add(name);
        this.send(v);
        return this.checkReply("destinationExists");
    }

    public Vector getAllDestinations() throws JMSException {
        Vector v = this.pack("getAllDestinations", 0);
        this.send(v);
        return (Vector)this.getReply("getAllDestinations");
    }

    public int getDurableConsumerMessageCount(String topic, String name) throws JMSException {
        Vector v = this.pack("getDurableConsumerMessageCount", 2);
        v.add(topic);
        v.add(name);
        this.send(v);
        Integer result = (Integer)this.getReply("getDurableConsumerMessageCount");
        return result;
    }

    public int getQueueMessageCount(String queue) throws JMSException {
        Vector v = this.pack("getQueueMessageCount", 1);
        v.add(queue);
        this.send(v);
        return (Integer)this.getReply("getQueueMessageCount");
    }

    public int purgeMessages() throws JMSException {
        Vector v = this.pack("purgeMessages", 0);
        this.send(v);
        return (Integer)this.getReply("purgeMessages");
    }

    public void stopServer() throws JMSException {
        Vector v = this.pack("stopServer", 0);
        this.send(v);
        this.checkReply("stopServer");
    }

    public void close() {
        if (this._connection != null) {
            try {
                this._connection.close();
                this._mc.finish();
            }
            catch (Exception exception) {
                _log.debug((Object)"Exception during close", (Throwable)exception);
            }
            this._connection = null;
            this._mc = null;
        }
    }

    public boolean addUser(String username, String password) throws JMSException {
        Vector v = this.pack("addUser", 2);
        v.add(username);
        v.add(password);
        this.send(v);
        return this.checkReply("addUser");
    }

    public Vector getAllUsers() throws JMSException {
        Vector v = this.pack("getAllUsers", 0);
        this.send(v);
        return (Vector)this.getReply("getAllUsers");
    }

    public boolean removeUser(String username) throws JMSException {
        Vector v = this.pack("removeUser", 1);
        v.add(username);
        this.send(v);
        return this.checkReply("removeUser");
    }

    public boolean changePassword(String username, String password) throws JMSException {
        Vector v = this.pack("changePassword", 2);
        v.add(username);
        v.add(password);
        this.send(v);
        return this.checkReply("changePassword");
    }

    protected String getHost() {
        return this._host;
    }

    protected int getPort() {
        return this._port;
    }

    protected IpcIfc getConnection() {
        return this._connection;
    }

    protected void setConnection(IpcIfc connection) {
        this._connection = connection;
    }

    protected void openConnection() throws JMSException {
        try {
            this._mc = this.createClientConnection(this._host, this._port);
            this._connection = new ObjectChannel("server", this._mc);
            ((Thread)this._mc).start();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
    }

    protected void connect(String username, String password) throws JMSException {
        this.openConnection();
        Vector v = this.pack("createConnection", 2);
        v.add(username);
        v.add(password);
        this.send(v);
        this._connectionId = (String)this.getReply("createConnection");
    }

    protected MultiplexConnectionIfc createClientConnection(String host, int port) throws IOException {
        return new MultiplexConnection(host, port);
    }

    private Vector pack(String method, int num) {
        Vector<String> v = new Vector<String>(3 + num);
        v.add("org.exolab.jms.server.mipc.IpcJmsAdminConnection");
        v.add(method);
        v.add(this._connectionId);
        return v;
    }

    private void send(Vector v) throws JMSException {
        try {
            this._connection.send((Serializable)v);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
    }

    private boolean checkReply(String method) throws JMSException {
        boolean reply = false;
        try {
            Vector v = (Vector)this._connection.receive();
            if (v != null) {
                Boolean b = (Boolean)v.get(0);
                if (!b.booleanValue()) {
                    if (v.get(1) instanceof JMSException) {
                        throw (JMSException)v.get(1);
                    }
                    throw new JMSException("Operation " + method + " failed:\n" + v.get(1));
                }
            } else {
                throw new JMSException("Unknown connection error for " + method);
            }
            reply = (Boolean)v.get(1);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return reply;
    }

    private Object getReply(String method) throws JMSException {
        Object reply = null;
        try {
            Vector v = (Vector)this._connection.receive();
            if (v != null) {
                Boolean b = (Boolean)v.get(0);
                if (!b.booleanValue()) {
                    if (v.get(1) instanceof JMSException) {
                        throw (JMSException)v.get(1);
                    }
                    throw new JMSException("Operation " + method + " failed:\n" + v.get(1));
                }
            } else {
                throw new JMSException("Unknown connection error for " + method);
            }
            reply = v.get(1);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return reply;
    }

    private void raise(Exception exception) throws JMSException {
        if (exception instanceof JMSException) {
            throw (JMSException)exception;
        }
        JMSException error = new JMSException(exception.getMessage());
        error.setLinkedException(exception);
        throw error;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

