/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation._NSUtilitiesExtra;

public class _NSCollectionPrimitives {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation._NSCollectionPrimitives");
    public static final int IntegerNotAvailable = Integer.MIN_VALUE;
    public static final Object[] EmptyArray = new Object[0];
    public static final int[] EmptyIntegerArray = new int[0];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final byte EmptyFlag = 0;
    public static final byte DeletedFlag = 64;
    public static final byte OccupiedFlag = -128;
    public static final byte StatusMask = -64;
    public static final int KeyHashMask = 63;
    public static final int NoMatchIndex = -1;
    public static final int LESS_THAN = -1;
    public static final int EQUAL_TO = 0;
    public static final int GREATER_THAN = 1;
    private static final int[] _hashTableCapacities = new int[]{5, 11, 21, 43, 85, 171, 341, 683, 1365, 2731, 5461, 10923, 21845, 43691, 87381, 174763, 349525, 699051, 0x155555, 0x2AAAAB, 0x555555, 0xAAAAAB, 0x1555555, 0x2AAAAAB, 0x5555555, 0xAAAAAAB, 0x15555555, 0x2AAAAAAB};
    private static final int[] _hashTableNBuckets = new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};

    private _NSCollectionPrimitives() {
    }

    public static final int log2(int num) {
        if (num < 0) {
            throw new IllegalArgumentException("num (" + num + ") cannot be less than 0");
        }
        if (num < 65536) {
            if (num < 256) {
                if (num < 16) {
                    if (num < 4) {
                        return num < 2 ? 0 : 1;
                    }
                    return num < 8 ? 2 : 3;
                }
                if (num < 64) {
                    return num < 32 ? 4 : 5;
                }
                return num < 128 ? 6 : 7;
            }
            if (num < 4096) {
                if (num < 1024) {
                    return num < 512 ? 8 : 9;
                }
                return num < 2048 ? 10 : 11;
            }
            if (num < 16384) {
                return num < 8192 ? 12 : 13;
            }
            return num < 32768 ? 14 : 15;
        }
        if (num < 0x1000000) {
            if (num < 0x100000) {
                if (num < 262144) {
                    return num < 131072 ? 16 : 17;
                }
                return num < 524288 ? 18 : 19;
            }
            if (num < 0x400000) {
                return num < 0x200000 ? 20 : 21;
            }
            return num < 0x800000 ? 22 : 23;
        }
        if (num < 0x10000000) {
            if (num < 0x4000000) {
                return num < 0x2000000 ? 24 : 25;
            }
            return num < 0x8000000 ? 26 : 27;
        }
        if (num < 0x40000000) {
            return num < 0x20000000 ? 28 : 29;
        }
        return num < Integer.MIN_VALUE ? 30 : 31;
    }

    public static final void copyIntoBuffer(byte[] buffer, int index, int value) {
        buffer[index++] = (byte)(value >> 24);
        buffer[index++] = (byte)(value >> 16 & 0xFF);
        buffer[index++] = (byte)(value >> 8 & 0xFF);
        buffer[index++] = (byte)(value & 0xFF);
    }

    public static final void copyIntoBuffer(byte[] buffer, int index, long value) {
        int v1 = (int)(value >> 32);
        int v2 = (int)(value & 0xFFFFFFFFL);
        _NSCollectionPrimitives.copyIntoBuffer(buffer, index, v1);
        _NSCollectionPrimitives.copyIntoBuffer(buffer, index + 4, v2);
    }

    public static final Object[] copyArray(Object[] array) {
        return _NSCollectionPrimitives.copyArray(array, array == null ? 0 : array.length);
    }

    public static final Object[] copyArray(Object[] array, int newSize) {
        int min;
        if (array == null) {
            return null;
        }
        Object[] newArray = new Object[newSize];
        int n = min = newSize < array.length ? newSize : array.length;
        if (0 < min) {
            System.arraycopy(array, 0, newArray, 0, min);
        }
        return newArray;
    }

    public static final byte[] copyArray(byte[] array) {
        return _NSCollectionPrimitives.copyArray(array, array == null ? 0 : array.length);
    }

    public static final byte[] copyArray(byte[] array, int newSize) {
        int min;
        if (array == null) {
            return null;
        }
        byte[] newArray = new byte[newSize];
        int n = min = newSize < array.length ? newSize : array.length;
        if (0 < min) {
            System.arraycopy(array, 0, newArray, 0, min);
        }
        return newArray;
    }

    public static final char[] copyArray(char[] array) {
        return _NSCollectionPrimitives.copyArray(array, array == null ? 0 : array.length);
    }

    public static final char[] copyArray(char[] array, int newSize) {
        int min;
        if (array == null) {
            return null;
        }
        char[] newArray = new char[newSize];
        int n = min = newSize < array.length ? newSize : array.length;
        if (0 < min) {
            System.arraycopy(array, 0, newArray, 0, min);
        }
        return newArray;
    }

    public static final short[] copyArray(short[] array) {
        return _NSCollectionPrimitives.copyArray(array, array == null ? 0 : array.length);
    }

    public static final short[] copyArray(short[] array, int newSize) {
        int min;
        if (array == null) {
            return null;
        }
        short[] newArray = new short[newSize];
        int n = min = newSize < array.length ? newSize : array.length;
        if (0 < min) {
            System.arraycopy(array, 0, newArray, 0, min);
        }
        return newArray;
    }

    public static final int[] copyArray(int[] array) {
        return _NSCollectionPrimitives.copyArray(array, array == null ? 0 : array.length);
    }

    public static final int[] copyArray(int[] array, int newSize) {
        int min;
        if (array == null) {
            return null;
        }
        int[] newArray = new int[newSize];
        int n = min = newSize < array.length ? newSize : array.length;
        if (0 < min) {
            System.arraycopy(array, 0, newArray, 0, min);
        }
        return newArray;
    }

    public static final long[] copyArray(long[] array) {
        return _NSCollectionPrimitives.copyArray(array, array == null ? 0 : array.length);
    }

    public static final long[] copyArray(long[] array, int newSize) {
        int min;
        if (null == array) {
            return null;
        }
        long[] newArray = new long[newSize];
        int n = min = newSize < array.length ? newSize : array.length;
        if (0 < min) {
            System.arraycopy(array, 0, newArray, 0, min);
        }
        return newArray;
    }

    public static final float[] copyArray(float[] array) {
        return _NSCollectionPrimitives.copyArray(array, array == null ? 0 : array.length);
    }

    public static final float[] copyArray(float[] array, int newSize) {
        int min;
        if (array == null) {
            return null;
        }
        float[] newArray = new float[newSize];
        int n = min = newSize < array.length ? newSize : array.length;
        if (0 < min) {
            System.arraycopy(array, 0, newArray, 0, min);
        }
        return newArray;
    }

    public static final double[] copyArray(double[] array) {
        return _NSCollectionPrimitives.copyArray(array, array == null ? 0 : array.length);
    }

    public static final double[] copyArray(double[] array, int newSize) {
        int min;
        if (array == null) {
            return null;
        }
        double[] newArray = new double[newSize];
        int n = min = newSize < array.length ? newSize : array.length;
        if (0 < min) {
            System.arraycopy(array, 0, newArray, 0, min);
        }
        return newArray;
    }

    private static final void _K2_sort_recur(Object[] a, int lo0, int hi0, NSComparator comparator) throws NSComparator.ComparisonException {
        int midL;
        if (hi0 < lo0 + 5) {
            return;
        }
        int lo = lo0;
        int hi = hi0;
        int midH = midL = (lo0 + hi0) / 2;
        Object midT = a[midL];
        while (true) {
            int C;
            Object T;
            if (lo < midL) {
                T = a[lo];
                C = comparator.compare(midT, T);
                if (C > 0) {
                    ++lo;
                    continue;
                }
                if (C == 0) {
                    if (lo >= --midL) continue;
                    a[lo] = a[midL];
                    a[midL] = T;
                    continue;
                }
            }
            while (midH < hi) {
                T = a[hi];
                C = comparator.compare(midT, T);
                if (C < 0) {
                    --hi;
                    continue;
                }
                if (C != 0) break;
                if (++midH >= hi) continue;
                a[hi] = a[midH];
                a[midH] = T;
            }
            if (lo < midL && midH < hi) {
                T = a[lo];
                a[lo++] = a[hi];
                a[hi--] = T;
                continue;
            }
            if (lo < midL) {
                T = a[lo];
                if (lo < --midL) {
                    a[lo] = a[midL];
                }
                a[midL] = a[midH];
                a[midH--] = T;
                continue;
            }
            if (midH >= hi) break;
            T = a[hi];
            if (++midH < hi) {
                a[hi] = a[midH];
            }
            a[midH] = a[midL];
            a[midL++] = T;
        }
        _NSCollectionPrimitives._K2_sort_recur(a, lo0, midL - 1, comparator);
        _NSCollectionPrimitives._K2_sort_recur(a, midH + 1, hi0, comparator);
    }

    public static final void K2SortArray(Object[] a, int length, NSComparator comparator) throws NSComparator.ComparisonException {
        _NSCollectionPrimitives._K2_sort_recur(a, 0, length - 1, comparator);
        for (int j = 1; j < length; ++j) {
            int i;
            Object T = a[j];
            for (i = j - 1; 0 <= i && comparator.compare(T, a[i]) <= -1; --i) {
            }
            switch (j - ++i) {
                default: {
                    throw new IllegalStateException("Internal Inconsistency in K2Sort");
                }
                case 5: {
                    a[i + 5] = a[i + 4];
                }
                case 4: {
                    a[i + 4] = a[i + 3];
                }
                case 3: {
                    a[i + 3] = a[i + 2];
                }
                case 2: {
                    a[i + 2] = a[i + 1];
                }
                case 1: {
                    a[i + 1] = a[i];
                    a[i] = T;
                }
                case 0: 
            }
        }
    }

    public static final int countObjectInArray(Object[] array, int firstIdx, int lastIdx, Object object, boolean identical) {
        if (null == array) {
            throw new IllegalArgumentException("array cannot be null");
        }
        if (firstIdx < 0) {
            throw new IllegalArgumentException("firstIdx (" + firstIdx + ") cannot be less than 0");
        }
        if (lastIdx < 0) {
            throw new IllegalArgumentException("lastIdx (" + lastIdx + ") cannot be less than 0");
        }
        if (lastIdx < firstIdx) {
            int tmp = lastIdx;
            lastIdx = firstIdx;
            firstIdx = tmp;
        }
        int cnt = 0;
        for (int idx = firstIdx; idx <= lastIdx; ++idx) {
            Object obj = array[idx];
            if ((!identical || obj != object) && (identical || !object.equals(obj))) continue;
            ++cnt;
        }
        return cnt;
    }

    public static final boolean containsObjectInArray(Object[] array, int firstIdx, int lastIdx, Object object, boolean identical) {
        if (null == array) {
            throw new IllegalArgumentException("array cannot be null");
        }
        if (firstIdx < 0) {
            throw new IllegalArgumentException("firstIdx (" + firstIdx + ") cannot be less than 0");
        }
        if (lastIdx < 0) {
            throw new IllegalArgumentException("lastIdx (" + lastIdx + ") cannot be less than 0");
        }
        if (lastIdx < firstIdx) {
            int tmp = lastIdx;
            lastIdx = firstIdx;
            firstIdx = tmp;
        }
        for (int idx = firstIdx; idx <= lastIdx; ++idx) {
            Object obj = array[idx];
            if ((!identical || obj != object) && (identical || !object.equals(obj))) continue;
            return true;
        }
        return false;
    }

    public static final int findObjectInArray(Object[] array, int firstIdx, int lastIdx, Object object, boolean identical) {
        if (null == array) {
            throw new IllegalArgumentException("array cannot be null");
        }
        if (firstIdx < 0) {
            throw new IllegalArgumentException("firstIdx (" + firstIdx + ") cannot be less than 0");
        }
        if (lastIdx < 0) {
            throw new IllegalArgumentException("lastIdx (" + lastIdx + ") cannot be less than 0");
        }
        if (lastIdx < firstIdx) {
            for (int idx = firstIdx; lastIdx <= idx; --idx) {
                Object obj = array[idx];
                if ((!identical || obj != object) && (identical || !object.equals(obj))) continue;
                return idx;
            }
        } else {
            for (int idx = firstIdx; idx <= lastIdx; ++idx) {
                Object obj = array[idx];
                if ((!identical || obj != object) && (identical || !object.equals(obj))) continue;
                return idx;
            }
        }
        return -1;
    }

    public static final void replaceObjectInArray(Object[] array, int firstIdx, int lastIdx, Object existing, Object object, boolean identical, boolean allOccurrences) {
        if (null == array) {
            throw new IllegalArgumentException("array cannot be null");
        }
        if (firstIdx < 0) {
            throw new IllegalArgumentException("firstIdx (" + firstIdx + ") cannot be less than 0");
        }
        if (lastIdx < 0) {
            throw new IllegalArgumentException("lastIdx (" + lastIdx + ") cannot be less than 0");
        }
        if (allOccurrences) {
            if (lastIdx < firstIdx) {
                int tmp = lastIdx;
                lastIdx = firstIdx;
                firstIdx = tmp;
            }
            for (int idx = firstIdx; idx <= lastIdx; ++idx) {
                Object obj = array[idx];
                if ((!identical || obj != existing) && (identical || !existing.equals(obj))) continue;
                array[idx] = object;
            }
        } else if (lastIdx < firstIdx) {
            for (int idx = firstIdx; lastIdx <= idx; --idx) {
                Object obj = array[idx];
                if ((!identical || obj != existing) && (identical || !existing.equals(obj))) continue;
                array[idx] = object;
                return;
            }
        } else {
            for (int idx = firstIdx; idx <= lastIdx; ++idx) {
                Object obj = array[idx];
                if ((!identical || obj != existing) && (identical || !existing.equals(obj))) continue;
                array[idx] = object;
                return;
            }
        }
    }

    public static final int removeObjectInArray(Object[] array, int firstIdx, int lastIdx, int count, Object existing, boolean identical, boolean allOccurrences) {
        if (null == array) {
            throw new IllegalArgumentException("array cannot be null");
        }
        if (firstIdx < 0) {
            throw new IllegalArgumentException("firstIdx (" + firstIdx + ") cannot be less than 0");
        }
        if (lastIdx < 0) {
            throw new IllegalArgumentException("lastIdx (" + lastIdx + ") cannot be less than 0");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count (" + count + ") cannot be less than 0");
        }
        if (count <= firstIdx) {
            throw new IllegalArgumentException("firstIdx (" + firstIdx + ") cannot be greater than or equal to count (" + count + ")");
        }
        if (count <= lastIdx) {
            throw new IllegalArgumentException("lastIdx (" + lastIdx + ") cannot be greater than or equal to count (" + count + ")");
        }
        int numRemoved = 0;
        if (allOccurrences) {
            if (lastIdx < firstIdx) {
                int tmp = lastIdx;
                lastIdx = firstIdx;
                firstIdx = tmp;
            }
            for (int idx = lastIdx; firstIdx <= idx; --idx) {
                Object obj = array[idx];
                if ((!identical || obj != existing) && (identical || !existing.equals(obj))) continue;
                if (idx < --count) {
                    System.arraycopy(array, idx + 1, array, idx, count - idx);
                }
                array[count] = null;
                ++numRemoved;
            }
        } else if (lastIdx < firstIdx) {
            for (int idx = firstIdx; lastIdx <= idx; --idx) {
                Object obj = array[idx];
                if ((!identical || obj != existing) && (identical || !existing.equals(obj))) continue;
                if (idx < --count) {
                    System.arraycopy(array, idx + 1, array, idx, count - idx);
                }
                array[count] = null;
                ++numRemoved;
                break;
            }
        } else {
            for (int idx = firstIdx; idx <= lastIdx; ++idx) {
                Object obj = array[idx];
                if ((!identical || obj != existing) && (identical || !existing.equals(obj))) continue;
                if (idx < --count) {
                    System.arraycopy(array, idx + 1, array, idx, count - idx);
                }
                array[count] = null;
                ++numRemoved;
                break;
            }
        }
        return numRemoved;
    }

    public static final int deletionLimitForTableBuckets(int hashTableBuckets) {
        if (hashTableBuckets <= 512) {
            return hashTableBuckets;
        }
        return hashTableBuckets >> 1;
    }

    public static final int hashTableBucketsForCapacity(int capacity) {
        int i;
        int n = _hashTableCapacities.length;
        if (capacity == 0) {
            return 0;
        }
        for (i = 0; i < n && _hashTableCapacities[i] < capacity; ++i) {
        }
        return _hashTableNBuckets[i];
    }

    public static final int hashTableCapacityForCapacity(int capacity) {
        int i;
        int n = _hashTableCapacities.length;
        if (capacity == 0) {
            return 0;
        }
        for (i = 0; i < n && _hashTableCapacities[i] < capacity; ++i) {
        }
        return _hashTableCapacities[i];
    }

    public static final Object[] keysInHashTable(Object[] keyArray, Object[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        Object[] array = new Object[capacity];
        int cnt = 0;
        for (int idx = 0; idx < hashtableBuckets; ++idx) {
            if ((flagsArray[idx] & 0xFFFFFFC0) != -128) continue;
            array[cnt++] = keyArray[idx];
        }
        return _NSCollectionPrimitives.copyArray(array, cnt);
    }

    public static final Object[] valuesInHashTable(Object[] keyArray, Object[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        Object[] array = new Object[capacity];
        int cnt = 0;
        for (int idx = 0; idx < hashtableBuckets; ++idx) {
            if ((flagsArray[idx] & 0xFFFFFFC0) != -128) continue;
            array[cnt++] = valueArray[idx];
        }
        return _NSCollectionPrimitives.copyArray(array, cnt);
    }

    public static final Object findValueInHashTable(Object key, Object[] keyArray, Object[] valueArray, byte[] flagsArray) {
        int mask = keyArray.length - 1;
        int keyhash = key.hashCode();
        int probe = keyhash & mask;
        int keyhashmasked = keyhash & 0x3F;
        int start = keyhash >>> 1;
        int probeskip = (start & mask) - 1 + (start & 1);
        start = probe;
        do {
            byte curFlags;
            int currentStatus;
            if ((currentStatus = (curFlags = flagsArray[probe]) & 0xFFFFFFC0) == -128) {
                Object curKey = keyArray[probe];
                if (key != curKey && ((curFlags & 0x3F) != keyhashmasked || !key.equals(curKey))) continue;
                return valueArray[probe];
            }
            if (currentStatus != 0) continue;
            return null;
        } while ((probe = probe + probeskip & mask) != start);
        return null;
    }

    public static final boolean addValueInHashTable(Object key, Object value, Object[] keyArray, Object[] valueArray, byte[] flagsArray) {
        Object curKey = null;
        boolean didInsert = true;
        int mask = keyArray.length - 1;
        int keyhash = key.hashCode();
        int probe = keyhash & mask;
        int keyhashmasked = keyhash & 0x3F;
        int start = keyhash >>> 1;
        int probeskip = (start & mask) - 1 + (start & 1);
        start = probe;
        int destination = -1;
        do {
            byte curFlags;
            int currentStatus;
            if ((currentStatus = (curFlags = flagsArray[probe]) & 0xFFFFFFC0) == 0) {
                if (destination != -1) break;
                destination = probe;
                break;
            }
            if (currentStatus == -128) {
                curKey = keyArray[probe];
                if (key != curKey && ((curFlags & 0x3F) != keyhashmasked || !key.equals(curKey))) continue;
                destination = probe;
                didInsert = false;
                break;
            }
            if (destination != -1) continue;
            destination = probe;
        } while (start != (probe = probe + probeskip & mask));
        if (didInsert) {
            flagsArray[destination] = (byte)(0xFFFFFF80 | keyhashmasked);
            keyArray[destination] = key;
            valueArray[destination] = value;
        } else {
            if (key != curKey) {
                keyArray[destination] = key;
            }
            if (valueArray[destination] != value) {
                valueArray[destination] = value;
            }
        }
        return didInsert;
    }

    public static final boolean addValueToSet(Object key, Object[] keyArray, byte[] flagsArray) {
        int mask = keyArray.length - 1;
        int keyhash = key.hashCode();
        int probe = keyhash & mask;
        int keyhashmasked = keyhash & 0x3F;
        int start = keyhash >>> 1;
        int probeskip = (start & mask) - 1 + (start & 1);
        start = probe;
        int destination = -1;
        do {
            byte curFlags;
            int currentStatus;
            if ((currentStatus = (curFlags = flagsArray[probe]) & 0xFFFFFFC0) == 0) {
                if (destination != -1) break;
                destination = probe;
                break;
            }
            if (currentStatus == -128) {
                Object curKey = keyArray[probe];
                if (key != curKey && ((curFlags & 0x3F) != keyhashmasked || !key.equals(curKey))) continue;
                return false;
            }
            if (destination != -1) continue;
            destination = probe;
        } while (start != (probe = probe + probeskip & mask));
        flagsArray[destination] = (byte)(0xFFFFFF80 | keyhashmasked);
        keyArray[destination] = key;
        return true;
    }

    public static final Object removeValueInHashTable(Object key, Object[] keyArray, Object[] valueArray, byte[] flagsArray) {
        int mask = keyArray.length - 1;
        int keyhash = key.hashCode();
        int probe = keyhash & mask;
        int keyhashmasked = keyhash & 0x3F;
        int start = keyhash >>> 1;
        int probeskip = (start & mask) - 1 + (start & 1);
        start = probe;
        do {
            Object curKey;
            byte curFlags;
            int currentStatus;
            if ((currentStatus = (curFlags = flagsArray[probe]) & 0xFFFFFFC0) == 0) {
                return null;
            }
            if (currentStatus != -128 || key != (curKey = keyArray[probe]) && ((curFlags & 0x3F) != keyhashmasked || !key.equals(curKey))) continue;
            Object temp = valueArray[probe];
            keyArray[probe] = null;
            valueArray[probe] = null;
            flagsArray[probe] = 64;
            return temp;
        } while (start != (probe = probe + probeskip & mask));
        return null;
    }

    public static final int[] keysInHashTable(int[] keyArray, Object[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        int[] array = new int[capacity];
        int cnt = 0;
        for (int idx = 0; idx < hashtableBuckets; ++idx) {
            if ((flagsArray[idx] & 0xFFFFFFC0) != -128) continue;
            array[cnt++] = keyArray[idx];
        }
        return _NSCollectionPrimitives.copyArray(array, cnt);
    }

    public static final Object[] valuesInHashTable(int[] keyArray, Object[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        Object[] array = new Object[capacity];
        int cnt = 0;
        for (int idx = 0; idx < hashtableBuckets; ++idx) {
            if ((flagsArray[idx] & 0xFFFFFFC0) != -128) continue;
            array[cnt++] = valueArray[idx];
        }
        return _NSCollectionPrimitives.copyArray(array, cnt);
    }

    public static final Object findValueInHashTable(int key, int[] keyArray, Object[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        int mask = hashtableBuckets - 1;
        int keyhash = key;
        int probe = keyhash & mask;
        int probeskip = (keyhash >>> 1 & mask) - 1 + (keyhash >>> 1 & 1);
        int start = probe;
        do {
            byte curFlags = flagsArray[probe];
            int currentStatus = curFlags & 0xFFFFFFC0;
            switch (currentStatus) {
                case 0: {
                    return null;
                }
                case -128: {
                    int curKey = keyArray[probe];
                    if (key != curKey) break;
                    return valueArray[probe];
                }
            }
        } while (start != (probe = probe + probeskip & mask));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean addValueInHashTable(int key, Object value, int[] keyArray, Object[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        int curKey = 0;
        boolean didInsert = true;
        int mask = hashtableBuckets - 1;
        int keyhash = key;
        int probe = keyhash & mask;
        int probeskip = (keyhash >>> 1 & mask) - 1 + (keyhash >>> 1 & 1);
        int start = probe;
        int nomatch = -1;
        block5: do {
            byte curFlags = flagsArray[probe];
            int currentStatus = curFlags & 0xFFFFFFC0;
            switch (currentStatus) {
                case 0: {
                    if (nomatch != -1) break block5;
                    nomatch = probe;
                    break block5;
                }
                case 64: {
                    if (nomatch != -1) break;
                    nomatch = probe;
                    break;
                }
                case -128: {
                    curKey = keyArray[probe];
                    if (key != curKey) break;
                    nomatch = probe;
                    didInsert = false;
                    break block5;
                }
            }
        } while (start != (probe = probe + probeskip & mask));
        if (didInsert) {
            flagsArray[nomatch] = (byte)(0xFFFFFF80 | keyhash & 0x3F);
            keyArray[nomatch] = key;
            valueArray[nomatch] = value;
            return didInsert;
        }
        if (key != curKey) {
            keyArray[nomatch] = key;
        }
        if (valueArray[nomatch] == value) return didInsert;
        valueArray[nomatch] = value;
        return didInsert;
    }

    public static final Object removeValueInHashTable(int key, int[] keyArray, Object[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        int mask = hashtableBuckets - 1;
        int keyhash = key;
        int probe = keyhash & mask;
        int probeskip = (keyhash >>> 1 & mask) - 1 + (keyhash >>> 1 & 1);
        int start = probe;
        do {
            byte curFlags = flagsArray[probe];
            int currentStatus = curFlags & 0xFFFFFFC0;
            switch (currentStatus) {
                case 0: {
                    return null;
                }
                case 64: {
                    break;
                }
                case -128: {
                    int curKey = keyArray[probe];
                    if (key != curKey) break;
                    Object temp = valueArray[probe];
                    valueArray[probe] = null;
                    flagsArray[probe] = 64;
                    return temp;
                }
            }
        } while (start != (probe = probe + probeskip & mask));
        return null;
    }

    public static final Object[] keysInHashTable(Object[] keyArray, int[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        Object[] array = new Object[capacity];
        int cnt = 0;
        for (int idx = 0; idx < hashtableBuckets; ++idx) {
            if ((flagsArray[idx] & 0xFFFFFFC0) != -128) continue;
            array[cnt++] = keyArray[idx];
        }
        return _NSCollectionPrimitives.copyArray(array, cnt);
    }

    public static final int[] valuesInHashTable(Object[] keyArray, int[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        int[] array = new int[capacity];
        int cnt = 0;
        for (int idx = 0; idx < hashtableBuckets; ++idx) {
            if ((flagsArray[idx] & 0xFFFFFFC0) != -128) continue;
            array[cnt++] = valueArray[idx];
        }
        return _NSCollectionPrimitives.copyArray(array, cnt);
    }

    public static final int findValueInHashTable(Object key, Object[] keyArray, int[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        int mask = hashtableBuckets - 1;
        int keyhash = key.hashCode();
        int probe = keyhash & mask;
        int probeskip = (keyhash >>> 1 & mask) - 1 + (keyhash >>> 1 & 1);
        int start = probe;
        block4: do {
            byte curFlags = flagsArray[probe];
            int currentStatus = curFlags & 0xFFFFFFC0;
            switch (currentStatus) {
                case 0: {
                    return Integer.MIN_VALUE;
                }
                case -128: {
                    Object curKey = keyArray[probe];
                    if (key != curKey && ((curFlags & 0x3F) != (keyhash & 0x3F) || !key.equals(curKey))) continue block4;
                    return valueArray[probe];
                }
            }
        } while (start != (probe = probe + probeskip & mask));
        return Integer.MIN_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean addValueInHashTable(Object key, int value, Object[] keyArray, int[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        Object curKey = null;
        boolean didInsert = true;
        int mask = hashtableBuckets - 1;
        int keyhash = key.hashCode();
        int probe = keyhash & mask;
        int keyhashmasked = keyhash & 0x3F;
        int probeskip = (keyhash >>> 1 & mask) - 1 + (keyhash >>> 1 & 1);
        int start = probe;
        int nomatch = -1;
        block5: do {
            byte curFlags = flagsArray[probe];
            int currentStatus = curFlags & 0xFFFFFFC0;
            switch (currentStatus) {
                case 0: {
                    if (nomatch != -1) break block5;
                    nomatch = probe;
                    break block5;
                }
                case 64: {
                    if (nomatch != -1) break;
                    nomatch = probe;
                    break;
                }
                case -128: {
                    curKey = keyArray[probe];
                    if (key != curKey && ((curFlags & 0x3F) != keyhashmasked || !key.equals(curKey))) break;
                    nomatch = probe;
                    didInsert = false;
                    break block5;
                }
            }
        } while (start != (probe = probe + probeskip & mask));
        if (didInsert) {
            flagsArray[nomatch] = (byte)(0xFFFFFF80 | keyhashmasked);
            keyArray[nomatch] = key;
            valueArray[nomatch] = value;
            return didInsert;
        }
        if (key != curKey) {
            keyArray[nomatch] = key;
        }
        if (valueArray[nomatch] == value) return didInsert;
        valueArray[nomatch] = value;
        return didInsert;
    }

    public static final int removeValueInHashTable(Object key, Object[] keyArray, int[] valueArray, byte[] flagsArray, int capacity, int hashtableBuckets) {
        int mask = hashtableBuckets - 1;
        int keyhash = key.hashCode();
        int probe = keyhash & mask;
        int probeskip = (keyhash >>> 1 & mask) - 1 + (keyhash >>> 1 & 1);
        int start = probe;
        block5: do {
            byte curFlags = flagsArray[probe];
            int currentStatus = curFlags & 0xFFFFFFC0;
            switch (currentStatus) {
                case 0: {
                    return Integer.MIN_VALUE;
                }
                case 64: {
                    break;
                }
                case -128: {
                    Object curKey = keyArray[probe];
                    if (key != curKey && ((curFlags & 0x3F) != (keyhash & 0x3F) || !key.equals(curKey))) continue block5;
                    keyArray[probe] = null;
                    flagsArray[probe] = 64;
                    return valueArray[probe];
                }
            }
        } while (start != (probe = probe + probeskip & mask));
        return Integer.MIN_VALUE;
    }
}

