/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol._private;

import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.eocontrol._private.ASCII_UCodeESC_CharStream;
import com.webobjects.eocontrol._private.ParseException;
import com.webobjects.eocontrol._private.Token;
import com.webobjects.eocontrol._private._EOQualifierParserConstants;
import com.webobjects.eocontrol._private._EOQualifierParserTokenManager;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Vector;

public class _EOQualifierParser
implements _EOQualifierParserConstants {
    public static final int NO_TOKEN = 0;
    public static final int AND_TOKEN = 1;
    public static final int OR_TOKEN = 2;
    protected NSArray arguments;
    protected int argIndex;
    protected int argCount;
    private static final BigDecimal MIN_INTEGER = BigDecimal.valueOf(-2147483649L);
    private static final BigDecimal MAX_INTEGER = BigDecimal.valueOf(0x80000001L);
    private static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_DOUBLE = new BigDecimal(Double.MIN_VALUE);
    private static final BigDecimal MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal MIN_FLOAT = new BigDecimal(1.4E-45f);
    private static final BigDecimal MAX_FLOAT = new BigDecimal(3.4028234663852886E38);
    private static final String defaultStringTimestampFormat = "%Y-%m-%d %H:%M:%S %Z";
    private static final NSTimestampFormatter defaultStringTimestampFormatter = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S %Z");
    public _EOQualifierParserTokenManager token_source;
    ASCII_UCodeESC_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[11];
    private final int[] jj_la1_0 = new int[]{0x180000, 35001408, 0, 35001408, 0x180000, 49152, 35192832, 35525696, 1088, 1088, 49152};
    private final int[] jj_la1_1 = new int[]{0, 2, 2044, 2, 2044, 0, 0, 2, 0, 0, 0};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    private static Number _makeIntoCorrectNumberClass(Object value, Class targetClass) {
        Number result = null;
        if (value instanceof Number) {
            result = (Number)value;
        } else if (value instanceof String) {
            try {
                result = new BigDecimal((String)value);
            }
            catch (Throwable t) {
                NSLog._conditionallyLogPrivateException((Throwable)t);
                return null;
            }
        } else if (value instanceof Boolean) {
            result = (Boolean)value == false ? _NSUtilities.IntegerForInt((int)0) : _NSUtilities.IntegerForInt((int)1);
        }
        return _NSUtilities.convertNumberIntoCompatibleValue((Number)result, (Class)targetClass);
    }

    private static Boolean _makeIntoBooleanClass(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return _NSUtilities.convertNumberIntoBooleanValue((Number)((Number)value));
        }
        if (value instanceof String) {
            String temp = (String)value;
            if (temp.equalsIgnoreCase("true") || temp.equalsIgnoreCase("yes") || temp.equals("1")) {
                return Boolean.TRUE;
            }
            if (temp.equalsIgnoreCase("false") || temp.equalsIgnoreCase("no") || temp.equals("0")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static NSTimestamp _makeIntoTimestampClass(Object value) {
        if (value instanceof NSTimestamp) {
            return (NSTimestamp)value;
        }
        if (value instanceof Date) {
            return new NSTimestamp(((Date)value).getTime());
        }
        if (value instanceof Number) {
            return new NSTimestamp(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                return (NSTimestamp)defaultStringTimestampFormatter.parseObject((String)value);
            }
            catch (Throwable t) {
                NSLog._conditionallyLogPrivateException((Throwable)t);
            }
        }
        return null;
    }

    public void setArguments(NSArray args) {
        this.arguments = args;
        this.argCount = args != null ? args.count() : -1;
        this.argIndex = 0;
    }

    public void _checkAvailableArgumentIndex(int argIndex) throws ParseException {
        if (this.arguments == null || argIndex >= this.argCount) {
            throw new ParseException("Unable to get the argument value at index " + argIndex + " in arguments array " + this.arguments);
        }
    }

    Object parseArgumentPath(String text) throws ParseException {
        if ((text = text.trim()).length() == 2 && text.charAt(0) == '%') {
            return this.subParseArgument(text.charAt(1));
        }
        char[] source = text.toCharArray();
        int c = source.length;
        StringBuffer buffer = new StringBuffer(32);
        boolean allPartsAreKeys = true;
        for (int i = 0; i < c; ++i) {
            char current = source[i];
            if (current != '%') {
                buffer.append(current);
                continue;
            }
            if (i != c - 1) {
                Object parsedParameter;
                if (!((parsedParameter = this.subParseArgument(source[++i])) instanceof KeyString)) {
                    allPartsAreKeys = false;
                }
                buffer.append(parsedParameter);
                continue;
            }
            throw new ParseException("The argument path \"" + text + "\" ends with an incomplete conversion specifier.");
        }
        String result = new String(buffer);
        return allPartsAreKeys ? new KeyString(result) : result;
    }

    Object subParseArgument(char conversionSpecifier) throws ParseException {
        char ch = conversionSpecifier;
        if (ch == '%') {
            return "%";
        }
        this._checkAvailableArgumentIndex(this.argIndex);
        Object arg = this.arguments.objectAtIndex(this.argIndex);
        ++this.argIndex;
        switch (ch) {
            case '@': {
                if (arg == NSKeyValueCoding.NullValue) {
                    return NSKeyValueCoding.NullValue;
                }
                return arg;
            }
            case 'f': {
                if (arg instanceof Number) {
                    return new Double(((Number)arg).doubleValue());
                }
                return new Double(arg.toString());
            }
            case 'd': {
                if (arg instanceof Number) {
                    return new Integer(((Number)arg).intValue());
                }
                return new Integer(arg.toString());
            }
            case 'A': 
            case 'K': {
                return new KeyString(arg.toString());
            }
            case 's': {
                return arg.toString();
            }
        }
        throw new ParseException("%" + ch + " is an illegal conversion specification.");
    }

    BigDecimal parseNumericText(String text) {
        return new BigDecimal(text);
    }

    Number narrowIntegerNumber(BigDecimal value) {
        if (value.compareTo(MAX_INTEGER) == -1 && value.compareTo(MIN_INTEGER) == 1) {
            return new Integer(value.intValue());
        }
        if (value.compareTo(MAX_LONG) == -1 && value.compareTo(MIN_LONG) == 1) {
            return new Long(value.longValue());
        }
        return value;
    }

    Number narrowFloatingPointNumber(BigDecimal value) {
        if (value.compareTo(MAX_FLOAT) == -1 && value.compareTo(MIN_FLOAT) == 1) {
            return new Float(value.floatValue());
        }
        if (value.compareTo(MAX_DOUBLE) == -1 && value.compareTo(MIN_DOUBLE) == 1) {
            return new Double(value.doubleValue());
        }
        return value;
    }

    int countNumericEscapeSequence(char[] source, int position, int maxNumericDigits) {
        boolean allowHexDigits = maxNumericDigits != 3;
        int c = source.length;
        int result = 0;
        if (position < c) {
            int remainder = c - position;
            maxNumericDigits = remainder > maxNumericDigits ? maxNumericDigits : remainder;
            block4: for (int i = 0; i < maxNumericDigits; ++i) {
                char current = source[i + position];
                switch (current) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        ++result;
                        continue block4;
                    }
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (!allowHexDigits) {
                            return result;
                        }
                        ++result;
                        continue block4;
                    }
                    default: {
                        return result;
                    }
                }
            }
        }
        return result;
    }

    String replaceEscapeSequencesWithRealChars(String escapedText) throws ParseException {
        if (escapedText.indexOf(92) < 0) {
            return escapedText;
        }
        char[] escapedChars = escapedText.toCharArray();
        int c = escapedChars.length;
        char[] realChars = new char[c];
        int j = 0;
        for (int i = 0; i < c; ++i) {
            int current = escapedChars[i];
            if (current != 92) {
                realChars[j++] = current;
                continue;
            }
            if (++i >= c) {
                throw new ParseException("An escape sequence began, but insufficient characters remaining in the text \"" + escapedText + "\".");
            }
            current = escapedChars[i];
            int seqLen = 1;
            int maxDigits = 0;
            switch (current) {
                case 110: {
                    current = 10;
                    break;
                }
                case 116: {
                    current = 9;
                    break;
                }
                case 98: {
                    current = 8;
                    break;
                }
                case 114: {
                    current = 13;
                    break;
                }
                case 97: {
                    current = 7;
                    break;
                }
                case 118: {
                    current = 11;
                    break;
                }
                case 102: {
                    current = 12;
                    break;
                }
                case 85: 
                case 117: {
                    maxDigits += 2;
                }
                case 88: 
                case 120: {
                    seqLen = this.countNumericEscapeSequence(escapedChars, ++i, maxDigits += 2);
                    if (seqLen < 1) {
                        throw new ParseException("A numeric escape sequence began, but with insufficient hex digits remaining in the text \"" + escapedText + "\".");
                    }
                    current = (char)Integer.parseInt(new String(escapedChars, i, seqLen), 16);
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    seqLen = this.countNumericEscapeSequence(escapedChars, i, 3);
                    if (seqLen < 1) {
                        throw new ParseException("A numeric escape sequence began, but with insufficient octal digits remaining in the text \"" + escapedText + "\".");
                    }
                    current = (char)Integer.parseInt(new String(escapedChars, i, seqLen), 8);
                }
            }
            realChars[j++] = current;
            i += seqLen - 1;
        }
        return new String(realChars, 0, j);
    }

    public final Object parseIdentifier() throws ParseException {
        Token t = this.jj_consume_token(19);
        return new KeyString(t.image);
    }

    public final Object parseKeyOrAnyArgument() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                Token t = this.jj_consume_token(19);
                return t.image;
            }
            case 20: {
                Object result = this.parseArgument();
                return result;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object parseValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                EOQualifierVariable value = this.parseVariable();
                return value;
            }
            case 12: {
                String value = this.parseQuotedString();
                return value;
            }
            case 6: 
            case 10: {
                Number value = this.parseMyNumber();
                return value;
            }
            case 33: {
                this.jj_consume_token(33);
                Number value = this.parseNegNumber();
                return value;
            }
            case 20: {
                Object value = this.parseArgument();
                return value;
            }
            case 17: {
                NSKeyValueCoding.Null value = this.parseNil();
                return value;
            }
            case 25: {
                Object value = this.CastedValueExpression();
                return value;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object parseOperator() throws ParseException {
        String selectorString;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                selectorString = "=";
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                selectorString = ">=";
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                selectorString = "<=";
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                selectorString = "<=";
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                selectorString = "<>";
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                selectorString = "<>";
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                selectorString = ">=";
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                selectorString = ">";
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                selectorString = "<";
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return selectorString;
    }

    public final Object parseValueList() throws ParseException {
        NSMutableArray contents = null;
        boolean allAreKeys = true;
        Object firstExpression = this.parseValue();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 10: 
                case 12: 
                case 17: 
                case 18: 
                case 20: 
                case 25: 
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            Object remainder = this.parseValue();
            if (contents == null) {
                contents = new NSMutableArray(4);
            }
            contents.addObject(remainder);
        }
        if (contents == null) {
            return firstExpression;
        }
        if (firstExpression instanceof KeyString) {
            int c = contents.count();
            for (int i = 0; i < c; ++i) {
                if (contents.objectAtIndex(i) instanceof KeyString) continue;
                allAreKeys = false;
                break;
            }
        } else {
            allAreKeys = false;
        }
        String result = _NSStringUtilities.concat((String)firstExpression.toString(), (String)contents.componentsJoinedByString(""));
        return allAreKeys ? new KeyString(result) : result;
    }

    public final Object parseOperatorList() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                Object result = this.parseOperator();
                return result;
            }
            case 19: 
            case 20: {
                Object result = this.parseKeyOrAnyArgument();
                return result;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int parseLogicalOp() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                return 1;
            }
            case 15: {
                this.jj_consume_token(15);
                return 2;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final EOQualifier Expression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 20: {
                EOQualifier qualifier = this.RelOpExpression();
                return qualifier;
            }
            case 25: {
                EOQualifier qualifier = this.ParenExpression();
                return qualifier;
            }
            case 16: {
                EOQualifier qualifier = this.NotExpression();
                return qualifier;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final EOQualifier ParenExpression() throws ParseException {
        EOQualifier qual = null;
        this.jj_consume_token(25);
        qual = this.parseLogicalExpression();
        this.jj_consume_token(26);
        return qual;
    }

    public final EOQualifier NotExpression() throws ParseException {
        EOQualifier qual = null;
        this.jj_consume_token(16);
        qual = this.Expression();
        return new EONotQualifier(qual);
    }

    public final EOQualifier RelOpExpression() throws ParseException {
        NSSelector actualSelector;
        Object qual = null;
        Object value = null;
        Object rKey = null;
        Object valueKey = this.parseKeyOrAnyArgument();
        Object selector = this.parseOperatorList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                value = this.parseIdentifier();
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 25: 
            case 33: {
                value = this.parseValueList();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        NSSelector nSSelector = actualSelector = selector instanceof NSSelector ? (NSSelector)selector : EOQualifier.operatorSelectorForString(selector.toString());
        if (!(value instanceof KeyString)) {
            return new EOKeyValueQualifier(valueKey.toString(), actualSelector, value);
        }
        return new EOKeyComparisonQualifier(valueKey.toString(), actualSelector, value.toString());
    }

    public final EOQualifierVariable parseVariable() throws ParseException {
        Token t = this.jj_consume_token(18);
        return new EOQualifierVariable(t.image.substring(1));
    }

    public final String parseQuotedString() throws ParseException {
        Token t = this.jj_consume_token(12);
        String result = t.image.substring(1, t.image.length() - 1);
        if (result != null && result.length() > 0) {
            result = this.replaceEscapeSequencesWithRealChars(result);
        }
        return result;
    }

    public final Number parseMyNumber() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                Token t = this.jj_consume_token(6);
                return this.narrowIntegerNumber(this.parseNumericText(t.image));
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                return this.narrowFloatingPointNumber(this.parseNumericText(t.image));
            }
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Number parseNegNumber() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                Token t = this.jj_consume_token(6);
                return this.narrowIntegerNumber(this.parseNumericText(t.image).negate());
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                return this.narrowFloatingPointNumber(this.parseNumericText(t.image).negate());
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NSKeyValueCoding.Null parseNil() throws ParseException {
        this.jj_consume_token(17);
        return NSKeyValueCoding.NullValue;
    }

    public final Object CastedValueExpression() throws ParseException {
        Constructor<?>[] constructors;
        Object newValue = null;
        this.jj_consume_token(25);
        Token t = this.jj_consume_token(19);
        this.jj_consume_token(26);
        Object value = this.parseValue();
        if (value == null || value == NSKeyValueCoding.NullValue) {
            return NSKeyValueCoding.NullValue;
        }
        Constructor<?> targetConstructor = null;
        Constructor<?> defaultConstructor = null;
        boolean isValueNumber = value instanceof Number;
        Class aClass = _NSUtilities.classWithName((String)t.image);
        if (aClass == null) {
            throw new ParseException("Class " + t.image + " not found in Java Runtime. Please verify your CLASSPATH.");
        }
        if (aClass.isInstance(value)) {
            return value;
        }
        if (aClass == _NSUtilities._ObjectClass) {
            return value;
        }
        if (aClass == _NSUtilities._StringClass) {
            return value.toString();
        }
        if (_NSUtilities._NumberClass.isAssignableFrom(aClass)) {
            newValue = _EOQualifierParser._makeIntoCorrectNumberClass(value, aClass);
            if (newValue != null) {
                return newValue;
            }
        } else if (aClass == _NSUtilities._BooleanClass) {
            newValue = _EOQualifierParser._makeIntoBooleanClass(value);
            if (newValue != null) {
                return newValue;
            }
        } else if (_NSUtilities._DateClass.isAssignableFrom(aClass)) {
            newValue = _EOQualifierParser._makeIntoTimestampClass(value);
            if (newValue != null) {
                return newValue;
            }
        } else if (aClass == _NSUtilities._CharacterClass) {
            if (value instanceof Number) {
                return new Character((char)((Number)value).intValue());
            }
            String tempStr = value.toString();
            if (tempStr.length() == 1) {
                return new Character(tempStr.charAt(0));
            }
        }
        try {
            constructors = aClass.getConstructors();
        }
        catch (SecurityException ex) {
            constructors = null;
        }
        int c = constructors.length;
        if (constructors != null && c > 0) {
            Class[] args;
            int i;
            Class[] classForConstructor = new Class[c];
            Class<?> valueClass = value.getClass();
            for (i = 0; i < c; ++i) {
                Constructor<?> current = constructors[i];
                args = current.getParameterTypes();
                if (args.length != 1) {
                    constructors[i--] = constructors[--c];
                    continue;
                }
                classForConstructor[i] = args[0];
                if (args[0] != _NSUtilities._StringClass) continue;
                defaultConstructor = current;
            }
            for (i = 0; i < c; ++i) {
                if (!classForConstructor[i].isInstance(value)) continue;
                targetConstructor = constructors[i];
                break;
            }
            if (targetConstructor == null) {
                targetConstructor = defaultConstructor;
                if (defaultConstructor != null) {
                    newValue = value.toString();
                }
            } else {
                newValue = value;
            }
            if (targetConstructor != null) {
                args = new Class[]{newValue.getClass()};
                Object[] objects = new Object[]{newValue};
                return _NSUtilities.instantiateObject((Class)aClass, (Class[])args, (Object[])objects, (boolean)true, (boolean)false);
            }
        }
        throw new ParseException("Class " + t.image + " does not have a public constructor taking either a single string or a " + value.getClass().getName() + " as an argument.");
    }

    public final Object parseArgument() throws ParseException {
        Token t = this.jj_consume_token(20);
        return this.parseArgumentPath(t.image);
    }

    public final EOQualifier Qualifier() throws ParseException {
        EOQualifier qual = this.parseLogicalExpression();
        return qual;
    }

    public final EOQualifier parseLogicalExpression() throws ParseException {
        EOQualifier qual2 = null;
        int logicalOp = 0;
        EOQualifier qual1 = this.Expression();
        block3: while (true) {
            NSArray quals;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            logicalOp = this.parseLogicalOp();
            qual2 = this.Expression();
            if (logicalOp == 1) {
                if (qual1 instanceof EOAndQualifier) {
                    quals = ((EOAndQualifier)qual1).qualifiers();
                    qual1 = new EOAndQualifier(quals.arrayByAddingObject((Object)qual2));
                    continue;
                }
                quals = new NSArray(new Object[]{qual1, qual2});
                qual1 = new EOAndQualifier(quals);
                continue;
            }
            if (logicalOp != 2) continue;
            if (qual1 instanceof EOOrQualifier) {
                quals = ((EOOrQualifier)qual1).qualifiers();
                qual1 = new EOOrQualifier(quals.arrayByAddingObject((Object)qual2));
                continue;
            }
            quals = new NSArray(new Object[]{qual1, qual2});
            qual1 = new EOOrQualifier(quals);
        }
        return qual1;
    }

    public _EOQualifierParser(InputStream stream) {
        this.jj_input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
        this.token_source = new _EOQualifierParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 11; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 11; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public _EOQualifierParser(Reader stream) {
        this.jj_input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
        this.token_source = new _EOQualifierParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 11; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 11; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public _EOQualifierParser(_EOQualifierParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 11; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(_EOQualifierParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 11; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[43];
        for (i = 0; i < 43; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 11; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 43; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    public static class KeyString {
        private String _keyText;

        public KeyString(Object someText) {
            this._keyText = someText.toString();
        }

        public int length() {
            return this._keyText.length();
        }

        public boolean equals(Object other) {
            Object temp = other instanceof KeyString ? other.toString() : other;
            return this._keyText.equals(temp);
        }

        public int hashCode() {
            return this._keyText.hashCode();
        }

        public String toString() {
            return this._keyText;
        }
    }
}

