/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSJavaArrayEnumerator;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;

public class _NSIntegerDictionary
implements Cloneable,
Serializable,
_NSFoundationCollection {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation._NSIntegerDictionary");
    public static final int NotAvailable = Integer.MIN_VALUE;
    static final long serialVersionUID = -5759421113986386577L;
    private static final String SerializationKeysFieldKey = "keys";
    private static final String SerializationValuesFieldKey = "integers";
    protected transient int _capacity;
    protected transient int _hashtableBuckets;
    protected transient int _count;
    protected int[] _values;
    protected transient int[] _valuesCache;
    protected transient byte[] _flags;
    protected Object[] _keys;
    protected transient Object[] _keysCache;
    protected transient int _hashCache;
    protected static int _NSDictionaryClassHashCode = _CLASS.hashCode();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("keys", _NSUtilities._NoObjectArray.getClass()), new ObjectStreamField("integers", _NSUtilities._NoIntArray.getClass())};

    protected void _initializeDictionary() {
        this._count = 0;
        this._capacity = 0;
        this._valuesCache = null;
        this._values = null;
        this._flags = null;
        this._keysCache = null;
        this._keys = null;
        this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
    }

    protected void _ensureCapacity(int capacity) {
        if (capacity > this._capacity) {
            if (capacity < 4) {
                capacity = 4;
            } else {
                int testCapacity = 2 * this._capacity;
                if (testCapacity > capacity) {
                    capacity = testCapacity;
                }
            }
            int newCapacity = _NSCollectionPrimitives.hashTableCapacityForCapacity(capacity);
            if (newCapacity != this._capacity) {
                int oldSize = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
                this._capacity = capacity;
                this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
                int newSize = this._hashtableBuckets;
                if (newSize == 0) {
                    this._values = null;
                    this._keys = null;
                    this._flags = null;
                } else {
                    int[] oldValues = this._values;
                    Object[] oldKeys = this._keys;
                    byte[] oldFlags = this._flags;
                    this._values = new int[newSize];
                    this._keys = new Object[newSize];
                    this._flags = new byte[newSize];
                    for (int i = 0; i < oldSize; ++i) {
                        if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                        _NSCollectionPrimitives.addValueInHashTable(oldKeys[i], oldValues[i], this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets);
                    }
                }
            }
        }
    }

    public _NSIntegerDictionary() {
        this._initializeDictionary();
    }

    public _NSIntegerDictionary(int value, Object key) {
        if (value == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("attempt to insert NotAvailable value into an  " + this.getClass().getName() + ".");
        }
        if (key == null) {
            throw new IllegalArgumentException("attempt to insert null key into an  " + this.getClass().getName() + ".");
        }
        this._initializeDictionary();
        this._ensureCapacity(1);
        if (_NSCollectionPrimitives.addValueInHashTable(key, value, this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets)) {
            ++this._count;
        }
    }

    private void initFromIntegers(int[] values, Object[] keys, boolean checkForNull) {
        int i;
        if (values.length != keys.length) {
            throw new IllegalArgumentException("attempt to create an " + this.getClass().getName() + "with a different number of values and keys.");
        }
        if (checkForNull) {
            for (i = 0; i < keys.length; ++i) {
                if (values[i] == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("attempt to insert NotAvailable value into an  " + this.getClass().getName() + ".");
                }
                if (keys[i] != null) continue;
                throw new IllegalArgumentException("attempt to insert null key into an _NSIntegerDictionary");
            }
        }
        this._initializeDictionary();
        this._ensureCapacity(values.length);
        for (i = 0; i < values.length; ++i) {
            if (!_NSCollectionPrimitives.addValueInHashTable(keys[i], values[i], this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets)) continue;
            ++this._count;
        }
    }

    private _NSIntegerDictionary(int[] values, Object[] keys, boolean checkForNull) {
        this.initFromIntegers(values, keys, checkForNull);
    }

    public _NSIntegerDictionary(int[] values, Object[] keys) {
        this(values, keys, true);
    }

    public _NSIntegerDictionary(_NSIntegerDictionary otherIntegerDictionary) {
        this._initializeDictionary();
        Object[] keys = otherIntegerDictionary.keysNoCopy();
        this._ensureCapacity(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            if (!_NSCollectionPrimitives.addValueInHashTable(keys[i], otherIntegerDictionary.integerForKey(keys[i]), this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets)) continue;
            ++this._count;
        }
    }

    protected Object[] keysNoCopy() {
        if (this._keysCache == null) {
            this._keysCache = this._count == 0 ? _NSCollectionPrimitives.EmptyArray : _NSCollectionPrimitives.keysInHashTable(this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._keysCache;
    }

    protected int[] integersNoCopy() {
        if (this._valuesCache == null) {
            this._valuesCache = this._count == 0 ? _NSCollectionPrimitives.EmptyIntegerArray : _NSCollectionPrimitives.valuesInHashTable(this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._valuesCache;
    }

    public int count() {
        return this._count;
    }

    public int integerForKey(Object key) {
        return this._count == 0 || key == null ? Integer.MIN_VALUE : _NSCollectionPrimitives.findValueInHashTable(key, this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets);
    }

    public NSArray allKeys() {
        return new NSArray(this.keysNoCopy());
    }

    public int[] allIntegers() {
        if (this._count == 0) {
            return _NSCollectionPrimitives.EmptyIntegerArray;
        }
        int[] values = new int[this._count];
        System.arraycopy(this.integersNoCopy(), 0, values, 0, this._count);
        return values;
    }

    public Enumeration keyEnumerator() {
        return new _NSJavaArrayEnumerator(this.keysNoCopy(), false);
    }

    public NSArray allKeysForInteger(int value) {
        if (value != Integer.MIN_VALUE) {
            Object[] keys = this.keysNoCopy();
            NSMutableArray array = new NSMutableArray(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                if (value != this.integerForKey(keys[i])) continue;
                array.addObject(keys[i]);
            }
            return array;
        }
        return NSArray.EmptyArray;
    }

    public int[] integersForKeys(NSArray keys) {
        if (keys != null) {
            Object[] keysArray = keys.objectsNoCopy();
            int index = 0;
            int[] array = new int[keysArray.length];
            for (int i = 0; i < keysArray.length; ++i) {
                int value = this.integerForKey(keysArray[i]);
                if (value == Integer.MIN_VALUE) continue;
                array[index++] = value;
            }
            return index == array.length ? array : _NSCollectionPrimitives.copyArray(array, index);
        }
        return _NSCollectionPrimitives.EmptyIntegerArray;
    }

    private boolean _equalsIntegerDictionary(_NSIntegerDictionary otherIntegerDictionary) {
        int count = this.count();
        if (count != otherIntegerDictionary.count()) {
            return false;
        }
        Object[] keys = this.keysNoCopy();
        for (int i = 0; i < count; ++i) {
            int value = this.integerForKey(keys[i]);
            int otherValue = otherIntegerDictionary.integerForKey(keys[i]);
            if (otherValue != Integer.MIN_VALUE && value == otherValue) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualToIntegerDictionary(_NSIntegerDictionary otherIntegerDictionary) {
        if (otherIntegerDictionary == null) {
            return false;
        }
        if (otherIntegerDictionary == this) {
            return true;
        }
        return this._equalsIntegerDictionary(otherIntegerDictionary);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof _NSIntegerDictionary) {
            return this._equalsIntegerDictionary((_NSIntegerDictionary)object);
        }
        return false;
    }

    public int _shallowHashCode() {
        return this.hashCode();
    }

    public int hashCode() {
        return _NSDictionaryClassHashCode ^ this.count();
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("{");
        Object[] keys = this.keysNoCopy();
        for (int i = 0; i < keys.length; ++i) {
            buffer.append(keys[i].toString());
            buffer.append(" = " + this.integerForKey(keys[i]));
            buffer.append("; ");
        }
        buffer.append("}");
        return new String(buffer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        int[] values = new int[c];
        for (int i = 0; i < c; ++i) {
            values[i] = this.integerForKey(keys[i]);
        }
        fields.put(SerializationKeysFieldKey, keys);
        fields.put(SerializationValuesFieldKey, values);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        keys = keys == null ? _NSUtilities._NoObjectArray : keys;
        int[] values = (int[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoIntArray);
        values = values == null ? _NSUtilities._NoIntArray : values;
        this.initFromIntegers(values, keys, true);
    }
}

