/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.GetResponse;
import com.amazon.s3.GetStreamResponse;
import com.amazon.s3.ListAllMyBucketsResponse;
import com.amazon.s3.ListBucketResponse;
import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import com.amazon.s3.Utils;
import com.silvasoftinc.s3.S3StreamObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class AWSAuthConnection {
    private String awsAccessKeyId;
    private String awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey) {
        this(awsAccessKeyId, awsSecretAccessKey, true);
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, "s3.amazonaws.com");
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
    }

    public Response createBucket(String bucket, Map headers) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("PUT", bucket, headers));
    }

    public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, Map headers) throws MalformedURLException, IOException {
        String path = Utils.pathForListOptions(bucket, prefix, marker, maxKeys);
        return new ListBucketResponse(this.makeRequest("GET", path, headers));
    }

    public Response deleteBucket(String bucket, Map headers) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("DELETE", bucket, headers));
    }

    public Response put(String bucket, String key, S3Object object, Map headers) throws MalformedURLException, IOException {
        String pathSep;
        boolean isEmptyKey = key == null || key.length() == 0 || key.trim().length() == 0;
        String string = pathSep = isEmptyKey ? "" : "/";
        if (key == null) {
            key = "";
        }
        HttpURLConnection request = this.makeRequest("PUT", bucket + pathSep + Utils.urlencode(key), headers, object);
        request.setDoOutput(true);
        request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
        return new Response(request);
    }

    public Response putStream(String bucket, String key, S3StreamObject object, Map headers) throws MalformedURLException, IOException {
        String pathSep;
        boolean isEmptyKey = key == null || key.length() == 0 || key.trim().length() == 0;
        String string = pathSep = isEmptyKey ? "" : "/";
        if (key == null) {
            key = "";
        }
        HttpURLConnection request = this.makeStreamRequest("PUT", bucket + pathSep + Utils.urlencode(key), headers, object);
        request.setDoOutput(true);
        if (object.length != 0L) {
            request.setFixedLengthStreamingMode((int)object.length);
        }
        byte[] buf = new byte[1024];
        int bytesRead = 0;
        OutputStream out = request.getOutputStream();
        while ((bytesRead = object.stream.read(buf)) > 0) {
            out.write(buf, 0, bytesRead);
        }
        out.close();
        return new Response(request);
    }

    public GetResponse get(String bucket, String key, Map headers) throws MalformedURLException, IOException {
        String pathSep;
        boolean isEmptyKey = key == null || key.length() == 0 || key.trim().length() == 0;
        String string = pathSep = isEmptyKey ? "" : "/";
        if (key == null) {
            key = "";
        }
        return new GetResponse(this.makeRequest("GET", bucket + pathSep + Utils.urlencode(key), headers));
    }

    public GetStreamResponse getStream(String bucket, String key, Map headers) throws MalformedURLException, IOException {
        String pathSep;
        boolean isEmptyKey = key == null || key.length() == 0 || key.trim().length() == 0;
        String string = pathSep = isEmptyKey ? "" : "/";
        if (key == null) {
            key = "";
        }
        return new GetStreamResponse(this.makeRequest("GET", bucket + pathSep + Utils.urlencode(key), headers));
    }

    public GetResponse getTorrent(String bucket, String key, Map headers) throws MalformedURLException, IOException {
        String pathSep;
        boolean isEmptyKey = key == null || key.length() == 0 || key.trim().length() == 0;
        String string = pathSep = isEmptyKey ? "" : "/";
        if (key == null) {
            key = "";
        }
        return new GetResponse(this.makeRequest("GET", bucket + pathSep + Utils.urlencode(key) + "?torrent", headers));
    }

    public Response delete(String bucket, String key, Map headers) throws MalformedURLException, IOException {
        String pathSep;
        boolean isEmptyKey = key == null || key.length() == 0 || key.trim().length() == 0;
        String string = pathSep = isEmptyKey ? "" : "/";
        if (key == null) {
            key = "";
        }
        return new Response(this.makeRequest("DELETE", bucket + pathSep + Utils.urlencode(key), headers));
    }

    public GetResponse getBucketACL(String bucket, Map headers) throws MalformedURLException, IOException {
        return this.getACL(bucket, "", headers);
    }

    public GetResponse getACL(String bucket, String key, Map headers) throws MalformedURLException, IOException {
        String pathSep;
        boolean isEmptyKey = key == null || key.length() == 0 || key.trim().length() == 0;
        String string = pathSep = isEmptyKey ? "" : "/";
        if (key == null) {
            key = "";
        }
        return new GetResponse(this.makeRequest("GET", bucket + pathSep + Utils.urlencode(key) + "?acl", headers));
    }

    public Response putBucketACL(String bucket, String aclXMLDoc, Map headers) throws MalformedURLException, IOException {
        return this.putACL(bucket, "", aclXMLDoc, headers);
    }

    public Response putACL(String bucket, String key, String aclXMLDoc, Map headers) throws MalformedURLException, IOException {
        String pathSep;
        S3Object object = new S3Object(aclXMLDoc.getBytes(), null);
        boolean isEmptyKey = key == null || key.length() == 0 || key.trim().length() == 0;
        String string = pathSep = isEmptyKey ? "" : "/";
        if (key == null) {
            key = "";
        }
        HttpURLConnection request = this.makeRequest("PUT", bucket + pathSep + Utils.urlencode(key) + "?acl", headers, object);
        request.setDoOutput(true);
        request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
        return new Response(request);
    }

    public ListAllMyBucketsResponse listAllMyBuckets(Map headers) throws MalformedURLException, IOException {
        return new ListAllMyBucketsResponse(this.makeRequest("GET", "", headers));
    }

    private HttpURLConnection makeRequest(String method, String resource, Map headers) throws MalformedURLException, IOException {
        return this.makeRequest(method, resource, headers, null);
    }

    private HttpURLConnection makeRequest(String method, String resource, Map headers, S3Object object) throws MalformedURLException, IOException {
        URL url = this.makeURL(resource);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(3600000);
        connection.setRequestMethod(method);
        this.addHeaders(connection, headers);
        if (object != null) {
            this.addMetadataHeaders(connection, object.metadata);
        }
        this.addAuthHeader(connection, method, resource);
        return connection;
    }

    private HttpURLConnection makeStreamRequest(String method, String resource, Map headers, S3StreamObject object) throws MalformedURLException, IOException {
        URL url = this.makeURL(resource);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(3600000);
        connection.setRequestMethod(method);
        this.addHeaders(connection, headers);
        if (object != null) {
            this.addMetadataHeaders(connection, object.metadata);
        }
        this.addAuthHeader(connection, method, resource);
        return connection;
    }

    private void addHeaders(HttpURLConnection connection, Map headers) {
        this.addHeaders(connection, headers, "");
    }

    private void addMetadataHeaders(HttpURLConnection connection, Map metadata) {
        this.addHeaders(connection, metadata, "x-amz-meta-");
    }

    private void addHeaders(HttpURLConnection connection, Map headers, String prefix) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                for (String value : (List)headers.get(key)) {
                    connection.addRequestProperty(prefix + key, value);
                }
            }
        }
    }

    private void addAuthHeader(HttpURLConnection connection, String method, String resource) {
        if (connection.getRequestProperty("Date") == null) {
            connection.setRequestProperty("Date", AWSAuthConnection.httpDate());
        }
        if (connection.getRequestProperty("Content-Type") == null) {
            connection.setRequestProperty("Content-Type", "");
        }
        String canonicalString = Utils.makeCanonicalString(method, resource, connection.getRequestProperties());
        String encodedCanonical = Utils.encode(this.awsSecretAccessKey, canonicalString, false);
        connection.setRequestProperty("Authorization", "AWS " + this.awsAccessKeyId + ":" + encodedCanonical);
    }

    private URL makeURL(String resource) throws MalformedURLException {
        String protocol = this.isSecure ? "https" : "http";
        return new URL(protocol, this.server, this.port, "/" + resource);
    }

    public static String httpDate() {
        String DateFormat2 = "EEE, dd MMM yyyy HH:mm:ss ";
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(new Date()) + "GMT";
    }
}

