/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GetResponse
extends Response {
    public S3Object object;

    public GetResponse(HttpURLConnection connection) throws IOException {
        super(connection);
        if (connection.getResponseCode() < 400) {
            Map metadata = this.extractMetadata(connection);
            byte[] body = GetResponse.slurpInputStream(connection.getInputStream());
            this.object = new S3Object(body, metadata);
        }
    }

    private Map extractMetadata(HttpURLConnection connection) {
        TreeMap<String, List<String>> metadata = new TreeMap<String, List<String>>();
        Map<String, List<String>> headers = connection.getHeaderFields();
        for (String key : headers.keySet()) {
            if (key == null) continue;
            metadata.put(key, headers.get(key));
        }
        return metadata;
    }

    static byte[] slurpInputStream(InputStream stream) throws IOException {
        int count;
        int chunkSize = 2048;
        byte[] buf = new byte[2048];
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(2048);
        while ((count = stream.read(buf)) != -1) {
            byteStream.write(buf, 0, count);
        }
        return byteStream.toByteArray();
    }
}

