/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.ListEntry;
import com.amazon.s3.Owner;
import com.amazon.s3.Response;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SimpleTimeZone;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ListBucketResponse
extends Response {
    public List entries = null;

    public ListBucketResponse(HttpURLConnection connection) throws IOException {
        super(connection);
        if (connection.getResponseCode() < 400) {
            try {
                XMLReader xr = Utils.createXMLReader();
                ListBucketHandler handler = new ListBucketHandler();
                xr.setContentHandler(handler);
                xr.setErrorHandler(handler);
                xr.parse(new InputSource(connection.getInputStream()));
                this.entries = handler.getEntries();
            }
            catch (SAXException e) {
                throw new RuntimeException("Unexpected error parsing ListBucket xml", e);
            }
        }
    }

    class ListBucketHandler
    extends DefaultHandler {
        private List entries = new ArrayList();
        private ListEntry currEntry = null;
        private StringBuffer currText = null;
        private SimpleDateFormat iso8601Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public ListBucketHandler() {
            this.iso8601Parser.setTimeZone(new SimpleTimeZone(0, "GMT"));
            this.currText = new StringBuffer();
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Contents")) {
                this.currEntry = new ListEntry();
            } else if (name.equals("Owner")) {
                this.currEntry.owner = new Owner();
            }
        }

        public void endElement(String uri, String name, String qName) {
            if (name.equals("Contents")) {
                this.entries.add(this.currEntry);
            } else if (name.equals("Key")) {
                this.currEntry.key = this.currText.toString();
            } else if (name.equals("LastModified")) {
                try {
                    this.currEntry.lastModified = this.iso8601Parser.parse(this.currText.toString());
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unexpected date format in list bucket output", e);
                }
            } else if (name.equals("ETag")) {
                this.currEntry.eTag = this.currText.toString();
            } else if (name.equals("Size")) {
                this.currEntry.size = Long.parseLong(this.currText.toString());
            } else if (name.equals("ID")) {
                this.currEntry.owner.id = this.currText.toString();
            } else if (name.equals("DisplayName")) {
                this.currEntry.owner.displayName = this.currText.toString();
            } else if (name.equals("StorageClass")) {
                this.currEntry.storageClass = this.currText.toString();
            }
            this.currText = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }

        public List getEntries() {
            return this.entries;
        }
    }
}

