/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class NikonType3MakernoteDescriptor
extends TagDescriptor {
    public NikonType3MakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    public String getLensDescription() throws MetadataException {
        if (!this._directory.containsTag(132)) {
            return null;
        }
        Rational[] lensValues = this._directory.getRationalArray(132);
        if (lensValues.length != 4) {
            return this._directory.getString(132);
        }
        StringBuffer description = new StringBuffer();
        description.append(lensValues[0].intValue());
        description.append('-');
        description.append(lensValues[1].intValue());
        description.append("mm f/");
        description.append(lensValues[2].floatValue());
        description.append('-');
        description.append(lensValues[3].floatValue());
        return description.toString();
    }

    public String getHueAdjustmentDescription() {
        if (!this._directory.containsTag(146)) {
            return null;
        }
        return this._directory.getString(146) + " degrees";
    }

    public String getColorModeDescription() {
        if (!this._directory.containsTag(141)) {
            return null;
        }
        String raw = this._directory.getString(141);
        if (raw.startsWith("MODE1")) {
            return "Mode I (sRGB)";
        }
        return raw;
    }
}

