/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.components;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSForwardException;
import er.attachment.model.ERAttachment;
import er.attachment.processors.ERAttachmentProcessor;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXValueUtilities;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

public class ERAttachmentUpload
extends WOComponent {
    private String _filePath;
    private String _finalFilePath;

    public ERAttachmentUpload(WOContext context) {
        super(context);
    }

    public void setFilePath(String filePath) {
        this._filePath = filePath;
    }

    public String filePath() {
        return this._filePath;
    }

    public void setFinalFilePath(String finalFilePath) {
        this._finalFilePath = finalFilePath;
    }

    public String finalFilePath() {
        return this._finalFilePath;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public boolean ajax() {
        return ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"ajax");
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        WOActionResults results = super.invokeAction(request, context);
        if (context._wasFormSubmitted() && !this.ajax()) {
            try {
                this._uploadSucceeded();
                this.valueForBinding("succeededAction");
            }
            catch (IOException e) {
                throw new NSForwardException((Throwable)e, "Failed to process uploaded attachment.");
            }
        }
        return results;
    }

    public String tempFilePath() throws IOException {
        File tempFile;
        String fileExtension;
        String configurationName = (String)this.valueForBinding("configurationName");
        String tempFolderPath = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".tempFolder"));
        if (tempFolderPath == null) {
            tempFolderPath = ERXProperties.stringForKey((String)"er.attachment.tempFolder");
        }
        if ((fileExtension = ERXFileUtilities.fileExtension((String)this._filePath)) == null) {
            fileExtension = "tmp";
        }
        fileExtension = "." + fileExtension;
        if (tempFolderPath != null) {
            File tempFolder = new File(tempFolderPath);
            tempFile = File.createTempFile("ERAttachmentUpload-", fileExtension, tempFolder);
        } else {
            tempFile = File.createTempFile("ERAttachmentUpload-", fileExtension);
        }
        return tempFile.getAbsolutePath();
    }

    public ERAttachment _uploadSucceeded() throws IOException {
        ERAttachment oldAttachment;
        int height;
        if (this._finalFilePath == null) {
            return null;
        }
        String configurationName = (String)this.valueForBinding("configurationName");
        String storageType = (String)this.valueForBinding("storageType");
        if (storageType == null && (storageType = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".storageType"))) == null) {
            storageType = ERXProperties.stringForKeyWithDefault((String)"er.attachment.storageType", (String)"db");
        }
        EOEditingContext editingContext = (EOEditingContext)this.valueForBinding("editingContext");
        File uploadedFile = new File(this._finalFilePath);
        String mimeType = (String)this.valueForBinding("mimeType");
        String ownerID = (String)this.valueForBinding("ownerID");
        int width = ERXValueUtilities.intValueWithDefault((Object)this.valueForBinding("width"), (int)-1);
        if (width == -1 && (width = ERXProperties.intForKeyWithDefault((String)("er.attachment." + configurationName + ".width"), (int)-1)) == -1) {
            width = ERXProperties.intForKeyWithDefault((String)"er.attachment.width", (int)-1);
        }
        if ((height = ERXValueUtilities.intValueWithDefault((Object)this.valueForBinding("height"), (int)-1)) == -1 && (height = ERXProperties.intForKeyWithDefault((String)("er.attachment." + configurationName + ".height"), (int)-1)) == -1) {
            height = ERXProperties.intForKeyWithDefault((String)"er.attachment.height", (int)-1);
        }
        Object attachment = ERAttachmentProcessor.processorForType(storageType).process(editingContext, uploadedFile, this._filePath, mimeType, width, height, configurationName, ownerID);
        if (ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"cleanup", (boolean)false) && (oldAttachment = (ERAttachment)((Object)this.valueForBinding("attachment"))) != null) {
            oldAttachment.delete();
        }
        this.setValueForBinding(attachment, "attachment");
        return attachment;
    }

    public WOActionResults uploadSucceeded() throws MalformedURLException, IOException {
        this._uploadSucceeded();
        return (WOActionResults)this.valueForBinding("succeededAction");
    }
}

