/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import er.attachment.metadata.DrewMetadataParser;
import er.attachment.metadata.ERParsedMetadataDirectory;
import er.attachment.metadata.ERUnparsedMetadataDirectory;
import er.attachment.metadata.IERMetadataDirectoryParser;
import java.util.Iterator;

public class DrewMetadataDirectoryParser
implements IERMetadataDirectoryParser {
    public ERParsedMetadataDirectory parseMetadata(ERUnparsedMetadataDirectory unparsedMetadata) {
        ERParsedMetadataDirectory parsedMetadataDirectory = null;
        Metadata metadata = new Metadata();
        byte[] data = unparsedMetadata.getMetadata();
        String directoryName = unparsedMetadata.getDirectoryName();
        if (directoryName.equalsIgnoreCase("EXIF")) {
            new ExifReader(data).extract(metadata);
            parsedMetadataDirectory = new ERParsedMetadataDirectory(directoryName);
        } else if (directoryName.equalsIgnoreCase("IPTC")) {
            new IptcReader(data).extract(metadata);
            parsedMetadataDirectory = new ERParsedMetadataDirectory(directoryName);
        }
        if (parsedMetadataDirectory != null) {
            Iterator directories = metadata.getDirectoryIterator();
            while (directories.hasNext()) {
                Directory directory = (Directory)directories.next();
                DrewMetadataParser.fillInParsedMetadataDirectoryFromDrewMetadata(parsedMetadataDirectory, directory);
            }
        }
        return parsedMetadataDirectory;
    }
}

