/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERMetadataUtils {
    private static Map<String, Integer> IPTC_NAME_TO_TYPE = new HashMap<String, Integer>();
    private static Map<String, Integer> EXIF_NAME_TO_TYPE = new HashMap<String, Integer>();

    public static int typeForExifTagName(String name) {
        return ERMetadataUtils.typeForTagName(EXIF_NAME_TO_TYPE, name);
    }

    public static int typeForIptcTagName(String name) {
        return ERMetadataUtils.typeForTagName(IPTC_NAME_TO_TYPE, name);
    }

    public static int typeForPdfTagName(String name) {
        return ERMetadataUtils.typeForTagName("PDF", name);
    }

    public static int typeForTagName(String directoryName, String name) {
        int type = "EXIF".equalsIgnoreCase(directoryName) ? ERMetadataUtils.typeForTagName(EXIF_NAME_TO_TYPE, name) : ("IPTC".equalsIgnoreCase(directoryName) ? ERMetadataUtils.typeForTagName(IPTC_NAME_TO_TYPE, name) : ("PDF".equalsIgnoreCase(directoryName) ? name.hashCode() : (ERMetadataUtils.customMetadataDirectoryName().equals(directoryName) ? name.hashCode() : -1)));
        return type;
    }

    public static int typeForTagName(Map<String, Integer> map, String name) {
        Integer typeInteger = map.get(name);
        int type = typeInteger != null ? typeInteger : -1;
        return type;
    }

    public static Class classForTagName(String directoryName, String name) {
        return String.class;
    }

    public static String customMetadataDirectoryName() {
        return "Custom";
    }

    static {
        IPTC_NAME_TO_TYPE.put("Caption/Abstract", new Integer(632));
        IPTC_NAME_TO_TYPE.put("City", new Integer(602));
        IPTC_NAME_TO_TYPE.put("CopyrightNotice", new Integer(628));
        IPTC_NAME_TO_TYPE.put("Country/PrimaryLocationName", new Integer(613));
        IPTC_NAME_TO_TYPE.put("Credit", new Integer(622));
        IPTC_NAME_TO_TYPE.put("DateCreated", new Integer(567));
        IPTC_NAME_TO_TYPE.put("TimeCreated", new Integer(572));
        IPTC_NAME_TO_TYPE.put("Province/State", new Integer(607));
        IPTC_NAME_TO_TYPE.put("Source", new Integer(627));
        IPTC_NAME_TO_TYPE.put("Category", new Integer(527));
        IPTC_NAME_TO_TYPE.put("ObjectName", new Integer(517));
        EXIF_NAME_TO_TYPE.put("ExposureTime", new Integer(33434));
        EXIF_NAME_TO_TYPE.put("Flash", new Integer(37385));
        EXIF_NAME_TO_TYPE.put("ColorSpace", new Integer(40961));
        EXIF_NAME_TO_TYPE.put("SceneCaptureType", new Integer(41729));
        EXIF_NAME_TO_TYPE.put("FocalPlaneYResolution", new Integer(41487));
        EXIF_NAME_TO_TYPE.put("FocalPlaneResolutionUnit", new Integer(41488));
        EXIF_NAME_TO_TYPE.put("FocalLength", new Integer(37386));
        EXIF_NAME_TO_TYPE.put("ShutterSpeedValue", new Integer(37377));
        EXIF_NAME_TO_TYPE.put("FNumber", new Integer(33437));
        EXIF_NAME_TO_TYPE.put("PixelYDimension", new Integer(40962));
        EXIF_NAME_TO_TYPE.put("ApertureValue", new Integer(37378));
        EXIF_NAME_TO_TYPE.put("PixelXDimension", new Integer(40963));
        EXIF_NAME_TO_TYPE.put("WhiteBalance", new Integer(37384));
        EXIF_NAME_TO_TYPE.put("DateTimeDigitized", new Integer(36868));
        EXIF_NAME_TO_TYPE.put("ExposureProgram", new Integer(34850));
        EXIF_NAME_TO_TYPE.put("DateTimeOriginal", new Integer(36867));
        EXIF_NAME_TO_TYPE.put("MeteringMode", new Integer(37383));
        EXIF_NAME_TO_TYPE.put("ExposureBiasValue", new Integer(37380));
        EXIF_NAME_TO_TYPE.put("FocalPlaneXResolution", new Integer(41486));
        EXIF_NAME_TO_TYPE.put("Orientation", new Integer(274));
        EXIF_NAME_TO_TYPE.put("Model", new Integer(272));
        EXIF_NAME_TO_TYPE.put("YResolution", new Integer(283));
        EXIF_NAME_TO_TYPE.put("XResolution", new Integer(282));
        EXIF_NAME_TO_TYPE.put("DateTime", new Integer(306));
        EXIF_NAME_TO_TYPE.put("Make", new Integer(271));
        EXIF_NAME_TO_TYPE.put("ResolutionUnit", new Integer(296));
        EXIF_NAME_TO_TYPE.put("Copyright", new Integer(33432));
        EXIF_NAME_TO_TYPE.put("Artist", new Integer(315));
        EXIF_NAME_TO_TYPE.put("Software", new Integer(305));
        EXIF_NAME_TO_TYPE.put("ImageDescription", new Integer(270));
        EXIF_NAME_TO_TYPE.put("UserComment", new Integer(37510));
        EXIF_NAME_TO_TYPE.put("MaxApertureValue", new Integer(37381));
        EXIF_NAME_TO_TYPE.put("LightSource", new Integer(37384));
        EXIF_NAME_TO_TYPE.put("SensingMethod", new Integer(41495));
        EXIF_NAME_TO_TYPE.put("SubsecTimeDigitized", new Integer(37522));
        EXIF_NAME_TO_TYPE.put("SubjectDistRange", new Integer(37382));
        EXIF_NAME_TO_TYPE.put("RelatedSoundFile", new Integer(40964));
        EXIF_NAME_TO_TYPE.put("SubsecTimeOriginal", new Integer(37521));
        EXIF_NAME_TO_TYPE.put("SubsecTime", new Integer(37520));
        EXIF_NAME_TO_TYPE.put("PhotometricInterpretation", new Integer(262));
        EXIF_NAME_TO_TYPE.put("Compression", new Integer(259));
        EXIF_NAME_TO_TYPE.put("SubjectDistance", new Integer(37382));
    }
}

