/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

import er.attachment.metadata.ERMetadataDirectorySet;
import er.attachment.metadata.ERMetadataParserException;
import er.attachment.metadata.ERUnparsedMetadataDirectory;
import er.attachment.metadata.IERMetadataParser;
import er.extensions.foundation.ERXProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.log4j.lf5.util.StreamUtils;

public class ImageMagickCommandlineMetadataParser
implements IERMetadataParser {
    public static final int BUFFER_SIZE = 8192;
    private File _imageMagickBinary;

    public ImageMagickCommandlineMetadataParser(File imageMagickBinary) {
        this._imageMagickBinary = imageMagickBinary;
    }

    public ERMetadataDirectorySet parseMetadata(File importFile) throws ERMetadataParserException {
        try {
            byte[] iptcBytes;
            ERMetadataDirectorySet metadataDirectorySet = new ERMetadataDirectorySet();
            byte[] exifBytes = this.extractMetadata(importFile, "exif");
            if (exifBytes != null && exifBytes.length > 0) {
                metadataDirectorySet.addMetadata(new ERUnparsedMetadataDirectory(importFile, "EXIF", exifBytes));
            }
            if ((iptcBytes = this.extractMetadata(importFile, "iptc")) != null && iptcBytes.length > 0) {
                metadataDirectorySet.addMetadata(new ERUnparsedMetadataDirectory(importFile, "IPTC", iptcBytes));
            }
            return metadataDirectorySet;
        }
        catch (IOException e) {
            throw new ERMetadataParserException("Failed to parse metadata.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] extractMetadata(File importFile, String type) throws IOException, ERMetadataParserException {
        byte[] metadataBytes;
        LinkedList<String> imageMagickCommandList = new LinkedList<String>();
        imageMagickCommandList.add(this._imageMagickBinary.getAbsolutePath());
        imageMagickCommandList.add(importFile.getAbsolutePath());
        File metadataFile = File.createTempFile("Metadata", type);
        imageMagickCommandList.add(metadataFile.getAbsolutePath());
        String[] imageMagickCommands = imageMagickCommandList.toArray(new String[imageMagickCommandList.size()]);
        Process process = Runtime.getRuntime().exec(imageMagickCommands);
        try {
            int returnValue = process.waitFor();
            if (returnValue != 1 && returnValue != 0) {
                throw new ERMetadataParserException("ImageMagick failed with return value " + returnValue);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new ERMetadataParserException("ImageMagick was interrupted.");
        }
        if (metadataFile.exists() && metadataFile.length() > 0L) {
            FileInputStream fis = new FileInputStream(metadataFile);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamUtils.copy((InputStream)fis, (OutputStream)baos, (int)8192);
                metadataBytes = baos.toByteArray();
            }
            finally {
                fis.close();
            }
            metadataFile.delete();
        } else {
            metadataBytes = null;
        }
        return metadataBytes;
    }

    public static IERMetadataParser imageMagickMetadataParser() throws IOException {
        File imageMagickConvertFile;
        ImageMagickCommandlineMetadataParser metadataParser = null;
        String imageMagickBinFolder = ERXProperties.stringForKey((String)"er.attachment.ImageProcessor.imageMagickBinFolder");
        if (imageMagickBinFolder != null) {
            imageMagickConvertFile = new File(imageMagickBinFolder, "convert");
            if (!imageMagickConvertFile.exists()) {
                throw new IllegalArgumentException("Cannot use ImageMagick because either " + imageMagickConvertFile + " does not exist.");
            }
        } else {
            throw new IllegalArgumentException("Cannot use ImageMagick because you have not set 'er.attachment.ImageProcessor.imageMagickBinFolder'.");
        }
        metadataParser = new ImageMagickCommandlineMetadataParser(imageMagickConvertFile);
        return metadataParser;
    }
}

