/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.utils;

import com.webobjects.foundation.NSArray;
import er.attachment.utils.ERGlobMimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERMimeType {
    private String _name;
    private String _mimeType;
    private String _uti;
    private NSArray<String> _extensions;

    public ERMimeType(String name, String mimeType, String uti, NSArray<String> extensions) {
        this._name = name;
        this._mimeType = mimeType;
        this._uti = uti;
        this._extensions = extensions;
    }

    public ERGlobMimeType globMimeType() {
        return new ERGlobMimeType(this.type() + "/*");
    }

    public boolean matchesExactly(ERMimeType mimeType) {
        return this._mimeType.equalsIgnoreCase(mimeType._mimeType);
    }

    public boolean matches(ERMimeType otherMimeType) {
        boolean matches;
        if ("*".equals(this._mimeType) || otherMimeType != null && "*".equals(otherMimeType._mimeType)) {
            matches = true;
        } else if (otherMimeType == null) {
            matches = false;
        } else {
            String otherBase;
            String mimeTypeStr = this._mimeType;
            String otherMimeTypeStr = otherMimeType._mimeType;
            int slashIndex = mimeTypeStr.indexOf(47);
            int otherSlashIndex = otherMimeTypeStr.indexOf(47);
            String base = mimeTypeStr.substring(0, slashIndex);
            if (base.equals(otherBase = otherMimeTypeStr.substring(0, otherSlashIndex))) {
                String type = mimeTypeStr.substring(slashIndex + 1);
                String otherType = otherMimeTypeStr.substring(otherSlashIndex + 1);
                matches = "*".equals(type) || "*".equals(otherType) || type.equals(otherType);
            } else {
                matches = false;
            }
        }
        return matches;
    }

    public String name() {
        return this._name;
    }

    public String mimeType() {
        return this._mimeType;
    }

    public String uti() {
        return this._uti;
    }

    public NSArray<String> extensions() {
        return this._extensions;
    }

    public boolean isRepresentedByExtension(String extension) {
        boolean representedByExtension = false;
        for (int i = 0; !representedByExtension && i < this._extensions.count(); ++i) {
            representedByExtension = ((String)this._extensions.objectAtIndex(i)).equalsIgnoreCase(extension);
        }
        return representedByExtension;
    }

    public String primaryExtension() {
        String extension = this._extensions != null && this._extensions.count() > 0 ? (String)this._extensions.objectAtIndex(0) : "";
        return extension;
    }

    public String type() {
        return this._mimeType.substring(0, this._mimeType.indexOf(47));
    }

    public String subtype() {
        return this._mimeType.substring(this._mimeType.indexOf(47) + 1);
    }

    public boolean isImage() {
        return this._mimeType.startsWith("image/");
    }

    public boolean isVideo() {
        return this._mimeType.startsWith("video/");
    }

    public boolean isAudio() {
        return this._mimeType.startsWith("audio/");
    }

    public String toString() {
        return "[ERMimeType: mimeType=" + this._mimeType + "]";
    }
}

