package er.ajax;
// Generated by the WOLips Templateengine Plug-in at Jul 8, 2007 10:55:05 AM

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;

import er.extensions.ERXExtensions;

/**
 * <p>
 * AjaxPingUpdate is primarily for use inside of an AjaxPing tag to support 
 * ping-updating multiple containers from a single AjaxPing request. Just 
 * like AjaxPing, you provide a cache key that upon changing, triggers the 
 * update of another target AjaxUpdateContainer.
 * </p>
 * 
 * @binding targetContainerID the ID of the update container to refresh when a change is detected
 * @binding cacheKey some hash value that represents the state of the target container
 * @binding onBeforeUpdate (optional) the javascript function to call before updating (should return true if the update
 *          should happen, false if not)
 *  
 * @author mschrag
 */
public class AjaxPingUpdate extends WOComponent {
  private Boolean _refreshTarget;
  	private static final Object NOT_INITIALIZED = new Object();  
	private Object _lastCacheKey = NOT_INITIALIZED;
	public AjaxPingUpdate(WOContext context) {
		super(context);
	}

	public boolean synchronizesVariablesWithBindings() {
		return false;
	}

	/**
	 * Returns whether or not the target should be refreshed.
	 * 
	 * @return whether or not the target should be refreshed
	 */
	public boolean refreshTarget() {
    boolean refreshTarget = false;
	  if (_refreshTarget == null) {
  		Object cacheKey = valueForBinding("cacheKey");
  		if(_lastCacheKey == NOT_INITIALIZED) {
  			_lastCacheKey = cacheKey;
  		}
  		if(ERXExtensions.safeDifferent(_lastCacheKey, cacheKey)) {
  			refreshTarget = true;
  			_lastCacheKey = cacheKey;
  		}
  		_refreshTarget = Boolean.valueOf(refreshTarget);
	  }
		return _refreshTarget.booleanValue();
	}
	
	public void sleep() {
		super.sleep();
		_refreshTarget = null;
	}

	/**
	 * Returns the target container ID.
	 * 
	 * @return the target container ID
	 */
	public String targetContainerID() {
		return (String) valueForBinding("targetContainerID");
	}

}