package er.extensions.components;
// Generated by the WOLips Templateengine Plug-in at 11.01.2007 09:43:18

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPropertyListSerialization;

import er.extensions.ERXExtensions;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
/**
 * Editor page for the localized files that are supplied in your settings. Note that the "save"
 * overwrites the files in the bundle, so be sure to have it pointed to the original file and not
 * the built bundle.
 * 
 *
 * @author ak
 */
public class ERXLocalizationEditor extends WOComponent {

	public String currentLanguage;
	public String currentFilename;
	public String currentFramework;
	public NSMutableArray data;
	public NSMutableDictionary currentEntry;
	public String selectedFramework;
	public String selectedFilename;
	public String UNSET = new String("***UNSET***");
	public WODisplayGroup displayGroup;
	public String keyToAdd;
	
    public ERXLocalizationEditor(WOContext context) {
        super(context);
        displayGroup = new WODisplayGroup();
        displayGroup.setSortOrderings(new NSArray(new EOSortOrdering("key", EOSortOrdering.CompareCaseInsensitiveAscending)));
        displayGroup.setNumberOfObjectsPerBatch(20);
        displayGroup.setDefaultStringMatchFormat("*%@*");
        displayGroup.setDefaultStringMatchOperator(EOQualifier.QualifierOperatorCaseInsensitiveLike.name());
    }
    
    public void awake () {
    	super.awake();
    	this.keyToAdd = null;
    	if (this.displayGroup != null) {
    		this.displayGroup.setSelectedObject(null);
    	}
    }

    public NSArray availableLanguages() {
    	return ERXLocalizer.availableLanguages();
    }

    public NSArray frameworkSearchPath() {
    	return ERXLocalizer.frameworkSearchPath();
    }

    public NSArray fileNamesToWatch() {
    	return ERXLocalizer.fileNamesToWatch();
    }
    
    public URL urlForCurrentFile() {
    	return ERXFileUtilities.pathURLForResourceNamed(currentFilename, currentFramework, new NSArray(currentLanguage));
    }
    
    public URL urlForSelectedFile() {
    	return ERXFileUtilities.pathURLForResourceNamed(selectedFilename, selectedFramework, new NSArray(currentLanguage));
    }
    
    public boolean fileExistsInLanguage() {
    	return urlForCurrentFile() != null;
    }
    
    public void editFramework() {
    	data = new NSMutableArray();
    	NSMutableDictionary dataDictionary = new NSMutableDictionary();
       	selectedFilename = currentFilename;
       	selectedFramework = currentFramework;
    	NSMutableSet allKeys = new NSMutableSet();
    	for (Enumeration languages = availableLanguages().objectEnumerator(); languages.hasMoreElements();) {
    		String language = (String) languages.nextElement();
			NSArray languageArray = new NSArray(language);
			URL url = ERXFileUtilities.pathURLForResourceNamed(currentFilename, currentFramework, languageArray);
			if(url != null) {
				NSDictionary dict = (NSDictionary)ERXExtensions.readPropertyListFromFileInFramework(currentFilename, currentFramework, languageArray);
				allKeys.addObjectsFromArray(dict.allKeys());
				for (Enumeration keys = dict.allKeys().objectEnumerator(); keys.hasMoreElements();) {
					String key = (String) keys.nextElement();
					NSMutableDictionary entry = (NSMutableDictionary) dataDictionary.objectForKey(key);
					if(entry == null) {
						entry = new NSMutableDictionary();
						entry.setObjectForKey(key, "key");
						dataDictionary.setObjectForKey(entry, key);
						data.addObject(entry);
					}
					entry.setObjectForKey(dict.objectForKey(key), language);
				}
			}
		}
    	for (Enumeration keys = allKeys.objectEnumerator(); keys.hasMoreElements();) {
			String key = (String) keys.nextElement();
			NSMutableDictionary entry = (NSMutableDictionary) dataDictionary.objectForKey(key);
			for (Enumeration languages = availableLanguages().objectEnumerator(); languages.hasMoreElements();) {
				String language = (String) languages.nextElement();
				if(entry.objectForKey(language) == null) {
					entry.setObjectForKey(UNSET, language);
				}
			}
		}
    	displayGroup.setObjectArray(data);
    }

    public boolean isLargeEntry() {
    	String language = currentLanguage;
    	Object object = currentEntry.objectForKey(language);
		if (object != null && (object.toString().length() > 25
    			|| object.toString().indexOf('\n') >= 0 || !(object instanceof String))) {
    		
    		return true;
    	}
    	return false;
    }
    
    /**
     * Returns a colored border style for unset values
     */
    public String highlightClass () {
    	if (!hasCurrentValue()) {
    		return "unset";
    	}
    	else return "inputfield";
    }
    
    /**
     * Returns a width for the current columns
     */
    public String valueCellWidth () {
    	int width = 100 / availableLanguages().count();
    	return "" + width + "%";
    }
    
    public int colspanForBatchNavigation () {
    	if (availableLanguages() != null && availableLanguages().count() > 1) {
    		return availableLanguages().count() - 1;
    	}
    	else return 1;
    }
    
    public String valueComponentName() {
    	return isLargeEntry()? "WOText" : "WOTextField";
    }
    
    public void saveFramework() throws IOException {
    	for (Enumeration languages = availableLanguages().objectEnumerator(); languages.hasMoreElements();) {
     		String language = (String) languages.nextElement();
			NSArray languageArray = new NSArray(language);
			URL url = ERXFileUtilities.pathURLForResourceNamed(selectedFilename, selectedFramework, languageArray);
			NSMutableDictionary dict = new NSMutableDictionary();
     		for (Enumeration entries = data.objectEnumerator(); entries.hasMoreElements();) {
     			NSDictionary entry = (NSDictionary) entries.nextElement();
     			String key = (String) entry.objectForKey("key");
				Object value = entry.objectForKey(language);
				if(value != null && !value.equals(UNSET)) {
					dict.setObjectForKey(value, key);
				}
			}
     		String result = ERXStringUtilities.stringFromDictionary(dict);
     		NSDictionary newDict = (NSDictionary) NSPropertyListSerialization.propertyListFromString(result);
     		if(!newDict.equals(dict)) {
     			throw new IllegalStateException("Data wasn't equal when comparing before save");
     		} else {
     			if(url != null) {
     				ERXFileUtilities.stringToFile(result, new File(url.getFile()));
     			}
     		}
    	}
    }
    
    private Object currentValueObject() {
    	Object result = null;
    	if(currentEntry != null) {
    		result = currentEntry.objectForKey(currentLanguage);
     	}
    	return result;
    }
    
    public boolean hasCurrentValue() {
    	return currentValueObject() != UNSET;
    }
    
    public String currentValue() {
    	String result = null;
    	if(currentEntry != null) {
    		Object item = currentEntry.objectForKey(currentLanguage);
    		if (item instanceof String) {
				result = (String)item;
			} else {
	    		result = NSPropertyListSerialization.stringFromPropertyList(item);
			}
    	}
    	return result;
    }
	
    public void setCurrentValue(String value) {
    	if(currentEntry != null) {
    		Object item = currentEntry.objectForKey(currentLanguage);
    		Object newValue;
    		if (item instanceof String) {
    			newValue = (String)value;
			} else {
				newValue = NSPropertyListSerialization.propertyListFromString(value);
			}
    		if(newValue ==null) {
    			newValue = UNSET;
    		}
    		currentEntry.setObjectForKey(newValue, currentLanguage);
     	}
    }
    
    /**
     * Sorts the entries ascending with the selected language, brings empty entries to the first batches
     * 
     */
    public WOComponent sortEntries () {
    	EOSortOrdering sortOrdering = EOSortOrdering.sortOrderingWithKey(this.currentLanguage, EOSortOrdering.CompareAscending);
    	this.displayGroup.setSortOrderings(new NSArray(sortOrdering));
    	this.displayGroup.qualifyDisplayGroup();
    	
    	return this.context().page();
    }
    
    /**
     * Add an entry to the array of objects
     * 
     */
    public WOComponent addEntry () {
    	if (this.keyToAdd != null && this.data != null && this.displayGroup != null) {
	    	NSMutableDictionary entry = new NSMutableDictionary();
	    	
	    	entry.setObjectForKey(keyToAdd, "key");
	    	
	    	for (int i = 0; i < this.availableLanguages().count(); i++) {
	    		entry.setObjectForKey(UNSET, this.availableLanguages().objectAtIndex(i));
	    	}
	    	
	    	this.data.addObject(entry);
	    	this.displayGroup.setObjectArray(data);
	    	this.displayGroup.qualifyDataSource();
	    	this.displayGroup.setSelectedObject(entry);
	    	this.displayGroup.displayBatchContainingSelectedObject();
    	}
    	return this.context().page();
    }
    
    /**
     * Removes the current entry from all languages
     * 
     */
    public WOComponent removeEntry () {
    	if (this.currentEntry != null) {
    		this.data.removeObject(currentEntry);
    		this.displayGroup.setObjectArray(data);
    		this.displayGroup.qualifyDisplayGroup();
    	}
    	return this.context().page();
    }
}
