/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cron;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import net.spy.cron.Job;
import net.spy.log.Logger;
import net.spy.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueue<T extends Job>
extends ArrayList<T> {
    private transient Logger logger = null;

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public synchronized void addJob(T j) {
        this.getLogger().debug("Adding job:  %s", j);
        this.add(j);
        this.notify();
    }

    public synchronized Collection<Job> getReadyJobs() {
        ArrayList<Job> v = new ArrayList<Job>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Job j = (Job)i.next();
            if (j.isReady()) {
                v.add(j);
                j.findNextRun();
                continue;
            }
            if (!j.isTrash()) continue;
            this.getLogger().info("JobQueue: Removing %s", j);
            i.remove();
        }
        return v;
    }

    public synchronized Date getNextStartDate() {
        Date next = null;
        long soonestJob = Long.MAX_VALUE;
        long now = System.currentTimeMillis();
        for (Job j : this) {
            long t;
            Date jdate = j.getStartTime();
            if (jdate == null || (t = jdate.getTime() - now) <= 0L || t >= soonestJob) continue;
            soonestJob = t;
            next = jdate;
        }
        return next;
    }
}

