/*
 * Decompiled with CFR 0.152.
 */
package net.spy.net;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.SpyObject;
import net.spy.concurrent.SynchronizationObject;
import net.spy.net.HTTPFetch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLItem
extends SpyObject
implements Runnable {
    private static final int DEFAULT_UPDATE_FREQ = 1800000;
    private int maxIdleTime = 1800000;
    private int updateFrequency = 1800000;
    private long lastRequest = 0L;
    private int numUpdates = 0;
    private URL url = null;
    private Map<String, List<String>> lastHeaders = null;
    private SynchronizationObject<String> content = null;
    private long lastModified = 0L;
    private boolean isRunning = true;
    private IOException lastError = null;

    public URLItem(URL u) {
        this(u, 1800000);
    }

    public URLItem(URL u, int i) {
        this.updateFrequency = i;
        this.url = u;
        this.lastRequest = System.currentTimeMillis();
        this.content = new SynchronizationObject<Object>(null);
    }

    protected HTTPFetch getFetcher(Map<String, List<String>> headers) {
        return new HTTPFetch(this.url, headers);
    }

    private void setContent(String to, Map<String, List<String>> headers, long lastMod) {
        this.content.set(to);
        if (this.getLogger().isDebugEnabled()) {
            String c = this.content.get();
            this.getLogger().debug("Setting content for %s: %s", this, c == null ? "<null>" : c.length() + " bytes");
        }
        this.lastModified = lastMod;
        this.lastHeaders = headers;
    }

    public String getContent() throws IOException {
        this.lastRequest = System.currentTimeMillis();
        if (this.lastError != null) {
            throw this.lastError;
        }
        String c = this.content.get();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Getting content for %s:  %s", this, c == null ? "<null>" : c.length() + " bytes");
        }
        return c;
    }

    public String waitForContent(long dur, TimeUnit timeunit) throws InterruptedException, TimeoutException {
        this.content.waitUntilNotNull(dur, timeunit);
        return this.content.get();
    }

    public long getLastRequest() {
        return this.lastRequest;
    }

    public URL getURL() {
        return this.url;
    }

    public void setMaxIdleTime(int to) {
        this.maxIdleTime = to;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    @Override
    public void run() {
        List<String> eTags;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("no-cache");
        headers.put("Pragma", tmp);
        if (this.lastHeaders != null && (eTags = this.lastHeaders.get("ETag")) != null) {
            headers.put("If-None-Match", eTags);
        }
        ++this.numUpdates;
        try {
            this.getLogger().info("Updating %s", this.url);
            HTTPFetch hf = this.getFetcher(headers);
            hf.setIfModifiedSince(this.lastModified);
            if (hf.getStatus() == 200) {
                this.getLogger().info("Updated %s", this.url);
                this.setContent(hf.getData(), hf.getResponseHeaders(), hf.getLastModified());
            } else {
                this.getLogger().info("Not saving content due to response status %s", hf.getStatus());
            }
        }
        catch (IOException e) {
            this.lastError = e;
        }
        if (System.currentTimeMillis() - this.lastRequest > (long)this.maxIdleTime) {
            this.isRunning = false;
            this.getLogger().info("Stopped updating %s", this.url);
        }
    }
}

