/*
 * Decompiled with CFR 0.152.
 */
package net.spy.net;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.SpyObject;
import net.spy.net.URLItem;

public class URLWatcher
extends SpyObject {
    private static URLWatcher instance = null;
    private ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "URLWatcher worker");
            t.setDaemon(true);
            return t;
        }
    });
    private Map<URL, FutureURL> items = new ConcurrentHashMap<URL, FutureURL>();
    private int recentTouches = 0;

    protected URLWatcher() {
    }

    public static synchronized URLWatcher getInstance() {
        if (instance == null || URLWatcher.instance.executor == null) {
            instance = new URLWatcher();
        }
        return instance;
    }

    public static synchronized void setInstance(URLWatcher uw) {
        if (instance != null) {
            instance.shutdown();
        }
        instance = uw;
    }

    public String toString() {
        int numPages = this.items.size();
        return super.toString() + " - " + numPages + " pages monitored";
    }

    private URLItem getURLItem(URL u) {
        FutureURL rv = this.items.get(u);
        if (rv != null && !rv.urlItem.isRunning()) {
            this.items.remove(u);
            rv.future.cancel(false);
            rv = null;
        }
        return rv == null ? null : rv.urlItem;
    }

    public boolean isWatching(URL u) {
        URLItem ui = this.getURLItem(u);
        return ui != null;
    }

    public void startWatching(URLItem u) {
        if (!this.isWatching(u.getURL())) {
            ScheduledFuture<?> f = this.executor.scheduleAtFixedRate(u, 0L, u.getUpdateFrequency(), TimeUnit.MILLISECONDS);
            this.items.put(u.getURL(), new FutureURL(f, u));
            try {
                u.waitForContent(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.getLogger().warn((Object)"Someone interrupted my sleep", e);
            }
            catch (TimeoutException e) {
                this.getLogger().warn("Timed out waiting for initial update");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            instance = null;
            if (this.executor != null) {
                List<Runnable> cancelled = this.executor.shutdownNow();
                if (cancelled.size() > 0) {
                    this.getLogger().info("Shutting down cancelled %s", cancelled);
                }
                this.executor = null;
            }
        }
    }

    protected URLItem getNewURLItem(URL u) {
        return new URLItem(u);
    }

    public String getContent(URL u) throws IOException {
        ++this.recentTouches;
        URLItem ui = this.getURLItem(u);
        if (ui == null) {
            ui = this.getNewURLItem(u);
            this.startWatching(ui);
        }
        return ui.getContent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FutureURL {
        URLItem urlItem;
        ScheduledFuture<?> future;

        public FutureURL(ScheduledFuture<?> f, URLItem u) {
            this.future = f;
            this.urlItem = u;
        }
    }
}

