/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import net.spy.SpyObject;

public final class GarbageCollector
extends SpyObject {
    private static GarbageCollector gcInstance = null;
    private long lastRun = 0L;
    private static final int MIN_SLEEP = 5000;
    private boolean inProgress = false;

    private GarbageCollector() {
    }

    public static synchronized GarbageCollector getGarbageCollector() {
        if (gcInstance == null) {
            gcInstance = new GarbageCollector();
        }
        return gcInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void collect() {
        long now = System.currentTimeMillis();
        if (!this.inProgress && now - this.lastRun > 5000L) {
            this.inProgress = true;
            try {
                this.getLogger().debug("Running gc and finalization");
                System.gc();
                System.runFinalization();
            }
            finally {
                this.inProgress = false;
            }
            this.lastRun = now;
        } else if (this.getLogger().isDebugEnabled()) {
            GCWarning gw = new GCWarning("Too soon for a garbage collection");
            this.getLogger().debug(gw);
        }
    }

    private static class GCWarning
    extends Exception {
        public GCWarning(String msg) {
            super(msg);
        }
    }
}

