/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import java.util.Date;
import net.spy.SpyObject;
import net.spy.pool.PoolException;

public abstract class PoolAble
extends SpyObject {
    private static final int TOSTRING_LEN = 128;
    private int objectId = -1;
    private boolean checkedOut = false;
    private Object theObject = null;
    private long maxAge = 0L;
    private long startTime = 0L;
    private String poolName = null;
    private int checkouts = 0;
    private int checkins = 0;
    private int poolHash = 0;
    public static final int MAY_CLEAN = 1;
    public static final int MUST_CLEAN = 2;
    private boolean available = true;

    public PoolAble(Object o, int h) {
        this.theObject = o;
        this.poolHash = h;
        this.startTime = System.currentTimeMillis();
        this.debug("New object");
    }

    public PoolAble(Object o, long a, int h) {
        this.theObject = o;
        this.maxAge = a;
        this.poolHash = h;
        this.startTime = System.currentTimeMillis();
        this.debug("New object.");
    }

    private String debugName() {
        return "PoolAble " + this.objectId + " for " + Integer.toHexString(this.poolHash);
    }

    public synchronized void setMaxAge(long to) {
        this.maxAge = to;
    }

    public synchronized boolean isAlive() {
        return true;
    }

    public synchronized Object getObject() throws PoolException {
        if (!this.checkedOut) {
            throw new PoolException("This PoolAble has not been checked out.");
        }
        return this.theObject;
    }

    protected Object intGetObject() {
        return this.theObject;
    }

    public void setObjectID(int id) {
        this.objectId = id;
    }

    public void setPoolName(String to) {
        this.poolName = to;
    }

    public int getObjectID() {
        return this.objectId;
    }

    public void activate() {
        this.debug("Activated.");
    }

    public synchronized void checkIn() {
        this.checkedOut = false;
        ++this.checkins;
        boolean bl = this.available = !this.isExpired();
        if (!this.isAlive()) {
            this.available = false;
        }
        this.debug("Checked in.");
    }

    protected synchronized void setAvailable() {
        this.available = true;
    }

    protected synchronized void setUnavailable() {
        this.available = false;
    }

    private boolean isExpired() {
        boolean rv = true;
        if (this.maxAge == 0L) {
            rv = false;
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.startTime < this.maxAge) {
                rv = false;
            }
        }
        return rv;
    }

    public synchronized void checkOut() {
        ++this.checkouts;
        this.checkedOut = true;
        this.available = false;
        this.debug("Checked out.");
    }

    public synchronized boolean isCheckedOut() {
        return this.checkedOut;
    }

    public synchronized boolean isAvailable() {
        if (this.available && this.isExpired()) {
            this.available = false;
        }
        return this.available;
    }

    public synchronized int pruneStatus() {
        int ret = 0;
        if (!this.checkedOut) {
            ++ret;
            if (!this.isAvailable()) {
                ++ret;
            }
            if (!this.isAlive()) {
                ++ret;
            }
        }
        return ret;
    }

    public void discard() {
        this.debug("Discard called.");
        this.available = false;
        this.theObject = null;
    }

    protected final void debug(String msg) {
        if (this.getLogger().isDebugEnabled()) {
            String classname = this.getClass().getName();
            String objectClassname = "n/a";
            if (this.theObject != null) {
                objectClassname = this.theObject.getClass().getName();
            }
            String tmsg = "Poolable=" + classname + ", oid=" + this.objectId + " in " + this.poolName + ", object=" + objectClassname + ":  " + msg;
            this.getLogger().debug(tmsg);
        }
    }

    public synchronized String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append(this.debugName());
        if (this.isCheckedOut()) {
            out.append(" is checked out");
        } else {
            out.append(" is not checked out");
        }
        out.append(" (o=" + this.checkouts + ", i=" + this.checkins + ")");
        if (this.maxAge > 0L) {
            out.append(" expires " + new Date(this.startTime + this.maxAge));
        }
        if (!this.isAvailable()) {
            out.append(" (not available)");
        }
        return out.toString();
    }
}

