/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import net.spy.SpyThread;

public abstract class LoopingThread
extends SpyThread {
    public static final int DEFAULT_MS_PER_LOOP = 5000;
    private volatile boolean keepGoing = true;
    private int msPerLoop = 5000;

    protected LoopingThread() {
    }

    protected LoopingThread(String name) {
        super(name);
    }

    protected LoopingThread(ThreadGroup tg, String name) {
        super(tg, name);
    }

    public void setMsPerLoop(int to) {
        this.msPerLoop = to;
    }

    public int getMsPerLoop() {
        return this.msPerLoop;
    }

    public synchronized void requestStop() {
        this.keepGoing = false;
        this.notifyAll();
    }

    protected abstract void runLoop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performDelay() {
        try {
            LoopingThread loopingThread = this;
            synchronized (loopingThread) {
                this.wait(this.getMsPerLoop());
            }
        }
        catch (InterruptedException e) {
            this.delayInterrupted(e);
        }
    }

    protected void delayInterrupted(InterruptedException e) {
        this.getLogger().warn((Object)"Somebody interrupted my sleep", e);
    }

    public void run() {
        this.startingUp();
        while (this.keepGoing) {
            this.runLoop();
            this.performDelay();
        }
        this.getLogger().info("Thread finishing.");
        this.shuttingDown();
    }

    protected void startingUp() {
    }

    protected void shuttingDown() {
    }
}

