/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.spy.SpyObject;
import net.spy.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDump
extends SpyObject {
    private Logger logger = this.getLogger();

    private void getAllFields(Class<?> c, Set<Field> s) throws Exception {
        Field[] fields;
        for (Field field : fields = c.getDeclaredFields()) {
            field.setAccessible(true);
            s.add(field);
        }
        if (c.getSuperclass() != null) {
            this.getAllFields(c.getSuperclass(), s);
        }
    }

    protected void reportExamining(String path, Object o) {
        this.logger.info("Examining %s - %s - %s", path, o.getClass(), o);
    }

    protected void reportPrimitive(String path, Object v) {
        this.logger.info("Primitive value for %s is %s", path, v);
    }

    protected void reportNull(String path) {
        this.logger.info(path + " is null");
    }

    protected void reportDuplicate(String path, String prevPath, Object o) {
        this.logger.info("Saw duplicate %s instance at %s previously seen at %s", o.getClass(), path, prevPath);
    }

    protected void reportException(String path, Object o, Exception e) {
        this.logger.info("Problem reading %s at %s - %s", o.getClass(), path, o, e);
    }

    private void dumpObject(Object o, String path, int depth, Map<Object, String> seen) {
        try {
            if (!seen.containsKey(o)) {
                seen.put(o, path);
                Class<?> c = o.getClass();
                this.reportExamining(path, o);
                HashSet<Field> fields = new HashSet<Field>();
                this.getAllFields(c, fields);
                for (Field field : fields) {
                    Class<?> fieldType = field.getType();
                    String fieldName = field.getName();
                    String thisPath = path + "." + fieldName;
                    if (fieldType.isPrimitive()) {
                        this.reportPrimitive(thisPath, field.get(o));
                        continue;
                    }
                    Object fieldValue = field.get(o);
                    if (fieldValue == null) {
                        this.reportNull(thisPath);
                        continue;
                    }
                    this.dumpObject(fieldValue, thisPath, depth + 1, seen);
                }
            } else {
                this.reportDuplicate(path, seen.get(o), o);
            }
        }
        catch (Exception e) {
            this.reportException(path, o, e);
        }
    }

    public void dumpObject(Object o) {
        if (o == null) {
            throw new NullPointerException("Cannot dump a null object.");
        }
        this.dumpObject(o, "o", 0, new IdentityHashMap<Object, String>());
    }
}

