/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeStampedHashMap<K, V>
extends HashMap<K, V> {
    private long timestamp = 0L;
    private long lastPut = 0L;
    private long lastGet = 0L;
    private long hits = 0L;
    private long misses = 0L;
    private long watermark = 0L;
    private long puts = 0L;

    public TimeStampedHashMap() {
        long now;
        this.timestamp = now = System.currentTimeMillis();
        this.lastPut = now;
        this.lastGet = now;
    }

    @Override
    public V get(Object key) {
        this.markGet();
        Object o = super.get(key);
        if (o == null) {
            ++this.misses;
        } else {
            ++this.hits;
        }
        return o;
    }

    @Override
    public V put(K key, V value) {
        V rv = super.put(key, value);
        this.markPut();
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markPut() {
        this.timestamp = this.lastPut = System.currentTimeMillis();
        ++this.puts;
        TimeStampedHashMap timeStampedHashMap = this;
        synchronized (timeStampedHashMap) {
            if ((long)this.size() > this.watermark) {
                this.watermark = this.size();
            }
        }
    }

    private void markGet() {
        this.timestamp = this.lastGet = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getLastGet() {
        return this.lastGet;
    }

    public long getLastPut() {
        return this.lastPut;
    }

    public long getPutAge() {
        long now = System.currentTimeMillis();
        return now - this.lastPut;
    }

    public long getGetAge() {
        long now = System.currentTimeMillis();
        return now - this.lastGet;
    }

    public long getUseAge() {
        long now = System.currentTimeMillis();
        return now - this.timestamp;
    }

    public long getHits() {
        return this.hits;
    }

    public long getMisses() {
        return this.misses;
    }

    public long getWatermark() {
        return this.watermark;
    }

    public long getNumPuts() {
        return this.puts;
    }
}

