/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.ujac.chart.Base2DScaleChart;
import org.ujac.chart.ChartException;

public class BarChart2D
extends Base2DScaleChart {
    public Rectangle2D draw(Rectangle2D viewport, Graphics2D graphics) throws ChartException {
        int barOffs;
        float yPos;
        int j;
        float curPos;
        int i;
        Rectangle2D localViewport = super.draw(viewport, graphics);
        if (this.model == null || this.model.getChartData() == null) {
            return localViewport;
        }
        Color[] segmentColors = this.attributes.getColorArray("segment-colors");
        List chartData = this.model.getChartData();
        int numSegments = chartData.size();
        Rectangle effectiveViewport = this.calcViewport(localViewport, graphics);
        this.drawScale(localViewport, effectiveViewport, graphics);
        this.drawLegend(localViewport, graphics);
        float horizontalScale = this.horizontalScale;
        float barsWidth = horizontalScale * 0.8f;
        float nullPos = this.calculateBaseLinePosition();
        double[] row = (double[])chartData.get(0);
        float barStep = barsWidth / (float)row.length;
        float barWidth = barStep * 0.8f;
        float barOffset = -(barsWidth / 2.0f) * 0.9f;
        int[] barOffsets = new int[row.length];
        for (int i2 = 0; i2 < barOffsets.length; ++i2) {
            barOffsets[i2] = (int)barOffset;
            barOffset += barStep;
        }
        int shadowOffsetX = (int)this.getShadowLength();
        int shadowOffsetY = shadowOffsetX;
        if (shadowOffsetY > 2) {
            --shadowOffsetY;
        }
        if (shadowOffsetX > 0) {
            graphics.setColor(this.getShadowColor());
            for (i = 0; i < numSegments; ++i) {
                row = (double[])chartData.get(i);
                curPos = this.horizontalPositions[i];
                for (j = 0; j < row.length; ++j) {
                    yPos = this.calculateVerticalPosition(row[j]);
                    barOffs = barOffsets[j];
                    if (yPos < nullPos) {
                        graphics.fill(new Rectangle2D.Float(curPos + (float)barOffs + (float)shadowOffsetX, yPos + (float)shadowOffsetY, barWidth, nullPos - yPos));
                        continue;
                    }
                    graphics.fill(new Rectangle2D.Float(curPos + (float)barOffs + (float)shadowOffsetX, nullPos + (float)shadowOffsetY, barWidth, yPos - nullPos));
                }
            }
        }
        for (i = 0; i < numSegments; ++i) {
            row = (double[])chartData.get(i);
            curPos = this.horizontalPositions[i];
            for (j = 0; j < row.length; ++j) {
                yPos = this.calculateVerticalPosition(row[j]);
                barOffs = barOffsets[j];
                graphics.setColor(segmentColors[j]);
                if (yPos < nullPos) {
                    graphics.fill(new Rectangle2D.Float(curPos + (float)barOffs, yPos, barWidth, nullPos - yPos));
                    continue;
                }
                graphics.fill(new Rectangle2D.Float(curPos + (float)barOffs, nullPos, barWidth, yPos - nullPos));
            }
        }
        return localViewport;
    }
}

