/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.List;
import java.util.StringTokenizer;
import org.ujac.chart.BaseChart;
import org.ujac.chart.TextChartItem;
import org.ujac.util.BeanUtils;

public abstract class Base2DScaleChart
extends BaseChart {
    public static final int SEGMENT_MARK_STYLE_CENTER = 1;
    public static final int SEGMENT_MARK_STYLE_BORDER = 2;
    public static final int DEFAULT_SEGMENT_MARK_STYLE = 2;
    public static final int ARROWHEAD_STYLE_OPEN = 1;
    public static final int ARROWHEAD_STYLE_FILLED = 2;
    public static final int DEFAULT_ARROWHEAD_STYLE = 1;
    public static final float DEFAULT_LINE_WIDTH = 1.0f;
    public static final float DEFAULT_SCALE_MARK_LENGTH = 6.0f;
    public static final float DEFAULT_SCALE_ARROWHEAD_LENGTH = 10.0f;
    public static final String DEFAULT_SCALE_ARROWHEAD_STYLE = "open";
    public static final Color DEFAULT_GRID_COLOR = Color.gray;
    public static final Color DEFAULT_GRID_BACKGROUND_COLOR = Color.lightGray;
    public static final float DEFAULT_DESCRIPTION_ITEM_SPACING = 1.5f;
    public static final float DEFAULT_DESCRIPTION_LINE_SPACING = 1.0f;
    protected Font scaleFont = null;
    protected Rectangle effectiveViewport = null;
    protected float verticalAnchor = 0.0f;
    protected float verticalMinimum = 0.0f;
    protected float verticalMaximum = 0.0f;
    protected float verticalZero = 0.0f;
    protected double max;
    protected double min;
    protected double range;
    protected float horizontalOffset = 0.0f;
    protected float horizontalScale = 0.0f;
    protected float verticalScale = 0.0f;
    protected float[] horizontalPositions = null;
    private float maxSegmentLabelHeight = 0.0f;
    private Rectangle2D[] segmentMetrics = null;
    private float maxAreaLabelLineHeight = 0.0f;
    private float maxAreaLabelHeight = 0.0f;
    private Rectangle2D legendMetrics = null;
    private Rectangle2D valueScaleDescriptionArea = null;
    private Rectangle2D segmentScaleDescriptionArea = null;

    public float getLineWidth() {
        if (this.attributes.isDefined("line-width")) {
            return this.attributes.getFloat("line-width");
        }
        return 1.0f;
    }

    public float getScaleMarkLength() {
        if (this.attributes.isDefined("scale-mark-length")) {
            return this.attributes.getFloat("scale-mark-length");
        }
        return 6.0f;
    }

    public float getValueStepSize(double descriptionHeight) {
        if (this.attributes.isDefined("value-step-size")) {
            return this.attributes.getFloat("value-step-size");
        }
        double valueRange = this.getMaxValue() - this.getMinValue();
        float stepSize = 1.0f;
        while (valueRange / (double)stepSize > 50.0) {
            stepSize *= 10.0f;
        }
        if (valueRange / (double)stepSize < 10.0 && stepSize > 1.0f && (double)(this.verticalScale * stepSize) >= 3.0 * descriptionHeight) {
            stepSize /= 2.0f;
        }
        if ((double)(this.verticalScale * stepSize) < 3.0 * descriptionHeight / 20.0) {
            stepSize *= 20.0f;
        } else if ((double)(this.verticalScale * stepSize) < 3.0 * descriptionHeight / 10.0) {
            stepSize *= 10.0f;
        } else if ((double)(this.verticalScale * stepSize) < 3.0 * descriptionHeight / 5.0) {
            stepSize *= 5.0f;
        } else if ((double)(this.verticalScale * stepSize) < 3.0 * descriptionHeight / 2.0) {
            stepSize *= 2.0f;
        }
        return stepSize;
    }

    public boolean isViewLegend() {
        if (!this.attributes.isDefined("view-legend")) {
            return true;
        }
        return this.attributes.getBoolean("view-legend");
    }

    public boolean isViewScaleArrows() {
        if (!this.attributes.isDefined("view-scale-arrows")) {
            return true;
        }
        return this.attributes.getBoolean("view-grid");
    }

    public float getScaleArrowheadLength() {
        if (this.attributes.isDefined("scale-arrowhead-length")) {
            return this.attributes.getFloat("scale-arrowhead-length");
        }
        return 10.0f;
    }

    public float getScaleArrowheadWidth() {
        if (this.attributes.isDefined("scale-arrowhead-width")) {
            return this.attributes.getFloat("scale-arrowhead-width");
        }
        return this.getScaleArrowheadLength() * 0.4f;
    }

    public int getScaleArrowheadStyle() {
        String style;
        if (this.attributes.isDefined("scale-arrowhead-style") && "filled".equals(style = this.attributes.getString("scale-arrowhead-style"))) {
            return 2;
        }
        return 1;
    }

    public NumberFormat getScaleValueFormat() {
        if (this.attributes.isDefined("scale-value-format")) {
            return (NumberFormat)this.attributes.getObject("scale-value-format");
        }
        if (this.attributes.isDefined("value-format")) {
            return (NumberFormat)this.attributes.getObject("value-format");
        }
        return this.defaultValueFormat;
    }

    public String formatScaleValue(double number, double stepSize) {
        NumberFormat format = this.defaultValueFormat;
        if (this.attributes.isDefined("scale-value-format")) {
            format = (NumberFormat)this.attributes.getObject("scale-value-format");
        } else if (this.attributes.isDefined("value-format")) {
            format = (NumberFormat)this.attributes.getObject("value-format");
        }
        if (stepSize >= 1000.0 && format == this.defaultValueFormat) {
            return format.format(number / 1000.0) + "K";
        }
        return format.format(number);
    }

    public int getSegmentMarkStyle() {
        if (this.attributes.isDefined("segment-mark-style")) {
            String style = this.attributes.getString("segment-mark-style");
            if ("border".equals(style)) {
                return 2;
            }
            return 1;
        }
        return 2;
    }

    public boolean isViewGrid() {
        if (!this.attributes.isDefined("view-grid")) {
            return true;
        }
        return this.attributes.getBoolean("view-grid");
    }

    public Color getGridColor() {
        if (this.attributes.isDefined("grid-color")) {
            return this.attributes.getColor("grid-color");
        }
        return DEFAULT_GRID_COLOR;
    }

    public Color getGridBackgroundColor() {
        if (this.attributes.isDefined("grid-bgcolor")) {
            return this.attributes.getColor("grid-bgcolor");
        }
        return DEFAULT_GRID_BACKGROUND_COLOR;
    }

    protected int getInnerPadding() {
        return 10;
    }

    protected TextChartItem getValueScaleDescription() {
        return this.attributes.getTextItem("value-scale-description");
    }

    protected TextChartItem getSegmentScaleDescription() {
        return this.attributes.getTextItem("segment-scale-description");
    }

    protected void drawScale(Rectangle2D viewport, Rectangle2D effectiveViewport, Graphics2D graphics) {
        TextChartItem segmentScaleDescription;
        Color scaleColor = this.getDescriptionColor();
        Color backgroundColor = this.getGridBackgroundColor();
        Color gridColor = this.getGridColor();
        float halfScaleLength = this.getScaleMarkLength() / 2.0f;
        float x = (float)effectiveViewport.getX();
        float width = (float)effectiveViewport.getWidth();
        float arrowHeadLength = this.getScaleArrowheadLength();
        float arrowHeadWidth = this.getScaleArrowheadWidth();
        int arrowHeadStyle = this.getScaleArrowheadStyle();
        int segmentMarkStyle = this.getSegmentMarkStyle();
        List chartData = this.model.getChartData();
        int numSegments = chartData.size();
        Font oldFont = graphics.getFont();
        Stroke oldStroke = graphics.getStroke();
        BasicStroke gridStroke = new BasicStroke(this.getDescriptionLineWidth() / 2.0f);
        BasicStroke scaleStroke = new BasicStroke(this.getDescriptionLineWidth(), 1, 1);
        graphics.setStroke(scaleStroke);
        String[] segmentLabels = this.getSegmentLabels();
        TextChartItem valueScaleDescription = this.getValueScaleDescription();
        if (valueScaleDescription != null) {
            valueScaleDescription.draw(this.valueScaleDescriptionArea, graphics);
        }
        if ((segmentScaleDescription = this.getSegmentScaleDescription()) != null) {
            segmentScaleDescription.draw(this.segmentScaleDescriptionArea, graphics);
        }
        Font segmentDescriptionFont = this.getDescriptionFont();
        segmentDescriptionFont = segmentDescriptionFont.deriveFont(AffineTransform.getRotateInstance(4.71238898038469));
        graphics.setFont(segmentDescriptionFont);
        Rectangle2D.Float segmentDescriptionArea = new Rectangle2D.Float(x, this.verticalMinimum + halfScaleLength, width, (int)this.maxSegmentLabelHeight);
        boolean viewGrid = this.isViewGrid();
        if (viewGrid) {
            graphics.setColor(backgroundColor);
            graphics.fill(new Rectangle2D.Float(x, this.verticalMaximum, width, this.verticalMinimum - this.verticalMaximum));
        }
        graphics.setColor(scaleColor);
        float vsMaxX = (float)(viewport.getX() + viewport.getWidth());
        float maxGridX = x + width;
        if (this.isViewScaleArrows()) {
            if (arrowHeadStyle == 2) {
                GeneralPath arrowPoly = new GeneralPath();
                arrowPoly.moveTo(vsMaxX - arrowHeadLength, this.verticalMinimum - arrowHeadWidth);
                arrowPoly.lineTo(vsMaxX, this.verticalMinimum);
                arrowPoly.lineTo(vsMaxX - arrowHeadLength, this.verticalMinimum + arrowHeadWidth);
                graphics.fill(arrowPoly);
                graphics.draw(arrowPoly);
            } else {
                graphics.draw(new Line2D.Float(vsMaxX - arrowHeadLength, this.verticalMinimum - arrowHeadWidth, vsMaxX, this.verticalMinimum));
                graphics.draw(new Line2D.Float(vsMaxX - arrowHeadLength, this.verticalMinimum + arrowHeadWidth, vsMaxX, this.verticalMinimum));
            }
            graphics.draw(new Line2D.Float(x, this.verticalMinimum, vsMaxX, this.verticalMinimum));
        } else {
            graphics.draw(new Line2D.Float(x, this.verticalMinimum, maxGridX, this.verticalMinimum));
        }
        int vsMinY = (int)viewport.getY();
        if (this.isViewScaleArrows()) {
            graphics.draw(new Line2D.Float(x, vsMinY, x, this.verticalMinimum));
            if (arrowHeadStyle == 2) {
                GeneralPath arrowPoly = new GeneralPath();
                arrowPoly.moveTo(x - arrowHeadWidth, (float)vsMinY + arrowHeadLength);
                arrowPoly.lineTo(x, vsMinY);
                arrowPoly.lineTo(x + arrowHeadWidth, (float)vsMinY + arrowHeadLength);
                graphics.fill(arrowPoly);
                graphics.draw(arrowPoly);
            } else {
                graphics.draw(new Line2D.Float(x, vsMinY, x - arrowHeadWidth, (float)vsMinY + arrowHeadLength));
                graphics.draw(new Line2D.Float(x, vsMinY, x + arrowHeadWidth, (float)vsMinY + arrowHeadLength));
            }
        } else {
            graphics.draw(new Line2D.Float(x, this.verticalMaximum, x, this.verticalMinimum));
        }
        this.horizontalPositions = new float[numSegments];
        float hScaleYfrom = this.verticalMinimum - halfScaleLength;
        float hScaleYto = this.verticalMinimum + halfScaleLength;
        float halfHorizontalScale = this.horizontalScale / 2.0f;
        float lastPos = this.horizontalOffset + halfHorizontalScale;
        double segXPos = 0.0;
        switch (segmentMarkStyle) {
            case 2: {
                segXPos = (int)effectiveViewport.getMinX();
                break;
            }
            case 1: {
                segXPos = (int)lastPos;
                break;
            }
            default: {
                segXPos = (int)lastPos;
            }
        }
        graphics.setFont(segmentDescriptionFont);
        for (int i = 0; i < numSegments; ++i) {
            String segmentLabel = null;
            if (segmentLabels != null && i < segmentLabels.length) {
                segmentLabel = segmentLabels[i];
            }
            int xPos = (int)lastPos;
            int xSegPos = (int)segXPos;
            this.horizontalPositions[i] = xPos;
            if (BeanUtils.isEmpty(segmentLabel)) {
                lastPos += this.horizontalScale;
                segXPos += (double)this.horizontalScale;
                continue;
            }
            if (viewGrid && (i > 0 || segmentMarkStyle != 2)) {
                graphics.setStroke(gridStroke);
                graphics.setColor(gridColor);
                graphics.draw(new Line2D.Float(xSegPos, this.verticalMinimum, xSegPos, this.verticalMaximum));
            }
            graphics.setStroke(scaleStroke);
            graphics.setColor(scaleColor);
            graphics.draw(new Line2D.Float(xSegPos, hScaleYfrom, xSegPos, hScaleYto));
            lastPos += this.horizontalScale;
            segXPos += (double)this.horizontalScale;
            Rectangle2D segmentMetric = this.segmentMetrics[i];
            graphics.drawString(segmentLabel, (float)((double)xPos + segmentMetric.getHeight() / 3.0), (float)(segmentDescriptionArea.getMinY() + segmentMetric.getWidth() + (double)(halfScaleLength * 2.0f)));
        }
        if (segmentMarkStyle == 2) {
            int xSegPos = (int)segXPos;
            if (viewGrid) {
                graphics.setStroke(gridStroke);
                graphics.setColor(gridColor);
                graphics.draw(new Line2D.Float(xSegPos, this.verticalMinimum, xSegPos, this.verticalMaximum));
            }
            graphics.setStroke(scaleStroke);
            graphics.setColor(scaleColor);
            graphics.draw(new Line2D.Float(xSegPos, hScaleYfrom, xSegPos, hScaleYto));
        }
        segmentDescriptionFont = this.getDescriptionFont();
        graphics.setFont(segmentDescriptionFont);
        FontMetrics fm = graphics.getFontMetrics();
        double descriptionHeight = fm.getStringBounds("1", graphics).getHeight();
        float stepSize = this.getValueStepSize(descriptionHeight);
        double maxValue = this.getMaxValue();
        double minValue = this.getMinValue();
        float base = (float)minValue;
        if (base < 0.0f) {
            base = 0.0f;
        }
        float xPos = (int)effectiveViewport.getMinX();
        float yPos = this.calculateVerticalPosition(0.0);
        float vScaleXfrom = xPos - halfScaleLength;
        float vScaleXto = xPos + halfScaleLength;
        graphics.setColor(scaleColor);
        graphics.draw(new Line2D.Float(vScaleXfrom, yPos, vScaleXto, yPos));
        String strValue = null;
        Rectangle2D textMetrics = null;
        float value = base;
        while ((double)value <= maxValue) {
            yPos = this.calculateVerticalPosition(value);
            if (viewGrid) {
                graphics.setStroke(gridStroke);
                graphics.setColor(gridColor);
                if (value != base) {
                    graphics.draw(new Line2D.Float(x, yPos, maxGridX, yPos));
                }
            }
            graphics.setStroke(scaleStroke);
            graphics.setColor(scaleColor);
            graphics.draw(new Line2D.Float(vScaleXfrom, yPos, vScaleXto, yPos));
            strValue = this.formatScaleValue(value, stepSize);
            textMetrics = fm.getStringBounds(strValue, graphics);
            graphics.drawString(strValue, (float)((double)(xPos - halfScaleLength * 2.0f) - textMetrics.getWidth()), (float)((double)yPos + textMetrics.getHeight() / 3.0));
            value += stepSize;
        }
        value = -stepSize;
        while ((double)value >= minValue) {
            yPos = this.calculateVerticalPosition(value);
            if (viewGrid) {
                graphics.setStroke(gridStroke);
                graphics.setColor(gridColor);
                graphics.draw(new Line2D.Float(x, yPos, maxGridX, yPos));
            }
            graphics.setStroke(scaleStroke);
            graphics.setColor(scaleColor);
            graphics.draw(new Line2D.Float(vScaleXfrom, yPos, vScaleXto, yPos));
            strValue = this.formatScaleValue(value, stepSize);
            textMetrics = fm.getStringBounds(strValue, graphics);
            graphics.drawString(strValue, (float)((double)(xPos - halfScaleLength * 2.0f) - textMetrics.getWidth()), (float)((double)yPos + textMetrics.getHeight() / 3.0));
            value -= stepSize;
        }
        graphics.setStroke(oldStroke);
        graphics.setFont(oldFont);
    }

    protected void drawLegend(Rectangle2D viewport, Graphics2D graphics) {
        int padding = this.getInnerPadding();
        if (this.isViewLegend()) {
            Font oldFont = graphics.getFont();
            Stroke oldStroke = graphics.getStroke();
            graphics.setStroke(new BasicStroke(this.getDescriptionLineWidth(), 1, 1));
            double labelBoxSize = (double)this.maxAreaLabelLineHeight * 0.75;
            double labelBoxXPos = this.legendMetrics.getMinX() + (double)padding;
            double labelXPos = labelBoxXPos + labelBoxSize * 2.0;
            double labelYPos = this.legendMetrics.getMinY();
            Color[] segmentColors = this.attributes.getColorArray("segment-colors");
            Font segmentDescriptionFont = this.getDescriptionFont();
            graphics.setFont(segmentDescriptionFont);
            String[] areaLabels = this.getAreaLabels();
            for (int i = 0; i < areaLabels.length; ++i) {
                String label = areaLabels[i];
                Color oldColor = graphics.getColor();
                graphics.setColor(segmentColors[i]);
                graphics.fillRect((int)labelBoxXPos, (int)((labelYPos += (double)this.maxAreaLabelLineHeight * 1.5) - labelBoxSize), (int)labelBoxSize, (int)labelBoxSize);
                graphics.setColor(oldColor);
                graphics.drawRect((int)labelBoxXPos, (int)(labelYPos - labelBoxSize), (int)labelBoxSize, (int)labelBoxSize);
                boolean firstLine = true;
                StringTokenizer tkn = new StringTokenizer(label, "\r\n");
                while (tkn.hasMoreTokens()) {
                    String ll = tkn.nextToken();
                    if (!firstLine) {
                        labelYPos += (double)(this.maxAreaLabelLineHeight * 1.0f);
                    }
                    graphics.drawString(ll, (float)labelXPos, (float)labelYPos);
                    firstLine = false;
                }
            }
            graphics.draw(this.legendMetrics);
            graphics.setFont(oldFont);
            graphics.setStroke(oldStroke);
        }
    }

    protected Rectangle calcViewport(Rectangle2D viewport, Graphics2D graphics) {
        String label;
        int padding = this.getInnerPadding();
        int x = (int)(viewport.getX() + (double)padding);
        int y = (int)(viewport.getY() + (double)padding);
        int width = (int)viewport.getWidth() - padding * 2;
        int height = (int)viewport.getHeight() - padding * 2;
        if (this.model == null || this.model.getChartData() == null) {
            this.effectiveViewport = new Rectangle(x, y, width, height);
            return this.effectiveViewport;
        }
        TextChartItem title = this.model.getTitle();
        double topSpace = 0.0;
        if (title != null) {
            Rectangle2D titleArea = title.getOutputArea(viewport, graphics);
            topSpace = (int)titleArea.getMaxY();
        }
        List chartData = this.model.getChartData();
        int numSegments = chartData.size();
        this.min = this.getMinValue();
        if (this.min < 0.0) {
            this.min -= 5.0;
        }
        this.max = this.getMaxValue() * 1.05;
        this.range = this.max - this.min;
        Font oldFont = graphics.getFont();
        Font segmentDescriptionFont = this.getDescriptionFont();
        graphics.setFont(segmentDescriptionFont);
        FontMetrics fm = graphics.getFontMetrics();
        double descriptionHeight = fm.getStringBounds("1", graphics).getHeight();
        float stepSize = this.getValueStepSize(descriptionHeight);
        String maxValue = this.formatScaleValue(this.getMaxValue(), stepSize);
        String minValue = this.formatScaleValue(this.getMinValue(), stepSize);
        Rectangle2D maxValueMetrics = null;
        maxValueMetrics = maxValue.length() > minValue.length() ? fm.getStringBounds(maxValue, graphics) : fm.getStringBounds(minValue, graphics);
        double maxValueLabelWidth = maxValueMetrics.getMaxX();
        TextChartItem valueScaleDescription = this.getValueScaleDescription();
        int valueScaleDescriptionVerticalPositionMode = -1;
        if (valueScaleDescription != null) {
            double maxWidth = valueScaleDescription.getMaxWidth();
            this.valueScaleDescriptionArea = valueScaleDescription.getOutputArea(new Rectangle(padding, padding, (int)maxWidth, (int)(viewport.getHeight() - (double)(padding * 2))), graphics);
            valueScaleDescriptionVerticalPositionMode = valueScaleDescription.getPosition().getVerticalPositionMode();
            if (valueScaleDescriptionVerticalPositionMode == 5) {
                maxValueLabelWidth = maxValueLabelWidth + this.valueScaleDescriptionArea.getWidth() + (double)((float)padding / 2.0f);
            } else {
                topSpace = Math.max(topSpace, this.valueScaleDescriptionArea.getHeight());
                maxValueLabelWidth = Math.max(maxValueLabelWidth, this.valueScaleDescriptionArea.getWidth());
            }
        }
        y = (int)((double)y + topSpace);
        this.effectiveViewport = new Rectangle(x, y, width, height -= (int)topSpace);
        width -= (int)(maxValueLabelWidth + (double)padding);
        x += (int)(maxValueLabelWidth + (double)padding);
        float rightDescriptionSpace = 0.0f;
        float legendHeight = padding;
        if (this.isViewLegend()) {
            this.maxAreaLabelHeight = 0.0f;
            float areaLabelWidth = 0.0f;
            String[] areaLabels = this.getAreaLabels();
            for (int i = 0; i < areaLabels.length; ++i) {
                label = areaLabels[i];
                StringTokenizer tkn = new StringTokenizer(label, "\r\n");
                float labelHeight = 0.0f;
                while (tkn.hasMoreTokens()) {
                    String ll = tkn.nextToken();
                    Rectangle2D textMetrics = fm.getStringBounds(ll, graphics);
                    labelHeight = (double)labelHeight > 0.0 ? (float)((double)labelHeight + textMetrics.getHeight() * 1.0) : (float)((double)labelHeight + textMetrics.getHeight() * 1.5);
                    areaLabelWidth = Math.max(areaLabelWidth, (float)textMetrics.getWidth());
                    this.maxAreaLabelLineHeight = Math.max(this.maxAreaLabelLineHeight, (float)textMetrics.getHeight());
                    this.maxAreaLabelHeight = Math.max(this.maxAreaLabelHeight, labelHeight);
                }
                legendHeight += labelHeight;
            }
            areaLabelWidth = (float)((double)areaLabelWidth + ((double)this.maxAreaLabelLineHeight * 1.5 + (double)(padding * 2)));
            this.legendMetrics = new Rectangle((int)((float)(x + width) - (areaLabelWidth + (float)padding * 2.0f) + (float)padding), y + padding, (int)areaLabelWidth, (int)legendHeight);
            rightDescriptionSpace = areaLabelWidth;
        }
        float segmentScaleDescriptionHeight = 0.0f;
        TextChartItem segmentScaleDescription = this.getSegmentScaleDescription();
        if (segmentScaleDescription != null) {
            double maxWidth = segmentScaleDescription.getMaxWidth();
            this.segmentScaleDescriptionArea = segmentScaleDescription.getOutputArea(new Rectangle(padding, padding, (int)maxWidth, (int)(viewport.getHeight() / 2.0 - (double)(padding * 2))), graphics);
            if (segmentScaleDescription.getPosition().getHorizontalPositionMode() == 2) {
                segmentScaleDescriptionHeight = (float)this.segmentScaleDescriptionArea.getHeight() + (float)padding;
            } else {
                this.maxSegmentLabelHeight = Math.max(this.maxSegmentLabelHeight, (float)this.segmentScaleDescriptionArea.getHeight());
                rightDescriptionSpace = Math.max(rightDescriptionSpace, (float)this.segmentScaleDescriptionArea.getWidth());
            }
        }
        width = (int)((float)width - (rightDescriptionSpace + (float)padding * 2.0f));
        this.effectiveViewport = new Rectangle(x, y, width, height);
        String[] segmentLabels = this.getSegmentLabels();
        this.maxSegmentLabelHeight = 0.0f;
        this.segmentMetrics = new Rectangle2D[numSegments];
        this.horizontalScale = (float)(this.effectiveViewport.getWidth() / (double)this.model.getChartData().size());
        this.horizontalOffset = (float)this.effectiveViewport.getX();
        if (segmentLabels != null) {
            label = null;
            for (int i = 0; i < numSegments; ++i) {
                Rectangle2D textMetrics;
                if (i >= segmentLabels.length || (label = segmentLabels[i]) == null) continue;
                this.segmentMetrics[i] = textMetrics = fm.getStringBounds(label, graphics);
                this.maxSegmentLabelHeight = Math.max(this.maxSegmentLabelHeight, (float)textMetrics.getWidth());
            }
        }
        double vertDescriptionDelta = this.maxSegmentLabelHeight + segmentScaleDescriptionHeight;
        this.verticalScale = (float)((this.effectiveViewport.getHeight() - vertDescriptionDelta) / this.range);
        this.verticalAnchor = (int)(viewport.getMaxY() - (double)(padding * 2));
        this.verticalZero = this.calculateVerticalPosition(0.0);
        if (vertDescriptionDelta > 0.0) {
            this.verticalAnchor = (float)((double)this.verticalAnchor - vertDescriptionDelta);
            this.verticalZero = this.calculateVerticalPosition(0.0);
        }
        this.verticalScale = (float)(((double)this.verticalZero - this.effectiveViewport.getY() - (double)padding) / this.max);
        this.horizontalPositions = new float[numSegments];
        float lastPos = this.horizontalOffset + this.horizontalScale / 2.0f;
        graphics.setFont(segmentDescriptionFont);
        for (int i = 0; i < numSegments; ++i) {
            int xPos = (int)lastPos;
            this.horizontalPositions[i] = xPos;
            lastPos += this.horizontalScale;
        }
        this.verticalMinimum = this.verticalAnchor;
        this.verticalMaximum = this.calculateVerticalPosition(this.max);
        if (this.min < 0.0) {
            this.verticalMinimum = this.calculateVerticalPosition(this.min);
        }
        this.verticalZero = this.calculateVerticalPosition(0.0);
        if (this.segmentScaleDescriptionArea != null) {
            this.segmentScaleDescriptionArea = segmentScaleDescription.getPosition().getHorizontalPositionMode() == 2 ? new Rectangle((int)this.effectiveViewport.getMinX(), (int)(this.verticalZero + this.maxSegmentLabelHeight + (float)padding), (int)(this.effectiveViewport.getMaxX() - this.effectiveViewport.getMinX()), (int)this.segmentScaleDescriptionArea.getHeight()) : new Rectangle((int)(this.effectiveViewport.getMaxX() + (double)padding), (int)(this.verticalZero + (float)padding), (int)(viewport.getMaxX() - (double)padding * 2.0 - this.effectiveViewport.getMaxX()), (int)this.maxSegmentLabelHeight);
            segmentScaleDescription.alignItem(this.segmentScaleDescriptionArea);
        }
        if (this.valueScaleDescriptionArea != null) {
            this.valueScaleDescriptionArea = valueScaleDescriptionVerticalPositionMode == 5 ? new Rectangle((int)(viewport.getX() + (double)padding), (int)this.verticalMinimum, (int)maxValueLabelWidth, (int)(this.verticalMaximum - this.verticalMinimum)) : new Rectangle((int)(viewport.getX() + (double)padding), (int)(viewport.getY() + (double)padding), (int)maxValueLabelWidth, (int)topSpace);
            valueScaleDescription.alignItem(this.valueScaleDescriptionArea);
        }
        graphics.setFont(oldFont);
        return this.effectiveViewport;
    }

    protected float calculateVerticalPosition(double value) {
        return this.verticalAnchor - this.calculateVerticalExtent(value);
    }

    protected float calculateVerticalExtent(double value) {
        return (float)((value - this.min) * (double)this.verticalScale);
    }

    protected float calculateBaseLinePosition() {
        double nn = 0.0;
        if (this.model.getMinValue() > 0.0) {
            nn = this.model.getMinValue();
        }
        return this.calculateVerticalPosition(nn);
    }
}

