/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.util.List;
import org.ujac.chart.Base2DScaleChart;
import org.ujac.chart.ChartException;
import org.ujac.chart.ChartModel;

public class Base2DStackedChart
extends Base2DScaleChart {
    private double minValue = 0.0;
    private double maxValue = 0.0;

    public void setModel(ChartModel model) throws ChartException {
        super.setModel(model);
        this.updateMinMaxValues();
    }

    public boolean supportsNegativeValues() {
        return false;
    }

    private void updateMinMaxValues() {
        if (this.model == null) {
            return;
        }
        List chartData = this.model.getChartData();
        int numSegments = chartData.size();
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < numSegments; ++i) {
            double[] row = (double[])chartData.get(i);
            double areaSum = 0.0;
            for (int j = 0; j < row.length; ++j) {
                areaSum += row[j];
            }
            min = Math.min(min, areaSum);
            max = Math.max(max, areaSum);
        }
        this.minValue = min;
        this.maxValue = max;
    }

    protected double getMinValue() {
        return this.minValue;
    }

    protected double getMaxValue() {
        return this.maxValue;
    }
}

