/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ujac.chart.BaseChart;
import org.ujac.chart.ChartException;
import org.ujac.chart.ChartItemPosition;
import org.ujac.chart.DescriptionPattern;
import org.ujac.chart.PieChartDescriptionItem;

public abstract class BasePieChart
extends BaseChart {
    public static final String DEFAULT_DESCRIPTION_PATTERN = "%d (%v, %p)";
    public static final int PIE_DESCRIPTION_LAYOUT_BORDER = 1;
    public static final int PIE_DESCRIPTION_LAYOUT_ROUND = 2;
    public static final int DEFAULT_PIE_DESCRIPTION_LAYOUT = 2;
    public static final float DEFAULT_PIE_DESCRIPTION_ANCHOR_RATIO = 1.15f;
    public static final float DEFAULT_PIE_DESCRIPTION_BASELINE_RATIO = 2.2f;
    private Point pieCenter = null;
    private Dimension pieSize = null;
    protected double halfPieWidth = 0.0;
    protected double halfPieHeight = 0.0;
    protected double[] percentages = null;
    protected double[] startAngles = null;
    protected double[] endAngles = null;
    protected double[] angleDiffs = null;
    protected double[] startArcs = null;
    protected double[] endArcs = null;
    protected AffineTransform moveToCenter = null;
    protected AffineTransform moveDescriptionLine = null;
    protected Line2D.Double[] descriptionLines = null;

    public boolean supportsNegativeValues() {
        return false;
    }

    public int getPieDescriptionLayout() {
        String strLayout;
        if (this.attributes.isDefined("pie-description-layout") && "BORDER".equals(strLayout = (String)this.attributes.getObject("pie-description-layout"))) {
            return 1;
        }
        return 2;
    }

    public float getPieDescriptionAnchorRatio() {
        if (this.attributes.isDefined("pie-description-anchor-ratio")) {
            return this.attributes.getFloat("pie-description-anchor-ratio");
        }
        return 1.15f;
    }

    public float getPieDescriptionBaselineRatio() {
        if (this.attributes.isDefined("pie-description-baseline-ratio")) {
            return this.attributes.getFloat("pie-description-baseline-ratio");
        }
        return 2.2f;
    }

    protected Point getPieCenter() {
        return this.pieCenter;
    }

    protected Dimension getPieSize() {
        return this.pieSize;
    }

    protected double getDeltaY() {
        return 1.0;
    }

    protected int getSliceHeight() {
        return 0;
    }

    public Rectangle2D draw(Rectangle2D viewport, Graphics2D graphics) throws ChartException {
        Rectangle2D localViewport = super.draw(viewport, graphics);
        if (this.model == null || this.model.getChartData() == null) {
            return localViewport;
        }
        List chartData = this.model.getChartData();
        int numSegments = chartData.size();
        double sum = 0.0;
        for (int i = 0; i < numSegments; ++i) {
            double[] row = (double[])chartData.get(i);
            double value = row[0];
            sum += value;
        }
        this.pieCenter = new Point((int)(localViewport.getX() + localViewport.getWidth() / 2.0), (int)(localViewport.getY() + localViewport.getHeight() / 2.0));
        double pieSize = localViewport.getHeight() * 0.6;
        int pieHeight = (int)(pieSize * this.getDeltaY());
        int pieWidth = (int)pieSize;
        this.pieSize = new Dimension(pieWidth, pieHeight);
        double maxArc = 360.0;
        this.init(numSegments);
        Color[] segmentColors = this.attributes.getColorArray("segment-colors");
        Color[] sliceColors = new Color[numSegments];
        double lastArc = 0.0;
        int nextColorIdx = 0;
        for (int i = 0; i < numSegments; ++i) {
            Color color;
            double[] row = (double[])chartData.get(i);
            double value = row[0];
            double percentage = value / sum;
            this.percentages[i] = percentage * 100.0;
            double arc = percentage * maxArc;
            sliceColors[i] = color = segmentColors[nextColorIdx];
            if (++nextColorIdx >= segmentColors.length) {
                nextColorIdx = 0;
            }
            this.calculateSliceMetrics(i, lastArc, lastArc + arc);
            lastArc += arc;
        }
        int shadowOffsetX = (int)this.getShadowLength();
        int shadowOffsetY = shadowOffsetX + 1;
        Stroke oldStroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(0.125f, 1, 1));
        int numDrawingSteps = this.getNumDrawingSteps();
        if (shadowOffsetX > 0) {
            AffineTransform moveToCenterOld = this.moveToCenter;
            this.moveToCenter = new AffineTransform();
            this.moveToCenter.translate(this.pieCenter.getX() + (double)shadowOffsetX, this.pieCenter.getY() + (double)shadowOffsetY);
            Color shadowColor = this.getShadowColor();
            for (int i = 0; i < numSegments; ++i) {
                this.drawSliceShadow(graphics, shadowColor, i);
            }
            this.moveToCenter = moveToCenterOld;
        }
        for (int j = 0; j < numDrawingSteps; ++j) {
            if (j == this.getDescriptionDrawingStep()) {
                this.drawDescription(localViewport, graphics);
            }
            for (int i = 0; i < numSegments; ++i) {
                this.drawSlice(graphics, sliceColors[i], i, j);
            }
        }
        graphics.setStroke(oldStroke);
        return localViewport;
    }

    protected void init(int numSegments) {
        Dimension pieSize = this.getPieSize();
        this.halfPieWidth = pieSize.getWidth() / 2.0;
        this.halfPieHeight = pieSize.getHeight() / 2.0;
        this.percentages = new double[numSegments];
        this.startAngles = new double[numSegments];
        this.endAngles = new double[numSegments];
        this.angleDiffs = new double[numSegments];
        this.startArcs = new double[numSegments];
        this.endArcs = new double[numSegments];
        this.descriptionLines = new Line2D.Double[numSegments];
        this.moveToCenter = new AffineTransform();
        this.moveToCenter.translate(this.pieCenter.getX(), this.pieCenter.getY());
        this.moveDescriptionLine = new AffineTransform();
        this.moveDescriptionLine.translate(this.pieCenter.getX(), this.pieCenter.getY() + (double)this.getSliceHeight() / 2.0);
    }

    protected void calculateSliceMetrics(int sliceIdx, double startAngle, double endAngle) {
        double angleDiff;
        this.startAngles[sliceIdx] = startAngle;
        this.endAngles[sliceIdx] = endAngle;
        this.angleDiffs[sliceIdx] = angleDiff = endAngle - startAngle;
        this.startArcs[sliceIdx] = Math.PI * (startAngle + 90.0) / 180.0;
        this.endArcs[sliceIdx] = Math.PI * (endAngle + 90.0) / 180.0;
        double sliceCenterArc = Math.PI * (startAngle + angleDiff / 2.0 + 90.0) / 180.0;
        AffineTransform rotate = new AffineTransform();
        rotate.rotate(-sliceCenterArc);
        Line2D.Double startLine = new Line2D.Double(0.0, this.halfPieHeight, 0.0, this.halfPieHeight * 1.25);
        PathIterator pIterLine = startLine.getPathIterator(rotate);
        double[] lineStart = new double[2];
        double[] lineEnd = new double[2];
        pIterLine.currentSegment(lineStart);
        pIterLine.next();
        pIterLine.currentSegment(lineEnd);
        double deltaY = this.getDeltaY();
        lineStart[0] = lineStart[0] / deltaY;
        lineEnd[0] = lineEnd[0] / deltaY;
        this.moveDescriptionLine.transform(lineStart, 0, lineStart, 0, 1);
        this.moveDescriptionLine.transform(lineEnd, 0, lineEnd, 0, 1);
        this.descriptionLines[sliceIdx] = new Line2D.Double(lineStart[0], lineStart[1], lineEnd[0], lineEnd[1]);
    }

    protected abstract int getNumDrawingSteps();

    protected int getDescriptionDrawingStep() {
        return 0;
    }

    protected abstract void drawSlice(Graphics2D var1, Color var2, int var3, int var4);

    protected abstract void drawSliceShadow(Graphics2D var1, Color var2, int var3);

    public void drawDescription(Rectangle2D viewport, Graphics2D graphics) throws ChartException {
        int maxWidthLeft;
        float pieDescriptionAnchorRatio = this.getPieDescriptionAnchorRatio();
        double pieDescriptionBaselineRatio = this.getPieDescriptionBaselineRatio();
        graphics.setColor(this.getDescriptionColor());
        Stroke oldStroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(this.getDescriptionLineWidth(), 1, 1));
        for (int i = 0; i < this.descriptionLines.length; ++i) {
            graphics.draw(this.descriptionLines[i]);
        }
        Font descriptionFont = this.getDescriptionFont();
        String[] segmentLabels = this.getSegmentLabels();
        LineMetrics lm = descriptionFont.getLineMetrics("XYZ", graphics.getFontRenderContext());
        float lineHeight = lm.getHeight();
        float halfLineHeight = lineHeight / 2.0f;
        ArrayList<PieChartDescriptionItem> leftItems = new ArrayList<PieChartDescriptionItem>();
        ArrayList<PieChartDescriptionItem> rightItems = new ArrayList<PieChartDescriptionItem>();
        double centerX = this.getPieCenter().getX();
        double centerY = this.getPieCenter().getY();
        List chartData = this.model.getChartData();
        NumberFormat valueFormat = this.getValueFormat();
        NumberFormat percentFormat = this.getPercentFormat();
        String patternText = this.getDescriptionPattern();
        double pieSizePlusPadding = this.halfPieHeight * (double)pieDescriptionAnchorRatio / this.getDeltaY();
        int maxWidthRight = maxWidthLeft = (int)(centerX - pieSizePlusPadding - viewport.getMinX() - (double)halfLineHeight - (double)this.getLeftPadding());
        DescriptionPattern descriptionPattern = new DescriptionPattern(patternText, valueFormat, percentFormat);
        for (int i = 0; i < this.descriptionLines.length; ++i) {
            double percent = this.percentages[i];
            double value = ((double[])chartData.get(i))[0];
            String segmentLabel = null;
            if (segmentLabels != null && i < segmentLabels.length) {
                segmentLabel = segmentLabels[i];
            }
            String itemText = descriptionPattern.apply(value, percent, segmentLabel, null);
            Line2D.Double line = this.descriptionLines[i];
            PieChartDescriptionItem item = null;
            if (line.getX2() >= centerX) {
                item = new PieChartDescriptionItem(i, new ChartItemPosition(3, line.getY2()), maxWidthLeft, 3, itemText, descriptionFont);
                rightItems.add(item);
            } else {
                item = new PieChartDescriptionItem(i, new ChartItemPosition(1, line.getY2()), maxWidthRight, 1, itemText, descriptionFont);
                leftItems.add(item);
            }
            item.move(0.0, -item.getOutputArea(viewport, graphics).getHeight() / 2.0 - viewport.getMinY());
        }
        int numLeftItems = leftItems.size();
        int numRightItems = rightItems.size();
        Collections.sort(leftItems);
        Collections.sort(rightItems);
        boolean maxIterations = true;
        boolean numIterations = false;
        boolean adjustmentRequired = true;
        while (adjustmentRequired) {
            adjustmentRequired = false;
            if (numIterations > maxIterations) break;
            this.adjustDescriptionItems(viewport, graphics, leftItems, centerY);
            this.adjustDescriptionItems(viewport, graphics, rightItems, centerY);
        }
        double leftBorder = viewport.getMinX() + (double)this.getLeftPadding();
        double rightBorder = viewport.getMaxX() - (double)this.getRightPadding();
        if (this.getPieDescriptionLayout() == 2) {
            double x;
            double y;
            ChartItemPosition itemPos;
            double deltaX;
            Line2D.Double line;
            int itemIdx;
            PieChartDescriptionItem item;
            int i;
            for (i = 0; i < numLeftItems; ++i) {
                item = (PieChartDescriptionItem)leftItems.get(i);
                itemIdx = item.getItemIdx();
                line = this.descriptionLines[itemIdx];
                deltaX = Math.abs(centerX - line.x2);
                itemPos = item.getPosition();
                itemPos.setHorizontalPositionMode((short)0);
                y = itemPos.getY();
                x = deltaX *= pieDescriptionBaselineRatio;
                x = centerX - x - (double)maxWidthLeft;
                if (x < leftBorder) {
                    x = leftBorder;
                }
                item.moveTo(x, y);
                item.resetMetrics();
                item.draw(viewport, graphics);
                Rectangle2D itemBox = item.getOutputArea(viewport, graphics);
                graphics.draw(new Line2D.Double(this.descriptionLines[item.getItemIdx()].getP2(), new Point2D.Double(itemBox.getMaxX() + (double)halfLineHeight, itemBox.getCenterY())));
            }
            for (i = 0; i < numRightItems; ++i) {
                item = (PieChartDescriptionItem)rightItems.get(i);
                itemIdx = item.getItemIdx();
                line = this.descriptionLines[itemIdx];
                deltaX = Math.abs(centerX - line.x2);
                itemPos = item.getPosition();
                itemPos.setHorizontalPositionMode((short)0);
                y = itemPos.getY();
                x = deltaX *= pieDescriptionBaselineRatio;
                double width = item.getWidth(viewport, graphics);
                x += centerX;
                if (x + width > rightBorder) {
                    x = rightBorder - width;
                }
                item.moveTo(x, y);
                item.resetMetrics();
                item.draw(viewport, graphics);
                Rectangle2D itemBox = item.getOutputArea(viewport, graphics);
                graphics.draw(new Line2D.Double(this.descriptionLines[item.getItemIdx()].getP2(), new Point2D.Double(itemBox.getX() - (double)halfLineHeight, itemBox.getCenterY())));
            }
        } else {
            Rectangle2D itemBox;
            PieChartDescriptionItem item;
            int i;
            for (i = 0; i < numLeftItems; ++i) {
                item = (PieChartDescriptionItem)leftItems.get(i);
                item.resetMetrics();
                item.draw(viewport, graphics);
                itemBox = item.getOutputArea(viewport, graphics);
                graphics.draw(new Line2D.Double(this.descriptionLines[item.getItemIdx()].getP2(), new Point2D.Double(itemBox.getMaxX() + (double)halfLineHeight, itemBox.getCenterY())));
            }
            for (i = 0; i < numRightItems; ++i) {
                item = (PieChartDescriptionItem)rightItems.get(i);
                item.resetMetrics();
                item.draw(viewport, graphics);
                itemBox = item.getOutputArea(viewport, graphics);
                graphics.draw(new Line2D.Double(this.descriptionLines[item.getItemIdx()].getP2(), new Point2D.Double(itemBox.getX() - (double)halfLineHeight, itemBox.getCenterY())));
            }
        }
        graphics.setStroke(oldStroke);
    }

    private void adjustDescriptionItems(Rectangle2D viewport, Graphics2D graphics, List items, double centerY) {
        PieChartDescriptionItem item;
        ChartItemPosition nextPos;
        PieChartDescriptionItem nextItem;
        PieChartDescriptionItem item2;
        ChartItemPosition itemPos;
        int numItems = items.size();
        int lastItemIdx = 0;
        if (numItems < 1) {
            return;
        }
        int i = 0;
        while (i < numItems && !((itemPos = (item2 = (PieChartDescriptionItem)items.get(i)).getPosition()).getY() > centerY)) {
            nextItem = null;
            if (i < numItems - 1) {
                nextItem = (PieChartDescriptionItem)items.get(i + 1);
                nextPos = nextItem.getPosition();
                if (itemPos.getY() + item2.getHeight(viewport, graphics) >= nextPos.getY()) {
                    item2.moveTo(0.0, nextPos.getY() - (item2.getHeight(viewport, graphics) + 1.0));
                }
            }
            lastItemIdx = i++;
        }
        for (i = numItems - 1; i > lastItemIdx; --i) {
            double delta;
            item2 = (PieChartDescriptionItem)items.get(i);
            itemPos = item2.getPosition();
            nextItem = null;
            if (i <= lastItemIdx || !((delta = (nextPos = (nextItem = (PieChartDescriptionItem)items.get(i - 1)).getPosition()).getY() + nextItem.getHeight(viewport, graphics) - itemPos.getY() + 1.0) > 0.0)) continue;
            item2.move(0.0, delta);
            if (i >= numItems - 1) continue;
            for (int j = i + 1; j < numItems; ++j) {
                PieChartDescriptionItem itm = (PieChartDescriptionItem)items.get(j);
                ChartItemPosition itmPos = itm.getPosition();
                itm.moveTo(0.0, itmPos.getY() + delta);
            }
        }
        PieChartDescriptionItem lastItem = (PieChartDescriptionItem)items.get(numItems - 1);
        double bottomPosDelta = lastItem.getPosition().getY() + lastItem.getHeight(viewport, graphics) - viewport.getHeight();
        double topPos = lastItem.getPosition().getY() - bottomPosDelta;
        if (bottomPosDelta > 0.0) {
            for (int i2 = numItems - 1; i2 >= lastItemIdx; --i2) {
                item = (PieChartDescriptionItem)items.get(i2);
                item.move(0.0, -bottomPosDelta);
                topPos = item.getPosition().getY();
            }
        }
        for (int i3 = lastItemIdx - 1; i3 >= 0; --i3) {
            item = (PieChartDescriptionItem)items.get(i3);
            ChartItemPosition itemPos2 = item.getPosition();
            double delta = topPos - (itemPos2.getY() + item.getHeight(viewport, graphics));
            if (delta < 0.0) {
                item.move(0.0, delta);
            }
            topPos = item.getPosition().getY();
        }
    }
}

