/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.ujac.chart.Base2DStackedChart;
import org.ujac.chart.ChartException;

public class StackedAreaChart2D
extends Base2DStackedChart {
    public boolean getFillArea() {
        if (this.attributes.isDefined("fill-area")) {
            return this.attributes.getBoolean("fill-area");
        }
        return true;
    }

    private Color getFillColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new Color(r, g, b, 128);
    }

    public Rectangle2D draw(Rectangle2D viewport, Graphics2D graphics) throws ChartException {
        Color color;
        int j;
        Rectangle2D localViewport = super.draw(viewport, graphics);
        if (this.model == null || this.model.getChartData() == null) {
            return localViewport;
        }
        Color[] segmentColors = this.attributes.getColorArray("segment-colors");
        List chartData = this.model.getChartData();
        int numSegments = chartData.size();
        Rectangle effectiveViewport = this.calcViewport(localViewport, graphics);
        this.drawScale(localViewport, effectiveViewport, graphics);
        this.drawLegend(localViewport, graphics);
        Stroke oldStroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(this.getLineWidth(), 1, 1));
        float[][] yPositions = new float[this.model.getNumAreas()][];
        GeneralPath[] segmentPaths = new GeneralPath[this.model.getNumAreas()];
        GeneralPath[] segmentAreas = new GeneralPath[this.model.getNumAreas()];
        boolean fillArea = this.getFillArea();
        float nullPos = this.calculateBaseLinePosition();
        int numAreas = this.model.getNumAreas();
        for (int i = 0; i < numSegments; ++i) {
            double[] row = (double[])chartData.get(i);
            float curPos = this.horizontalPositions[i];
            float yOffset = nullPos;
            for (int j2 = 0; j2 < numAreas; ++j2) {
                float verticalExtent = this.calculateVerticalExtent(row[j2]);
                float yPos = yOffset -= verticalExtent;
                if (i == 0) {
                    yPositions[j2] = new float[numSegments];
                    yPositions[j2][i] = yPos;
                    segmentPaths[j2] = new GeneralPath();
                    segmentPaths[j2].moveTo(curPos, yPos);
                    if (!fillArea) continue;
                    segmentAreas[j2] = new GeneralPath();
                    if (j2 == 0) {
                        segmentAreas[j2].moveTo(curPos, nullPos);
                        segmentAreas[j2].lineTo(curPos, yPos);
                        continue;
                    }
                    segmentAreas[j2].moveTo(curPos, yPos);
                    continue;
                }
                yPositions[j2][i] = yPos;
                segmentPaths[j2].lineTo(curPos, yPos);
                if (!fillArea) continue;
                segmentAreas[j2].lineTo(curPos, yPos);
                if (j2 != 0 || i != numSegments - 1) continue;
                segmentAreas[j2].lineTo(curPos, nullPos);
            }
        }
        if (fillArea) {
            for (j = 1; j < numAreas; ++j) {
                GeneralPath segmentArea = segmentAreas[j];
                for (int i = numSegments - 1; i >= 0; --i) {
                    float[] yPos = yPositions[j - 1];
                    float curPos = this.horizontalPositions[i];
                    segmentArea.lineTo(curPos, yPos[i]);
                }
            }
        }
        if (fillArea) {
            for (j = 0; j < segmentPaths.length; ++j) {
                color = segmentColors[j];
                graphics.setColor(this.getFillColor(color));
                graphics.fill(segmentAreas[j]);
            }
        }
        for (j = 0; j < segmentPaths.length; ++j) {
            color = segmentColors[j];
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(this.getLineWidth(), 1, 1));
            graphics.draw(segmentPaths[j]);
        }
        graphics.setStroke(oldStroke);
        return localViewport;
    }
}

