/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ujac.print.AliasTagBuilder;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DefaultTagBuilder;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentTagFactory;
import org.ujac.print.TagBuilder;
import org.ujac.print.TagInstantiationException;
import org.ujac.print.tag.AddColumnTag;
import org.ujac.print.tag.AddRowTag;
import org.ujac.print.tag.AlterColumnTag;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.AnnotationTag;
import org.ujac.print.tag.AssertTag;
import org.ujac.print.tag.AttributeTag;
import org.ujac.print.tag.BackgroundImageTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BoldTag;
import org.ujac.print.tag.BoxTag;
import org.ujac.print.tag.CaseTag;
import org.ujac.print.tag.ChapterTag;
import org.ujac.print.tag.ChartTag;
import org.ujac.print.tag.ColorDefTag;
import org.ujac.print.tag.ColumnTextTag;
import org.ujac.print.tag.CustomTagTag;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DateFormatTag;
import org.ujac.print.tag.DefaultTag;
import org.ujac.print.tag.DefineColumnTag;
import org.ujac.print.tag.DefineTableTag;
import org.ujac.print.tag.DocumentTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.EncryptionTag;
import org.ujac.print.tag.ExtraRowTag;
import org.ujac.print.tag.FontDefTag;
import org.ujac.print.tag.FontTag;
import org.ujac.print.tag.FooterPartTag;
import org.ujac.print.tag.FooterTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.HeadTag;
import org.ujac.print.tag.HeaderPartTag;
import org.ujac.print.tag.HeaderTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.IndexTag;
import org.ujac.print.tag.InsertColumnTag;
import org.ujac.print.tag.InsertDocumentTag;
import org.ujac.print.tag.ItalicTag;
import org.ujac.print.tag.ItemTag;
import org.ujac.print.tag.ItemsTag;
import org.ujac.print.tag.JavascriptTag;
import org.ujac.print.tag.ListItemTag;
import org.ujac.print.tag.ListSymbolTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroDefTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.MetaTag;
import org.ujac.print.tag.ModuleTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NewPageTag;
import org.ujac.print.tag.NumberFormatTag;
import org.ujac.print.tag.OutlineTag;
import org.ujac.print.tag.OverlayTag;
import org.ujac.print.tag.PageFormatTag;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.print.tag.ParameterDefTag;
import org.ujac.print.tag.ParameterTag;
import org.ujac.print.tag.PdfCellBlockTag;
import org.ujac.print.tag.PdfCellTag;
import org.ujac.print.tag.PdfTableHeaderTag;
import org.ujac.print.tag.PdfTableRowTag;
import org.ujac.print.tag.PdfTableSplitTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.PrintFooterRowTag;
import org.ujac.print.tag.PrintGroupRowTag;
import org.ujac.print.tag.PrintGroupTitleRowTag;
import org.ujac.print.tag.PrintHeaderRowTag;
import org.ujac.print.tag.PrintRowTag;
import org.ujac.print.tag.PrintTableTag;
import org.ujac.print.tag.RegisterFontTag;
import org.ujac.print.tag.RegisterTagTag;
import org.ujac.print.tag.RemoveColumnTag;
import org.ujac.print.tag.ResourceBundleTag;
import org.ujac.print.tag.RowCellTag;
import org.ujac.print.tag.SectionTag;
import org.ujac.print.tag.SegmentTag;
import org.ujac.print.tag.SetFieldTag;
import org.ujac.print.tag.SetFormatTag;
import org.ujac.print.tag.SetPropertyTag;
import org.ujac.print.tag.SpaceTag;
import org.ujac.print.tag.SpanTag;
import org.ujac.print.tag.StickyTag;
import org.ujac.print.tag.StyleDefTag;
import org.ujac.print.tag.SubscriptTag;
import org.ujac.print.tag.SuperscriptTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TextChartItemTag;
import org.ujac.print.tag.TocTag;
import org.ujac.print.tag.TogglePropertyTag;
import org.ujac.print.tag.UnderlineTag;
import org.ujac.print.tag.ViewerPreferencesTag;
import org.ujac.print.tag.WatermarkTag;
import org.ujac.print.tag.acroform.CheckBoxAcroFieldTag;
import org.ujac.print.tag.acroform.ComboBoxAcroFieldTag;
import org.ujac.print.tag.acroform.HiddenFieldAcroFieldTag;
import org.ujac.print.tag.acroform.OptionTag;
import org.ujac.print.tag.acroform.PostButtonAcroFieldTag;
import org.ujac.print.tag.acroform.RadioButtonAcroFieldTag;
import org.ujac.print.tag.acroform.RadioGroupAcroFieldTag;
import org.ujac.print.tag.acroform.ResetButtonAcroFieldTag;
import org.ujac.print.tag.acroform.SelectListAcroFieldTag;
import org.ujac.print.tag.acroform.TextFieldAcroFieldTag;
import org.ujac.print.tag.graphics.DrawCircleTag;
import org.ujac.print.tag.graphics.DrawCurveTag;
import org.ujac.print.tag.graphics.DrawEllipseTag;
import org.ujac.print.tag.graphics.DrawLineTag;
import org.ujac.print.tag.graphics.DrawPolyLineTag;
import org.ujac.print.tag.graphics.DrawPolygonTag;
import org.ujac.print.tag.graphics.DrawRectangleTag;
import org.ujac.print.tag.graphics.GraphicsTag;
import org.ujac.print.tag.graphics.PointTag;
import org.ujac.print.tag.graphics.SetFillColorTag;
import org.ujac.print.tag.graphics.SetLineCapTag;
import org.ujac.print.tag.graphics.SetLineDashTag;
import org.ujac.print.tag.graphics.SetLineJoinTag;
import org.ujac.print.tag.graphics.SetLineWidthTag;
import org.ujac.print.tag.graphics.SetStrokeColorTag;

public class DefaultDocumentTagFactory
implements DocumentTagFactory {
    private static final DocumentTagFactory DEFAULT_INSTANCE = new DefaultDocumentTagFactory();
    private final Map tagTypes = new HashMap();

    public static final DocumentTagFactory getInstance() {
        return DEFAULT_INSTANCE;
    }

    public DefaultDocumentTagFactory() {
        this.registerDefaultTags();
    }

    public final BaseDocumentTag createTagInstance(DocumentHandler documentHandler, String name) throws TagInstantiationException {
        TagBuilder builder = (TagBuilder)this.tagTypes.get(name);
        if (builder == null) {
            throw new TagInstantiationException(documentHandler.locator(), "Unable to create unknown tag '" + name + "'.");
        }
        BaseDocumentTag tag = builder.createTag(documentHandler);
        tag.setTagFactory(this);
        return tag;
    }

    public final boolean isTagSupported(String name) {
        TagBuilder builder = (TagBuilder)this.tagTypes.get(name);
        return builder != null;
    }

    public final void registerTag(String name, Class tagClazz) {
        this.tagTypes.put(name, new DefaultTagBuilder(name, tagClazz));
    }

    public final void registerTag(String name, TagBuilder tagBuilder) {
        this.tagTypes.put(name, tagBuilder);
    }

    public final void unregisterTag(String tagName) {
        TagBuilder builder = (TagBuilder)this.tagTypes.remove(tagName);
        if (builder != null) {
            builder.unregisterAlias(tagName);
        }
    }

    public void registerTagAlias(String tagName, String alias) throws TagInstantiationException {
        TagBuilder builder = (TagBuilder)this.tagTypes.get(tagName);
        if (builder == null) {
            throw new TagInstantiationException(null, "Unknown tag '" + tagName + "'.");
        }
        this.tagTypes.put(alias, new AliasTagBuilder(alias, builder));
    }

    protected void registerDefaultTags() {
        this.registerTag("document", DocumentTag.class);
        this.registerTag("page-format", PageFormatTag.class);
        this.registerTag("register-font", RegisterFontTag.class);
        this.registerTag("register-tag", RegisterTagTag.class);
        this.registerTag("style-def", StyleDefTag.class);
        this.registerTag("color-def", ColorDefTag.class);
        this.registerTag("font-def", FontDefTag.class);
        this.registerTag("font", FontTag.class);
        this.registerTag("b", BoldTag.class);
        this.registerTag("i", ItalicTag.class);
        this.registerTag("u", UnderlineTag.class);
        this.registerTag("span", SpanTag.class);
        this.registerTag("paragraph", ParagraphTag.class);
        this.registerTag("phrase", PhraseTag.class);
        this.registerTag("table", PdfTableTag.class);
        this.registerTag("table-header", PdfTableHeaderTag.class);
        this.registerTag("table-row", PdfTableRowTag.class);
        this.registerTag("cell", PdfCellTag.class);
        this.registerTag("table-split", PdfTableSplitTag.class);
        this.registerTag("cell-block", PdfCellBlockTag.class);
        this.registerTag("if", IfTag.class);
        this.registerTag("else", ElseTag.class);
        this.registerTag("foreach", ForeachTag.class);
        this.registerTag("image", ImageTag.class);
        this.registerTag("sticky", StickyTag.class);
        this.registerTag("background-image", BackgroundImageTag.class);
        this.registerTag("watermark", WatermarkTag.class);
        this.registerTag("header", HeaderTag.class);
        this.registerTag("header-part", HeaderPartTag.class);
        this.registerTag("footer", FooterTag.class);
        this.registerTag("footer-part", FooterPartTag.class);
        this.registerTag("br", NewLineTag.class);
        this.registerTag("new-page", NewPageTag.class);
        this.registerTag("switch", SwitchTag.class);
        this.registerTag("case", CaseTag.class);
        this.registerTag("default", DefaultTag.class);
        this.registerTag("space", SpaceTag.class);
        this.registerTag("number-format", NumberFormatTag.class);
        this.registerTag("date-format", DateFormatTag.class);
        this.registerTag("chart", ChartTag.class);
        this.registerTag("text-chart-item", TextChartItemTag.class);
        this.registerTag("barcode", BarcodeTag.class);
        this.registerTag("datamatrix", DatamatrixTag.class);
        this.registerTag("barcode-pdf-417", BarcodePdf417Tag.class);
        this.registerTag("import", ImportTag.class);
        this.registerTag("macro", MacroTag.class);
        this.registerTag("parameter", ParameterTag.class);
        this.registerTag("item", ItemTag.class);
        this.registerTag("items", ItemsTag.class);
        this.registerTag("macro-def", MacroDefTag.class);
        this.registerTag("parameter-def", ParameterDefTag.class);
        this.registerTag("outline", OutlineTag.class);
        this.registerTag("set-format", SetFormatTag.class);
        this.registerTag("set-property", SetPropertyTag.class);
        this.registerTag("assert", AssertTag.class);
        this.registerTag("resource-bundle", ResourceBundleTag.class);
        this.registerTag("print-table", PrintTableTag.class);
        this.registerTag("define-column", DefineColumnTag.class);
        this.registerTag("insert-column", InsertColumnTag.class);
        this.registerTag("alter-column", AlterColumnTag.class);
        this.registerTag("remove-column", RemoveColumnTag.class);
        this.registerTag("print-row", PrintRowTag.class);
        this.registerTag("print-header-row", PrintHeaderRowTag.class);
        this.registerTag("print-group-title-row", PrintGroupTitleRowTag.class);
        this.registerTag("print-group-row", PrintGroupRowTag.class);
        this.registerTag("print-footer-row", PrintFooterRowTag.class);
        this.registerTag("row-cell", RowCellTag.class);
        this.registerTag("chapter", ChapterTag.class);
        this.registerTag("section", SectionTag.class);
        this.registerTag("annotation", AnnotationTag.class);
        this.registerTag("anchor", AnchorTag.class);
        this.registerTag("list", ListTag.class);
        this.registerTag("list-symbol", ListSymbolTag.class);
        this.registerTag("list-item", ListItemTag.class);
        this.registerTag("meta", MetaTag.class);
        this.registerTag("custom-tag", CustomTagTag.class);
        this.registerTag("attribute", AttributeTag.class);
        this.registerTag("module", ModuleTag.class);
        this.registerTag("overlay", OverlayTag.class);
        this.registerTag("box", BoxTag.class);
        this.registerTag("toggle-property", TogglePropertyTag.class);
        this.registerTag("extra-row", ExtraRowTag.class);
        this.registerTag("column-text", ColumnTextTag.class);
        this.registerTag("head", HeadTag.class);
        this.registerTag("toc", TocTag.class);
        this.registerTag("index", IndexTag.class);
        this.registerTag("insert-document", InsertDocumentTag.class);
        this.registerTag("sub", SubscriptTag.class);
        this.registerTag("super", SuperscriptTag.class);
        this.registerTag("viewer-preferences", ViewerPreferencesTag.class);
        this.registerTag("encryption", EncryptionTag.class);
        this.registerTag("segment", SegmentTag.class);
        this.registerTag("log", LogTag.class);
        this.registerTag("define-table", DefineTableTag.class);
        this.registerTag("add-column", AddColumnTag.class);
        this.registerTag("add-row", AddRowTag.class);
        this.registerTag("set-field", SetFieldTag.class);
        this.registerTag("javascript", JavascriptTag.class);
        this.registerTag("option", OptionTag.class);
        this.registerTag("check-box", CheckBoxAcroFieldTag.class);
        this.registerTag("combo-box", ComboBoxAcroFieldTag.class);
        this.registerTag("hidden-field", HiddenFieldAcroFieldTag.class);
        this.registerTag("post-button", PostButtonAcroFieldTag.class);
        this.registerTag("reset-button", ResetButtonAcroFieldTag.class);
        this.registerTag("select-list", SelectListAcroFieldTag.class);
        this.registerTag("text-field", TextFieldAcroFieldTag.class);
        this.registerTag("radio-group", RadioGroupAcroFieldTag.class);
        this.registerTag("radio-button", RadioButtonAcroFieldTag.class);
        this.registerTag("graphics", GraphicsTag.class);
        this.registerTag("set-stroke-color", SetStrokeColorTag.class);
        this.registerTag("set-fill-color", SetFillColorTag.class);
        this.registerTag("set-line-width", SetLineWidthTag.class);
        this.registerTag("set-line-cap", SetLineCapTag.class);
        this.registerTag("set-line-join", SetLineJoinTag.class);
        this.registerTag("set-line-dash", SetLineDashTag.class);
        this.registerTag("draw-line", DrawLineTag.class);
        this.registerTag("draw-rectangle", DrawRectangleTag.class);
        this.registerTag("draw-circle", DrawCircleTag.class);
        this.registerTag("draw-ellipse", DrawEllipseTag.class);
        this.registerTag("draw-curve", DrawCurveTag.class);
        this.registerTag("point", PointTag.class);
        this.registerTag("draw-poly-line", DrawPolyLineTag.class);
        this.registerTag("draw-polygon", DrawPolygonTag.class);
        try {
            this.registerTagAlias("paragraph", "p");
            this.registerTagAlias("table-row", "tr");
            this.registerTagAlias("table-header", "th");
            this.registerTagAlias("cell", "td");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Map getTagTypes() {
        return this.tagTypes;
    }

    public List getAllPossibleChilds() throws TagInstantiationException {
        ArrayList<BaseDocumentTag> allChilds = new ArrayList<BaseDocumentTag>();
        Iterator typeIter = this.tagTypes.entrySet().iterator();
        while (typeIter.hasNext()) {
            Map.Entry typeEntry = typeIter.next();
            String childName = (String)typeEntry.getKey();
            BaseDocumentTag tagInstance = this.createTagInstance(null, childName);
            if (tagInstance.isDocumentRoot()) continue;
            allChilds.add(tagInstance);
        }
        return allChilds;
    }

    public List getSupportedChildTags(BaseDocumentTag tag) throws TagInstantiationException {
        ArrayList supportedChildItems = new ArrayList();
        ChildDefinitionMap supportedChilds = tag.getSupportedChilds();
        if (supportedChilds == null) {
            return supportedChildItems;
        }
        List possibleChilds = this.getAllPossibleChilds();
        int numPossibleChilds = possibleChilds.size();
        List supportedChildList = supportedChilds.getSortedChilds();
        int numSupportedChilds = supportedChildList.size();
        for (int i = 0; i < numSupportedChilds; ++i) {
            ChildDefinition childDef = (ChildDefinition)supportedChildList.get(i);
            Class childType = childDef.getType();
            for (int j = 0; j < numPossibleChilds; ++j) {
                Object itemInstance = possibleChilds.get(j);
                if (!childType.isInstance(itemInstance)) continue;
                supportedChildItems.add(itemInstance);
            }
        }
        return supportedChildItems;
    }
}

