/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandler;
import org.ujac.print.TagBuilder;
import org.ujac.print.TagInstantiationException;
import org.xml.sax.Locator;

public class DefaultTagBuilder
implements TagBuilder {
    private String name;
    private Class clazz;
    private Set aliases = null;

    public DefaultTagBuilder(String name, Class clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public BaseDocumentTag createTag(DocumentHandler documentHandler) throws TagInstantiationException {
        Locator locator = null;
        if (documentHandler != null) {
            locator = documentHandler.locator();
        }
        try {
            return (BaseDocumentTag)this.clazz.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new TagInstantiationException(locator, "The tag type '" + this.name + "' is not allowed to be accessed: " + ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new TagInstantiationException(locator, "The tag type '" + this.name + "' cannot get instanciated: " + ex.getMessage(), ex);
        }
    }

    public void registerAlias(String alias) {
        if (this.aliases == null) {
            this.aliases = new HashSet();
        }
        this.aliases.add(alias);
    }

    public void unregisterAlias(String alias) {
        if (this.aliases == null) {
            return;
        }
        this.aliases.remove(alias);
    }

    public Collection getAliases() {
        return this.aliases;
    }
}

