/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPrinter;
import org.ujac.print.DocumentTagFactory;
import org.ujac.print.TagBuilder;
import org.ujac.print.TagInstantiationException;

public class DocumentationGenerator {
    private DocumentTagFactory tagFactory = null;

    public DocumentationGenerator(DocumentTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    private void generateDocumentation(InputStream documentationTempleteStream, OutputStream outputStream) throws DocumentHandlerException, IOException {
        try {
            DocumentHandler docHandler = new DocumentHandler(null, null, this.tagFactory);
            ArrayList<BaseDocumentTag> tags = new ArrayList<BaseDocumentTag>();
            Iterator typeIter = this.tagFactory.getTagTypes().entrySet().iterator();
            while (typeIter.hasNext()) {
                Map.Entry typeEntry = typeIter.next();
                TagBuilder builder = (TagBuilder)typeEntry.getValue();
                BaseDocumentTag tag = builder.createTag(docHandler);
                tag.setDocumentHandler(docHandler);
                tag.setTagFactory(this.tagFactory);
                tags.add(tag);
            }
            Collections.sort(tags, new TagNameComarator());
            HashMap<String, ArrayList<BaseDocumentTag>> properties = new HashMap<String, ArrayList<BaseDocumentTag>>();
            properties.put("tags", tags);
            DocumentPrinter docPrinter = new DocumentPrinter(documentationTempleteStream, properties);
            docPrinter.printDocument(outputStream);
        }
        catch (TagInstantiationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("usage: org.ujac.print.DocumentationGenerator [<output file> <tag factory class>]");
            System.exit(1);
        }
        try {
            OutputStream outputStream = null;
            DocumentTagFactory tagFactory = null;
            if (args.length < 1) {
                outputStream = System.out;
                tagFactory = new DocumentPrinter().getTagFactory();
            } else {
                outputStream = new FileOutputStream(args[0]);
                tagFactory = args.length > 1 ? (DocumentTagFactory)Class.forName(args[1]).newInstance() : new DocumentPrinter().getTagFactory();
            }
            DocumentationGenerator dg = new DocumentationGenerator(tagFactory);
            InputStream documentationTempleteStream = DocumentationGenerator.class.getClassLoader().getResourceAsStream("org/ujac/print/documentation-template.xml");
            dg.generateDocumentation(documentationTempleteStream, outputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (DocumentHandlerException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static class TagNameComarator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            BaseDocumentTag item1 = (BaseDocumentTag)o1;
            BaseDocumentTag item2 = (BaseDocumentTag)o2;
            return item1.getName().compareTo(item2.getName());
        }
    }
}

