/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Anchor;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import java.net.MalformedURLException;
import java.net.URL;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.PhraseHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.util.template.TemplateException;

public class AnchorTag
extends BaseElementTag {
    private static final AttributeDefinition ANCHOR_NAME = CommonAttributes.NAME.cloneAttrDef("The anchor name.").setRequired(false);
    private static final AttributeDefinition REFERENCE = new AttributeDefinition("reference", 4, false, "The anchor reference.");
    public static final String TAG_NAME = "anchor";
    protected PhraseHolder phraseHolder = null;

    public AnchorTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds an anchor to the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(ANCHOR_NAME).addDefinition(REFERENCE).addDefinition(CommonAttributes.FONT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.phraseHolder = this.documentHandler.latestPhraseHolder();
    }

    public void closeItem() throws DocumentHandlerException {
        Anchor anchor;
        if (!this.isValid()) {
            return;
        }
        String content = this.getContent();
        if (content == null) {
            content = "";
        } else {
            try {
                content = this.documentHandler.executeTemplate(this.getContent());
            }
            catch (TemplateException ex) {
                throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
            }
        }
        StringBuffer cntBuf = new StringBuffer();
        this.filterContents(this, content, cntBuf, false);
        content = cntBuf.toString();
        String name = this.getStringAttribute(ANCHOR_NAME, true, null);
        String reference = this.getStringAttribute(REFERENCE, true, null);
        if (name != null && reference != null) {
            throw new TagAttributeException(this.locator(), "Please define eighter the name or the reference of an anchor, not both!");
        }
        ElementContainer elementContainer = this.getElementContainer();
        if (name != null) {
            anchor = new Anchor(content, this.getFont().getFont());
            anchor.setName(name);
            elementContainer.addElement(this, (Element)anchor);
        }
        if (reference != null) {
            if (this.phraseHolder != null) {
                try {
                    Chunk chunk = this.createChunk(content, this.getFont());
                    if (this.documentHandler.isDestinationsSupported()) {
                        if (reference.startsWith("#")) {
                            chunk.setLocalGoto(reference.substring(1));
                        } else {
                            chunk.setAnchor(new URL(reference));
                        }
                    }
                    this.phraseHolder.addChunk(this, chunk);
                }
                catch (MalformedURLException ex) {
                    throw new TagAttributeException(this.locator(), "Detected illegal URL '" + reference + "' as reference for an anchor.", ex);
                }
            } else {
                anchor = new Anchor(content, this.getFont().getFont());
                anchor.setReference(reference);
                elementContainer.addElement(this, (Element)anchor);
            }
        }
    }
}

